/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container;

import java.nio.charset.Charset;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.apache.http.HeaderElement;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.jasig.portal.portlet.container.PortletMimeResponseContextImpl;
import org.jasig.portal.portlet.container.properties.IRequestPropertiesManager;
import org.jasig.portal.portlet.container.services.IPortletCookieService;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;
import org.jasig.portal.url.IPortalUrlProvider;

public class PortletResourceResponseContextImpl
extends PortletMimeResponseContextImpl
implements PortletResourceResponseContext {
    private final PortletResourceOutputHandler portletResourceOutputHandler = (PortletResourceOutputHandler)this.getPortletOutputHandler();

    public PortletResourceResponseContextImpl(PortletContainer portletContainer, IPortletWindow portletWindow, HttpServletRequest containerRequest, HttpServletResponse containerResponse, IRequestPropertiesManager requestPropertiesManager, IPortalUrlProvider portalUrlProvider, IPortletCookieService portletCookieService) {
        super(portletContainer, portletWindow, containerRequest, containerResponse, requestPropertiesManager, portalUrlProvider, portletCookieService);
    }

    public void setCharacterEncoding(String charset) {
        this.checkContextStatus();
        this.portletResourceOutputHandler.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.checkContextStatus();
        this.portletResourceOutputHandler.setContentLength(len);
    }

    public void setLocale(Locale locale) {
        this.checkContextStatus();
        this.portletResourceOutputHandler.setLocale(locale);
    }

    protected boolean managerSetProperty(String key, String value) {
        boolean handled = super.managerSetProperty(key, value);
        if (!handled) {
            if (this.handleResourceHeader(key, value)) {
                return true;
            }
            this.portletResourceOutputHandler.setHeader(key, value);
        }
        return true;
    }

    protected boolean managerAddProperty(String key, String value) {
        boolean handled = super.managerAddProperty(key, value);
        if (!handled) {
            if (this.handleResourceHeader(key, value)) {
                return true;
            }
            this.portletResourceOutputHandler.addHeader(key, value);
        }
        return true;
    }

    protected boolean handleResourceHeader(String key, String value) {
        HeaderElement[] parts;
        if ("portlet.http-status-code".equals(key)) {
            this.portletResourceOutputHandler.setStatus(Integer.parseInt(value));
            return true;
        }
        if ("Content-Type".equals(key)) {
            ContentType contentType = ContentType.parse((String)value);
            Charset charset = contentType.getCharset();
            if (charset != null) {
                this.portletResourceOutputHandler.setCharacterEncoding(charset.name());
            }
            this.portletResourceOutputHandler.setContentType(contentType.getMimeType());
            return true;
        }
        if ("Content-Length".equals(key)) {
            this.portletResourceOutputHandler.setContentLength(Integer.parseInt(value));
            return true;
        }
        if ("Content-Language".equals(key) && (parts = BasicHeaderValueParser.parseElements((String)value, null)).length > 0) {
            String localeStr = parts[0].getValue();
            Locale locale = LocaleUtils.toLocale((String)localeStr);
            this.portletResourceOutputHandler.setLocale(locale);
            return true;
        }
        return false;
    }
}

