/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.ResourceURLProvider;
import org.jasig.portal.portlet.container.AbstractPortletContextImpl;
import org.jasig.portal.portlet.container.properties.IRequestPropertiesManager;
import org.jasig.portal.portlet.container.services.IPortletCookieService;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.url.ResourceUrlProviderImpl;
import org.springframework.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PortletResponseContextImpl
extends AbstractPortletContextImpl
implements PortletResponseContext {
    private boolean closed = false;
    private boolean released = false;
    protected final IRequestPropertiesManager requestPropertiesManager;

    public PortletResponseContextImpl(PortletContainer portletContainer, IPortletWindow portletWindow, HttpServletRequest containerRequest, HttpServletResponse containerResponse, IRequestPropertiesManager requestPropertiesManager, IPortletCookieService portletCookieService) {
        super(portletContainer, portletWindow, containerRequest, containerResponse, portletCookieService);
        Assert.notNull((Object)requestPropertiesManager, (String)"requestPropertiesManager can not be null");
        this.requestPropertiesManager = requestPropertiesManager;
    }

    public void addProperty(Cookie cookie) {
        IPortletWindowId portletWindowId = this.portletWindow.getPortletWindowId();
        this.portletCookieService.addCookie(this.servletRequest, portletWindowId, cookie);
    }

    public final void addProperty(String key, Element element) {
    }

    public final void addProperty(String key, String value) {
        this.managerAddProperty(key, value);
    }

    public final void setProperty(String key, String value) {
        this.managerSetProperty(key, value);
    }

    protected boolean managerSetProperty(String key, String value) {
        return this.requestPropertiesManager.setResponseProperty(this.servletRequest, this.portletWindow, key, value);
    }

    protected boolean managerAddProperty(String key, String value) {
        return this.requestPropertiesManager.addResponseProperty(this.servletRequest, this.portletWindow, key, value);
    }

    public Element createElement(String tagName) throws DOMException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            return doc.createElement(tagName);
        }
        catch (ParserConfigurationException e) {
            throw new DOMException(0, "Initialization failure");
        }
    }

    public ResourceURLProvider getResourceURLProvider() {
        return new ResourceUrlProviderImpl(this.portletWindow, this.containerRequest);
    }

    public void close() {
        this.closed = true;
    }

    public void release() {
        this.closed = true;
        this.released = true;
        this.servletRequest = null;
        this.servletResponse = null;
    }

    protected void checkContextStatus() {
        if (this.closed || this.released) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isReleased() {
        return this.released;
    }
}

