/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.CacheControl;
import org.jasig.portal.portlet.container.cache.CachedPortletData;
import org.jasig.portal.portlet.container.cache.CachedPortletResourceData;
import org.jasig.portal.portlet.container.cache.CachingPortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;

public class CachingPortletResourceOutputHandler
extends CachingPortletOutputHandler
implements PortletResourceOutputHandler {
    private final PortletResourceOutputHandler portletResourceOutputHandler;
    private final Map<String, List<Serializable>> headers = new LinkedHashMap();
    private Integer status;
    private String characterEncoding;
    private Integer contentLength;
    private Locale locale;

    public CachingPortletResourceOutputHandler(PortletResourceOutputHandler portletResourceOutputHandler, int maximumSize) {
        super((PortletOutputHandler)portletResourceOutputHandler, maximumSize);
        this.portletResourceOutputHandler = portletResourceOutputHandler;
    }

    public <T extends Serializable> CachedPortletResourceData<T> getCachedPortletResourceData(T portletResult, CacheControl cacheControl) {
        if (this.status != null && this.status != 200) {
            return null;
        }
        CachedPortletData cachedPortletData = super.getCachedPortletData(portletResult, cacheControl);
        if (cachedPortletData == null) {
            return null;
        }
        return new CachedPortletResourceData(cachedPortletData, this.headers, this.status, this.characterEncoding, this.contentLength, this.locale);
    }

    public Map<String, List<Serializable>> getHeaders() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public Integer getContentLength() {
        return this.contentLength;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCharacterEncoding(String charset) {
        this.portletResourceOutputHandler.setCharacterEncoding(charset);
        this.characterEncoding = charset;
    }

    public void setContentLength(int len) {
        this.portletResourceOutputHandler.setContentLength(len);
        this.contentLength = len;
    }

    public void setLocale(Locale locale) {
        this.portletResourceOutputHandler.setLocale(locale);
        this.locale = locale;
    }

    public void setStatus(int status) {
        this.portletResourceOutputHandler.setStatus(status);
        this.status = status;
    }

    public void setDateHeader(String name, long date) {
        this.portletResourceOutputHandler.setDateHeader(name, date);
        this.setGenericHeader(name, (Serializable)Long.valueOf(date));
    }

    public void addDateHeader(String name, long date) {
        this.portletResourceOutputHandler.addDateHeader(name, date);
        this.addGenericHeader(name, (Serializable)Long.valueOf(date));
    }

    public void setHeader(String name, String value) {
        this.portletResourceOutputHandler.setHeader(name, value);
        this.setGenericHeader(name, (Serializable)((Object)value));
    }

    public void addHeader(String name, String value) {
        this.portletResourceOutputHandler.addHeader(name, value);
        this.addGenericHeader(name, (Serializable)((Object)value));
    }

    public void setIntHeader(String name, int value) {
        this.portletResourceOutputHandler.setIntHeader(name, value);
        this.setGenericHeader(name, (Serializable)Integer.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.portletResourceOutputHandler.addIntHeader(name, value);
        this.addGenericHeader(name, (Serializable)Integer.valueOf(value));
    }

    protected final void addGenericHeader(String name, Serializable value) {
        LinkedList<Serializable> values = (LinkedList<Serializable>)this.headers.get(name);
        if (values == null) {
            values = new LinkedList<Serializable>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    protected final void setGenericHeader(String name, Serializable value) {
        LinkedList<Serializable> values = new LinkedList<Serializable>();
        values.add(value);
        this.headers.put(name, values);
    }
}

