/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.cache;

import java.util.concurrent.TimeUnit;
import org.jasig.portal.portlet.container.cache.CachedPortletData;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PortletCachingHeaderUtils {
    private static final int YEAR_OF_SECONDS = (int)TimeUnit.DAYS.toSeconds(365L);

    private PortletCachingHeaderUtils() {
    }

    public static void setCachingHeaders(CachedPortletData<?> cachedPortletData, PortletResourceOutputHandler portletResourceOutputHandler) {
        long expirationTime = cachedPortletData.getExpirationTime();
        int maxAge = (int)TimeUnit.MILLISECONDS.toSeconds(expirationTime - System.currentTimeMillis());
        long timeStored = cachedPortletData.getTimeStored();
        boolean publicScope = cachedPortletData.isPublicScope();
        PortletCachingHeaderUtils.setCachingHeaders((int)maxAge, (boolean)publicScope, (long)timeStored, (PortletResourceOutputHandler)portletResourceOutputHandler);
        String etag = cachedPortletData.getEtag();
        if (etag != null) {
            PortletCachingHeaderUtils.setETag((String)etag, (PortletResourceOutputHandler)portletResourceOutputHandler);
        }
    }

    public static void setCachingHeaders(int maxAge, boolean publicScope, long lastModified, PortletResourceOutputHandler portletResourceOutputHandler) {
        if (maxAge != 0) {
            portletResourceOutputHandler.setDateHeader("Last-Modified", lastModified);
            if (publicScope) {
                portletResourceOutputHandler.setHeader("CacheControl", "public");
            } else {
                portletResourceOutputHandler.setHeader("CacheControl", "private");
            }
            if (maxAge < 0) {
                maxAge = YEAR_OF_SECONDS;
            }
            portletResourceOutputHandler.setDateHeader("Expires", System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxAge));
            portletResourceOutputHandler.addHeader("CacheControl", "max-age=" + maxAge);
        }
    }

    public static void setETag(String token, PortletResourceOutputHandler portletResourceOutputHandler) {
        portletResourceOutputHandler.setHeader("ETag", token);
    }
}

