/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractPortletPreferencesImpl<C>
implements PortletPreferences {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean render;
    private Map<String, IPortletPreference> targetPortletPreferences;
    private Map<String, IPortletPreference> basePortletPreferences;
    private Map<String, IPortletPreference> compositePreferences;
    private Map<String, String[]> compositePreferencesView;
    private boolean modified = false;

    public AbstractPortletPreferencesImpl(boolean render) {
        this.render = render;
    }

    protected C getInitializationContext() {
        return null;
    }

    protected abstract Object getLogDescription();

    protected abstract void loadTargetPortletPreferences(C var1, Map<String, IPortletPreference> var2);

    protected abstract void loadBasePortletPreferences(C var1, Map<String, IPortletPreference> var2);

    protected abstract boolean storeInternal() throws IOException, ValidatorException;

    protected boolean isReadOnly(IPortletPreference portletPreference) {
        return portletPreference != null && portletPreference.isReadOnly();
    }

    private final void initPrefs() {
        if (this.compositePreferencesView != null) {
            return;
        }
        Object initContext = this.getInitializationContext();
        this.targetPortletPreferences = new LinkedHashMap();
        this.loadTargetPortletPreferences(initContext, this.targetPortletPreferences);
        this.basePortletPreferences = new LinkedHashMap();
        this.loadBasePortletPreferences(initContext, this.basePortletPreferences);
        this.compositePreferences = new LinkedHashMap(this.basePortletPreferences);
        this.compositePreferences.putAll(this.targetPortletPreferences);
        this.compositePreferencesView = Maps.transformValues((Map)this.compositePreferences, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private final void clearPrefs() {
        this.targetPortletPreferences = null;
        this.basePortletPreferences = null;
        this.compositePreferences = null;
        this.compositePreferencesView = null;
    }

    protected final Map<String, IPortletPreference> getTargetPortletPreferences() {
        this.initPrefs();
        return this.targetPortletPreferences;
    }

    protected final Map<String, IPortletPreference> getBasePortletPreferences() {
        this.initPrefs();
        return this.basePortletPreferences;
    }

    protected final Map<String, IPortletPreference> getCompositePortletPreferences() {
        this.initPrefs();
        return this.compositePreferences;
    }

    protected final Map<String, String[]> getCompositePortletPreferencesView() {
        this.initPrefs();
        return this.compositePreferencesView;
    }

    protected final IPortletPreference getPortletPreference(String key) {
        Assert.notNull((Object)key, (String)"Preference Key cannot be null");
        Map targetPortletPreferences = this.getTargetPortletPreferences();
        IPortletPreference portletPreference = (IPortletPreference)targetPortletPreferences.get(key);
        if (portletPreference != null) {
            return portletPreference;
        }
        Map basePortletPreferences = this.getBasePortletPreferences();
        return (IPortletPreference)basePortletPreferences.get(key);
    }

    public final boolean isReadOnly(String key) {
        IPortletPreference portletPreference = this.getPortletPreference(key);
        return portletPreference != null && portletPreference.isReadOnly();
    }

    public final String getValue(String key, String def) {
        IPortletPreference portletPreference = this.getPortletPreference(key);
        if (portletPreference != null) {
            String[] values = portletPreference.getValues();
            if (values == null || values.length == 0) {
                return def;
            }
            return values[0];
        }
        return def;
    }

    public final String[] getValues(String key, String[] def) {
        IPortletPreference portletPreference = this.getPortletPreference(key);
        if (portletPreference != null) {
            return portletPreference.getValues();
        }
        return def;
    }

    public final void setValue(String key, String value) throws ReadOnlyException {
        this.setValues(key, new String[]{value});
    }

    public final void setValues(String key, String[] values) throws ReadOnlyException {
        IPortletPreference portletPreference;
        Assert.notNull((Object)key, (String)"Preference Key cannot be null");
        Map targetPortletPreferences = this.getTargetPortletPreferences();
        Map basePortletPreferences = this.getBasePortletPreferences();
        IPortletPreference basePreference = (IPortletPreference)basePortletPreferences.get(key);
        if (basePreference != null) {
            if (this.isReadOnly(basePreference)) {
                throw new ReadOnlyException("Preference '" + key + "' is read only");
            }
            if (Arrays.equals(values, basePreference.getValues())) {
                this.reset(key);
                return;
            }
        }
        if ((portletPreference = (IPortletPreference)targetPortletPreferences.get(key)) == null) {
            portletPreference = new PortletPreferenceImpl(key, false, values != null ? (String[])values.clone() : null);
            targetPortletPreferences.put(key, portletPreference);
            Map compositePortletPreferences = this.getCompositePortletPreferences();
            compositePortletPreferences.put(key, portletPreference);
            this.modified = true;
        } else if (!Arrays.equals(values, portletPreference.getValues())) {
            portletPreference.setValues(values != null ? (String[])values.clone() : null);
            this.modified = true;
        }
    }

    public final Enumeration<String> getNames() {
        Map compositePortletPreferencesView = this.getCompositePortletPreferencesView();
        return Collections.enumeration(compositePortletPreferencesView.keySet());
    }

    public final Map<String, String[]> getMap() {
        return this.getCompositePortletPreferencesView();
    }

    public final void reset(String key) throws ReadOnlyException {
        Map basePortletPreferences = this.getBasePortletPreferences();
        IPortletPreference basePreference = (IPortletPreference)basePortletPreferences.get(key);
        if (this.isReadOnly(basePreference)) {
            throw new ReadOnlyException("Preference '" + key + "' is read only");
        }
        Map targetPortletPreferences = this.getTargetPortletPreferences();
        IPortletPreference removed = (IPortletPreference)targetPortletPreferences.remove(key);
        if (removed != null) {
            Map compositePortletPreferences = this.getCompositePortletPreferences();
            if (basePreference != null) {
                compositePortletPreferences.put(key, basePreference);
            } else {
                compositePortletPreferences.remove(key);
            }
            this.modified = true;
        }
    }

    public final void store() throws IOException, ValidatorException {
        if (this.render) {
            throw new IllegalStateException("store is not allowed during RENDER phase.");
        }
        if (!this.modified) {
            this.logger.debug("Skipping store of portlet preferences, nothing has changed: {}", this.getLogDescription());
            return;
        }
        boolean stored = this.storeInternal();
        if (stored) {
            this.logger.debug("Store of portlet preferences resulted in a change, clear preferences cache: {}", this.getLogDescription());
            this.clearPrefs();
        }
        this.modified = false;
    }
}

