/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.UserInfoService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.cas.CasProxyTicketAcquisitionException;
import org.jasig.portal.security.provider.cas.ICasSecurityContext;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class CasTicketUserInfoService
implements UserInfoService {
    private IUserInstanceManager userInstanceManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    protected final Log log = LogFactory.getLog(this.getClass());
    private String proxyTicketKey = "casProxyTicket";

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public String getProxyTicketKey() {
        return this.proxyTicketKey;
    }

    public void setProxyTicketKey(String proxyTicketKey) {
        this.proxyTicketKey = proxyTicketKey;
    }

    public Map<String, String> getUserInfo(PortletRequest request, PortletWindow portletWindow) throws PortletContainerException {
        String proxyTicket;
        HashMap<String, String> userInfo = new HashMap<String, String>();
        if (this.isCasProxyTicketRequested(request, portletWindow) && (proxyTicket = this.getProxyTicket(request)) != null) {
            userInfo.put(this.proxyTicketKey, proxyTicket);
        }
        return userInfo;
    }

    public boolean isCasProxyTicketRequested(PortletRequest request, PortletWindow plutoPortletWindow) throws PortletContainerException {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        PortletApplicationDefinition portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        List requestedUserAttributes = portletApplicationDescriptor.getUserAttributes();
        for (UserAttribute userAttributeDD : requestedUserAttributes) {
            String attributeName = userAttributeDD.getName();
            if (!attributeName.equals(this.proxyTicketKey)) continue;
            return true;
        }
        return false;
    }

    private String getProxyTicket(PortletRequest request) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        String targetService = null;
        try {
            URL url = null;
            int port = request.getServerPort();
            url = port == 80 || port == 443 ? new URL(request.getScheme(), request.getServerName(), request.getContextPath()) : new URL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
            targetService = url.toString();
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"Failed to create a URL for the target portlet", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(httpServletRequest);
        IPerson person = userInstance.getPerson();
        ISecurityContext context = person.getSecurityContext();
        if (context == null) {
            this.log.error((Object)"no security context, no proxy ticket passed to the portlet");
            return null;
        }
        ISecurityContext casContext = CasTicketUserInfoService.getCasContext((ISecurityContext)context);
        if (casContext == null) {
            this.log.debug((Object)"no CAS security context, no proxy ticket passed to the portlet");
            return null;
        }
        if (!casContext.isAuthenticated()) {
            this.log.debug((Object)"no CAS authentication, no proxy ticket passed to the portlet");
            return null;
        }
        String proxyTicket = null;
        try {
            proxyTicket = ((ICasSecurityContext)casContext).getCasServiceToken(targetService);
            this.log.debug((Object)("Put proxy ticket in userinfo: " + proxyTicket));
        }
        catch (CasProxyTicketAcquisitionException e) {
            this.log.error((Object)("no proxy ticket passed to the portlet: " + (Object)((Object)e)));
        }
        return proxyTicket;
    }

    private static ISecurityContext getCasContext(ISecurityContext context) {
        if (context instanceof ICasSecurityContext) {
            return context;
        }
        Enumeration contextEnum = context.getSubContexts();
        while (contextEnum.hasMoreElements()) {
            ISecurityContext subContext = (ISecurityContext)contextEnum.nextElement();
            if (!(subContext instanceof ICasSecurityContext)) continue;
            return subContext;
        }
        return null;
    }
}

