/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.jasig.portal.portlet.container.services.AbstractPortletPreferencesImpl;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;

public class GuestPortletEntityPreferencesImpl
extends AbstractPortletPreferencesImpl<IPortletEntity> {
    protected static final String PORTLET_PREFERENCES_MAP_ATTRIBUTE = GuestPortletEntityPreferencesImpl.class.getName() + ".PORTLET_PREFERENCES_MAP";
    private final PortletRequestContext portletRequestContext;
    private final IPortletEntityId portletEntityId;
    private final IPortletEntityRegistry portletEntityRegistry;
    private final IPortletDefinitionRegistry portletDefinitionRegistry;

    public GuestPortletEntityPreferencesImpl(PortletRequestContext portletRequestContext, IPortletEntityRegistry portletEntityRegistry, IPortletDefinitionRegistry portletDefinitionRegistry, IPortletEntityId portletEntityId, boolean render) {
        super(render);
        this.portletRequestContext = portletRequestContext;
        this.portletEntityRegistry = portletEntityRegistry;
        this.portletDefinitionRegistry = portletDefinitionRegistry;
        this.portletEntityId = portletEntityId;
    }

    protected IPortletEntity getInitializationContext() {
        HttpServletRequest containerRequest = this.portletRequestContext.getContainerRequest();
        return this.portletEntityRegistry.getPortletEntity(containerRequest, this.portletEntityId);
    }

    protected Object getLogDescription() {
        return this.getInitializationContext();
    }

    protected void loadTargetPortletPreferences(IPortletEntity portletEntity, Map<String, IPortletPreference> targetPortletPreferences) {
        HttpServletRequest containerRequest = this.portletRequestContext.getContainerRequest();
        Map sessionPreferences = this.getSessionPreferences(this.portletEntityId, containerRequest);
        if (sessionPreferences != null) {
            targetPortletPreferences.putAll(sessionPreferences);
        }
    }

    protected void loadBasePortletPreferences(IPortletEntity portletEntity, Map<String, IPortletPreference> basePortletPreferences) {
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinitionId);
        Preferences descriptorPreferences = portletDescriptor.getPortletPreferences();
        for (Preference preference : descriptorPreferences.getPortletPreferences()) {
            PortletPreferenceImpl preferenceWrapper = new PortletPreferenceImpl(preference);
            basePortletPreferences.put(preferenceWrapper.getName(), (IPortletPreference)preferenceWrapper);
        }
        List definitionPreferences = portletDefinition.getPortletPreferences();
        for (IPortletPreference preference : definitionPreferences) {
            basePortletPreferences.put(preference.getName(), preference);
        }
        List entityPreferences = portletEntity.getPortletPreferences();
        for (IPortletPreference preference : entityPreferences) {
            basePortletPreferences.put(preference.getName(), preference);
        }
    }

    protected boolean storeInternal() throws IOException, ValidatorException {
        Map targetPortletPreferences = this.getTargetPortletPreferences();
        if (targetPortletPreferences.isEmpty()) {
            return false;
        }
        HttpServletRequest containerRequest = this.portletRequestContext.getContainerRequest();
        this.storeSessionPreferences(this.portletEntityId, containerRequest, targetPortletPreferences);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IPortletPreference> getSessionPreferences(IPortletEntityId portletEntityId, HttpServletRequest httpServletRequest) {
        Map portletPreferences;
        HttpSession session;
        HttpSession httpSession = session = httpServletRequest.getSession();
        synchronized (httpSession) {
            portletPreferences = (Map)session.getAttribute(PORTLET_PREFERENCES_MAP_ATTRIBUTE);
        }
        if (portletPreferences == null) {
            return null;
        }
        return (Map)portletPreferences.get(portletEntityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeSessionPreferences(IPortletEntityId portletEntityId, HttpServletRequest httpServletRequest, Map<String, IPortletPreference> preferences) {
        ConcurrentHashMap<IPortletEntityId, Map<String, IPortletPreference>> portletPreferences;
        HttpSession session;
        HttpSession httpSession = session = httpServletRequest.getSession();
        synchronized (httpSession) {
            portletPreferences = (ConcurrentHashMap<IPortletEntityId, Map<String, IPortletPreference>>)session.getAttribute(PORTLET_PREFERENCES_MAP_ATTRIBUTE);
            if (portletPreferences == null) {
                portletPreferences = new ConcurrentHashMap<IPortletEntityId, Map<String, IPortletPreference>>();
                session.setAttribute(PORTLET_PREFERENCES_MAP_ATTRIBUTE, portletPreferences);
            }
        }
        portletPreferences.put(portletEntityId, preferences);
    }
}

