/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.RequestDispatcherService;
import org.apache.pluto.container.driver.DriverPortletConfig;
import org.apache.pluto.container.driver.DriverPortletContext;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletRegistryEvent;
import org.apache.pluto.container.driver.PortletRegistryListener;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.impl.PortletAppDescriptorServiceImpl;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.container.DriverPortletConfigImpl;
import org.apache.pluto.driver.container.DriverPortletContextImpl;
import org.jasig.portal.portlet.dao.jpa.ThreadContextClassLoaderAspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalPortletContextManager
implements PortletRegistryService,
PortletContextService {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String PORTLET_XML = "/WEB-INF/portlet.xml";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, DriverPortletContext> portletContexts = new ConcurrentHashMap();
    private final Map<String, DriverPortletConfig> portletConfigs = new ConcurrentHashMap();
    private final List<PortletRegistryListener> registryListeners = new CopyOnWriteArrayList();
    private final Map<String, ClassLoader> classLoaders = new ConcurrentHashMap();
    private final Map<ServletContext, PortletApplicationDefinition> portletAppDefinitionCache = new WeakHashMap();
    private PortletAppDescriptorService portletAppDescriptorService = new PortletAppDescriptorServiceImpl();
    private RequestDispatcherService requestDispatcherService;

    @Autowired
    public void setRequestDispatcherService(RequestDispatcherService requestDispatcherService) {
        this.requestDispatcherService = requestDispatcherService;
    }

    public void setPortletAppDescriptorService(PortletAppDescriptorService portletAppDescriptorService) {
        this.portletAppDescriptorService = portletAppDescriptorService;
    }

    public synchronized String register(ServletConfig config) throws PortletContainerException {
        ServletContext servletContext = config.getServletContext();
        String contextPath = servletContext.getContextPath();
        if (!this.portletContexts.containsKey(contextPath)) {
            ClassLoader classLoader;
            PortletApplicationDefinition portletApp = this.getPortletAppDD(servletContext, contextPath, contextPath);
            DriverPortletContextImpl portletContext = new DriverPortletContextImpl(servletContext, portletApp, this.requestDispatcherService);
            this.portletContexts.put(contextPath, portletContext);
            this.fireRegistered((DriverPortletContext)portletContext);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Registered portlet application for context '" + contextPath + "'"));
                this.logger.info((Object)("Registering " + portletApp.getPortlets().size() + " portlets for context " + portletContext.getApplicationName()));
            }
            if ((classLoader = ThreadContextClassLoaderAspect.getPreviousClassLoader()) == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            this.classLoaders.put(portletApp.getName(), classLoader);
            for (PortletDefinition portlet : portletApp.getPortlets()) {
                String appName = portletContext.getApplicationName();
                if (appName == null) {
                    throw new PortletContainerException("Portlet application name should not be null.");
                }
                this.portletConfigs.put(portletContext.getApplicationName() + "/" + portlet.getPortletName(), new DriverPortletConfigImpl((PortletContext)portletContext, portlet));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Portlet application for context '" + contextPath + "' already registered."));
        }
        return contextPath;
    }

    public synchronized void unregister(DriverPortletContext context) {
        this.portletContexts.remove(context.getApplicationName());
        this.classLoaders.remove(context.getApplicationName());
        Iterator configs = this.portletConfigs.keySet().iterator();
        while (configs.hasNext()) {
            String key = (String)configs.next();
            if (!key.startsWith(context.getApplicationName() + "/")) continue;
            configs.remove();
        }
        this.fireRemoved(context);
    }

    public Iterator<String> getRegisteredPortletApplicationNames() {
        return new HashSet(this.portletContexts.keySet()).iterator();
    }

    public Iterator<DriverPortletContext> getPortletContexts() {
        return new HashSet(this.portletContexts.values()).iterator();
    }

    public DriverPortletContext getPortletContext(String applicationName) {
        return (DriverPortletContext)this.portletContexts.get(applicationName);
    }

    public DriverPortletContext getPortletContext(PortletWindow portletWindow) throws PortletContainerException {
        return (DriverPortletContext)this.portletContexts.get(portletWindow.getPortletDefinition().getApplication().getName());
    }

    public DriverPortletConfig getPortletConfig(String applicationName, String portletName) throws PortletContainerException {
        DriverPortletConfig ipc = (DriverPortletConfig)this.portletConfigs.get(applicationName + "/" + portletName);
        if (ipc != null) {
            return ipc;
        }
        String msg = "Unable to locate portlet config [applicationName=" + applicationName + "]/[" + portletName + "].";
        this.logger.warn((Object)msg);
        throw new PortletContainerException(msg);
    }

    public PortletDefinition getPortlet(String applicationName, String portletName) throws PortletContainerException {
        DriverPortletConfig ipc = (DriverPortletConfig)this.portletConfigs.get(applicationName + "/" + portletName);
        if (ipc != null) {
            return ipc.getPortletDefinition();
        }
        String msg = "Unable to retrieve portlet: '" + applicationName + "/" + portletName + "'";
        this.logger.warn((Object)msg);
        throw new PortletContainerException(msg);
    }

    public PortletApplicationDefinition getPortletApplication(String applicationName) throws PortletContainerException {
        DriverPortletContext ipc = (DriverPortletContext)this.portletContexts.get(applicationName);
        if (ipc != null) {
            return ipc.getPortletApplicationDefinition();
        }
        String msg = "Unable to retrieve portlet application: '" + applicationName + "'";
        this.logger.warn((Object)msg);
        throw new PortletContainerException(msg);
    }

    public ClassLoader getClassLoader(String applicationName) {
        return (ClassLoader)this.classLoaders.get(applicationName);
    }

    public void addPortletRegistryListener(PortletRegistryListener listener) {
        this.registryListeners.add(listener);
    }

    public void removePortletRegistryListener(PortletRegistryListener listener) {
        this.registryListeners.remove(listener);
    }

    private void fireRegistered(DriverPortletContext context) {
        PortletRegistryEvent event = new PortletRegistryEvent();
        event.setPortletApplication(context.getPortletApplicationDefinition());
        for (PortletRegistryListener l : this.registryListeners) {
            l.portletApplicationRegistered(event);
        }
        this.logger.info((Object)("Portlet Context '/" + context.getApplicationName() + "' registered."));
    }

    private void fireRemoved(DriverPortletContext context) {
        PortletRegistryEvent event = new PortletRegistryEvent();
        event.setPortletApplication(context.getPortletApplicationDefinition());
        for (PortletRegistryListener l : this.registryListeners) {
            l.portletApplicationRemoved(event);
        }
        this.logger.info((Object)("Portlet Context '/" + context.getApplicationName() + "' removed."));
    }

    public synchronized PortletApplicationDefinition getPortletAppDD(ServletContext servletContext, String name, String contextPath) throws PortletContainerException {
        PortletApplicationDefinition portletApp = (PortletApplicationDefinition)this.portletAppDefinitionCache.get(servletContext);
        if (portletApp == null) {
            portletApp = this.createDefinition(servletContext, name, contextPath);
            this.portletAppDefinitionCache.put(servletContext, portletApp);
        }
        return portletApp;
    }

    private PortletApplicationDefinition createDefinition(ServletContext servletContext, String name, String contextPath) throws PortletContainerException {
        PortletApplicationDefinition portletApp = null;
        try {
            InputStream paIn = servletContext.getResourceAsStream(PORTLET_XML);
            InputStream webIn = servletContext.getResourceAsStream(WEB_XML);
            if (paIn == null) {
                throw new PortletContainerException("Cannot find '/WEB-INF/portlet.xml'. Are you sure it is in the deployed package?");
            }
            if (webIn == null) {
                throw new PortletContainerException("Cannot find '/WEB-INF/web.xml'. Are you sure it is in the deployed package?");
            }
            portletApp = this.portletAppDescriptorService.read(name, contextPath, paIn);
            this.portletAppDescriptorService.mergeWebDescriptor(portletApp, webIn);
        }
        catch (Exception ex) {
            throw new PortletContainerException("Exception loading portlet descriptor for: " + servletContext.getServletContextName(), (Throwable)ex);
        }
        return portletApp;
    }
}

