/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.UserInfoService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;

public class PersonDirectoryUserInfoService
implements UserInfoService {
    private IPersonAttributeDao personAttributeDao;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPersonAttributeDao getPersonAttributeDao() {
        return this.personAttributeDao;
    }

    @Autowired
    public void setPersonAttributeDao(IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public Map<String, String> getUserInfo(PortletRequest request, PortletWindow plutoPortletWindow) throws PortletContainerException {
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        return this.getUserInfo(remoteUser, httpServletRequest, portletWindow);
    }

    protected Map<String, String> getUserInfo(String remoteUser, HttpServletRequest httpServletRequest, IPortletWindow portletWindow) throws PortletContainerException {
        IPersonAttributes personAttributes = this.personAttributeDao.getPerson(remoteUser);
        if (personAttributes == null) {
            return Collections.emptyMap();
        }
        List expectedUserAttributes = this.getExpectedUserAttributes(httpServletRequest, portletWindow);
        Map portletUserAttributes = this.generateUserInfo(personAttributes, expectedUserAttributes, httpServletRequest);
        return portletUserAttributes;
    }

    protected Map<String, String> generateUserInfo(IPersonAttributes personAttributes, List<? extends UserAttribute> expectedUserAttributes, HttpServletRequest httpServletRequest) {
        HashMap<String, String> portletUserAttributes = new HashMap<String, String>(expectedUserAttributes.size());
        Map attributes = personAttributes.getAttributes();
        for (UserAttribute userAttribute : expectedUserAttributes) {
            String attributeName = userAttribute.getName();
            if (!attributes.containsKey(attributeName)) continue;
            Object valueObj = personAttributes.getAttributeValue(attributeName);
            String value = valueObj == null ? null : String.valueOf(valueObj);
            portletUserAttributes.put(attributeName, value);
        }
        return portletUserAttributes;
    }

    protected Map<String, String> generateUserInfo(Map<String, Object> portalUserAttributes) {
        HashMap<String, String> portletUserAttributes = new HashMap<String, String>(portalUserAttributes.size());
        for (Map.Entry<String, Object> portalUserAttributeEntry : portalUserAttributes.entrySet()) {
            String attributeName = portalUserAttributeEntry.getKey();
            Object valueObj = portalUserAttributeEntry.getValue();
            String value = String.valueOf(valueObj);
            portletUserAttributes.put(attributeName, value);
        }
        return portletUserAttributes;
    }

    protected List<? extends UserAttribute> getExpectedUserAttributes(HttpServletRequest request, IPortletWindow portletWindow) throws PortletContainerException {
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        PortletApplicationDefinition portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        return portletApplicationDescriptor.getUserAttributes();
    }
}

