/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.portal.concurrency.locking.IClusterLockService;
import org.jasig.portal.concurrency.locking.LockOptions;
import org.jasig.portal.portlet.container.services.IPortletCookieService;
import org.jasig.portal.portlet.container.services.SessionOnlyPortletCookieImpl;
import org.jasig.portal.portlet.dao.IPortletCookieDao;
import org.jasig.portal.portlet.om.IPortalCookie;
import org.jasig.portal.portlet.om.IPortletCookie;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.util.WebUtils;

@Service(value="portletCookieService")
public class PortletCookieServiceImpl
implements IPortletCookieService,
ServletContextAware {
    static final String SESSION_ATTRIBUTE__SESSION_ONLY_COOKIE_MAP = PortletCookieServiceImpl.class.getName() + ".SESSION_ONLY_COOKIE_MAP";
    static final String SESSION_ATTRIBUTE__PORTAL_COOKIE_ID = PortletCookieServiceImpl.class.getName() + ".PORTAL_COOKIE_ID";
    private static final String PURGE_LOCK_NAME = PortletCookieServiceImpl.class.getName() + ".PURGE_LOCK";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortletCookieDao portletCookieDao;
    private IClusterLockService clusterLockService;
    protected static final int DEFAULT_MAX_AGE = (int)TimeUnit.DAYS.toSeconds(365L);
    private String cookieName = "org.jasig.portal.PORTLET_COOKIE";
    private String comment = "uPortal Portlet Master Cookie";
    private String domain = null;
    private String path = "/";
    private int maxAge = DEFAULT_MAX_AGE;
    private int maxAgeUpdateInterval = (int)TimeUnit.MINUTES.toMillis(5L);
    private boolean portalCookieAlwaysSecure = false;
    private long purgeExpiredCookiesPeriod = 0L;

    @Autowired
    public void setPortletCookieDao(IPortletCookieDao portletCookieDao) {
        this.portletCookieDao = portletCookieDao;
    }

    @Autowired
    public void setClusterLockService(IClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    @Value(value="${org.jasig.portal.portlet.container.services.PortletCookieServiceImpl.purgeExpiredCookiesPeriod}")
    public void setPurgeExpiredCookiesPeriod(long purgeExpiredCookiesPeriod) {
        this.purgeExpiredCookiesPeriod = purgeExpiredCookiesPeriod;
    }

    public void setServletContext(ServletContext servletContext) {
        this.path = servletContext.getContextPath() + "/";
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setMaxAgeUpdateInterval(int maxAgeUpdateInterval) {
        this.maxAgeUpdateInterval = maxAgeUpdateInterval;
    }

    public void setPortalCookieAlwaysSecure(boolean portalCookieAlwaysSecure) {
        this.portalCookieAlwaysSecure = portalCookieAlwaysSecure;
    }

    public void updatePortalCookie(HttpServletRequest request, HttpServletResponse response) {
        IPortalCookie portalCookie = this.getOrCreatePortalCookie(request);
        Cookie cookie = this.convertToCookie(portalCookie, this.portalCookieAlwaysSecure || request.isSecure());
        DateTime expires = portalCookie.getExpires();
        if (DateTime.now().minusMillis(this.maxAgeUpdateInterval).isAfter((ReadableInstant)expires.minusSeconds(this.maxAge))) {
            this.portletCookieDao.updatePortalCookieExpiration(portalCookie, cookie.getMaxAge());
            this.removeExpiredPortletCookies(request);
        }
        response.addCookie(cookie);
    }

    protected void removeExpiredPortletCookies(HttpServletRequest request) {
        Map sessionOnlyCookies = this.getSessionOnlyPortletCookieMap(request);
        for (Map.Entry entry : sessionOnlyCookies.entrySet()) {
            String key = (String)entry.getKey();
            SessionOnlyPortletCookieImpl sessionOnlyCookie = (SessionOnlyPortletCookieImpl)entry.getValue();
            if (!sessionOnlyCookie.getExpires().isBeforeNow()) continue;
            sessionOnlyCookies.remove(key);
        }
    }

    public Cookie[] getAllPortletCookies(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortalCookie portalCookie = this.getPortalCookie(request);
        Cookie[] servletCookies = request.getCookies();
        if (servletCookies == null) {
            servletCookies = new Cookie[]{};
        } else if (portalCookie != null) {
            for (int i = 0; i < servletCookies.length; ++i) {
                if (!servletCookies[i].getName().equals(this.cookieName)) continue;
                servletCookies[i] = this.convertToCookie(portalCookie, this.portalCookieAlwaysSecure || request.isSecure());
            }
        }
        HashSet<IPortletCookie> portletCookies = new HashSet<IPortletCookie>();
        if (portalCookie != null) {
            for (IPortletCookie portletCookie : portalCookie.getPortletCookies()) {
                if (!portletCookie.getExpires().isAfterNow()) continue;
                portletCookies.add(portletCookie);
            }
        }
        Map sessionOnlyPortletCookieMap = this.getSessionOnlyPortletCookieMap(request);
        Collection sessionOnlyCookies = sessionOnlyPortletCookieMap.values();
        Cookie[] cookies = new Cookie[servletCookies.length + portletCookies.size() + sessionOnlyCookies.size()];
        System.arraycopy(servletCookies, 0, cookies, 0, servletCookies.length);
        int cookieIdx = servletCookies.length;
        for (IPortletCookie portletCookie : portletCookies) {
            Cookie cookie = portletCookie.toCookie();
            cookies[cookieIdx++] = cookie;
        }
        for (SessionOnlyPortletCookieImpl sessionOnlyCookie : sessionOnlyCookies) {
            cookies[cookieIdx++] = sessionOnlyCookie.toCookie();
        }
        return cookies;
    }

    public void addCookie(HttpServletRequest request, IPortletWindowId portletWindowId, Cookie cookie) {
        IPortalCookie portalCookie = this.getOrCreatePortalCookie(request);
        if (cookie.getMaxAge() < 0) {
            Map sessionOnlyPortletCookies = this.getSessionOnlyPortletCookieMap(request);
            SessionOnlyPortletCookieImpl sessionOnlyCookie = new SessionOnlyPortletCookieImpl(cookie);
            sessionOnlyPortletCookies.put(cookie.getName(), sessionOnlyCookie);
        } else if (cookie.getMaxAge() == 0) {
            Map sessionOnlyPortletCookies = this.getSessionOnlyPortletCookieMap(request);
            SessionOnlyPortletCookieImpl existing = (SessionOnlyPortletCookieImpl)sessionOnlyPortletCookies.remove(cookie.getName());
            if (null == existing) {
                this.portletCookieDao.addOrUpdatePortletCookie(portalCookie, cookie);
            }
        } else {
            Map sessionOnlyPortletCookies = this.getSessionOnlyPortletCookieMap(request);
            sessionOnlyPortletCookies.remove(cookie.getName());
            this.portletCookieDao.addOrUpdatePortletCookie(portalCookie, cookie);
        }
    }

    public boolean purgeExpiredCookies() {
        try {
            long purgeExpiredLastRunDelay = (long)((double)this.purgeExpiredCookiesPeriod * 0.95);
            IClusterLockService.TryLockFunctionResult result = this.clusterLockService.doInTryLock(PURGE_LOCK_NAME, LockOptions.builder().lastRunDelay(purgeExpiredLastRunDelay), (Function)new /* Unavailable Anonymous Inner Class!! */);
            return result.getLockStatus() == IClusterLockService.LockStatus.EXECUTED;
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while purging expired cookies", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SessionOnlyPortletCookieImpl> getSessionOnlyPortletCookieMap(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            ConcurrentHashMap<String, SessionOnlyPortletCookieImpl> sessionOnlyPortletCookies = (ConcurrentHashMap<String, SessionOnlyPortletCookieImpl>)session.getAttribute(SESSION_ATTRIBUTE__SESSION_ONLY_COOKIE_MAP);
            if (sessionOnlyPortletCookies == null) {
                sessionOnlyPortletCookies = new ConcurrentHashMap<String, SessionOnlyPortletCookieImpl>();
                session.setAttribute(SESSION_ATTRIBUTE__SESSION_ONLY_COOKIE_MAP, sessionOnlyPortletCookies);
            }
            return sessionOnlyPortletCookies;
        }
    }

    protected Cookie convertToCookie(IPortalCookie portalCookie, boolean secure) {
        Cookie cookie = new Cookie(this.cookieName, portalCookie.getValue());
        cookie.setComment(this.comment);
        cookie.setMaxAge(this.maxAge);
        cookie.setSecure(secure);
        if (this.domain != null) {
            cookie.setDomain(this.domain);
        }
        cookie.setPath(this.path);
        return cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPortalCookie locatePortalCookieInSession(HttpSession session) {
        Object object = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            String portalCookieId = (String)session.getAttribute(SESSION_ATTRIBUTE__PORTAL_COOKIE_ID);
            if (portalCookieId == null) {
                return null;
            }
            IPortalCookie portalCookie = this.portletCookieDao.getPortalCookie(portalCookieId);
            return portalCookie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPortalCookie getOrCreatePortalCookie(HttpServletRequest request) {
        IPortalCookie result = null;
        Cookie cookie = this.getCookieFromRequest(this.cookieName, request);
        if (cookie != null) {
            String value = cookie.getValue();
            result = this.portletCookieDao.getPortalCookie(value);
        }
        if (result == null) {
            result = this.locatePortalCookieInSession(request.getSession());
        }
        if (result == null) {
            result = this.portletCookieDao.createPortalCookie(this.maxAge);
            HttpSession session = request.getSession();
            Object object = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                session.setAttribute(SESSION_ATTRIBUTE__PORTAL_COOKIE_ID, (Object)result.getValue());
            }
        }
        return result;
    }

    protected IPortalCookie getPortalCookie(HttpServletRequest request) {
        Cookie cookie = this.getCookieFromRequest(this.cookieName, request);
        if (cookie == null) {
            IPortalCookie portalCookieInSession = this.locatePortalCookieInSession(request.getSession());
            if (null != portalCookieInSession) {
                return portalCookieInSession;
            }
            return null;
        }
        String value = cookie.getValue();
        return this.portletCookieDao.getPortalCookie(value);
    }

    protected Cookie getCookieFromRequest(String name, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    static /* synthetic */ int access$000(PortletCookieServiceImpl x0) {
        return x0.maxAge;
    }

    static /* synthetic */ IPortletCookieDao access$100(PortletCookieServiceImpl x0) {
        return x0.portletCookieDao;
    }
}

