/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.jasig.portal.portlet.container.services.AbstractPortletPreferencesImpl;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class PortletEntityPreferencesImpl
extends AbstractPortletPreferencesImpl<IPortletEntity> {
    private final PortletRequestContext portletRequestContext;
    private final IPortletEntityId portletEntityId;
    private final IPortletEntityRegistry portletEntityRegistry;
    private final IPortletDefinitionRegistry portletDefinitionRegistry;
    private final TransactionOperations transactionOperations;

    public PortletEntityPreferencesImpl(PortletRequestContext portletRequestContext, IPortletEntityRegistry portletEntityRegistry, IPortletDefinitionRegistry portletDefinitionRegistry, TransactionOperations transactionOperations, IPortletEntityId portletEntityId, boolean render) {
        super(render);
        this.portletRequestContext = portletRequestContext;
        this.portletEntityRegistry = portletEntityRegistry;
        this.portletDefinitionRegistry = portletDefinitionRegistry;
        this.transactionOperations = transactionOperations;
        this.portletEntityId = portletEntityId;
    }

    protected IPortletEntity getInitializationContext() {
        HttpServletRequest containerRequest = this.portletRequestContext.getContainerRequest();
        return this.portletEntityRegistry.getPortletEntity(containerRequest, this.portletEntityId);
    }

    protected Object getLogDescription() {
        return this.getInitializationContext();
    }

    protected void loadTargetPortletPreferences(IPortletEntity portletEntity, Map<String, IPortletPreference> targetPortletPreferences) {
        List entityPreferences = portletEntity.getPortletPreferences();
        for (IPortletPreference preference : entityPreferences) {
            targetPortletPreferences.put(preference.getName(), preference);
        }
    }

    protected void loadBasePortletPreferences(IPortletEntity portletEntity, Map<String, IPortletPreference> basePortletPreferences) {
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinitionId);
        Preferences descriptorPreferences = portletDescriptor.getPortletPreferences();
        for (Preference preference : descriptorPreferences.getPortletPreferences()) {
            PortletPreferenceImpl preferenceWrapper = new PortletPreferenceImpl(preference);
            basePortletPreferences.put(preferenceWrapper.getName(), (IPortletPreference)preferenceWrapper);
        }
        List definitionPreferences = portletDefinition.getPortletPreferences();
        for (IPortletPreference preference : definitionPreferences) {
            basePortletPreferences.put(preference.getName(), preference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean storeInternal() throws IOException, ValidatorException {
        HttpServletRequest containerRequest = this.portletRequestContext.getContainerRequest();
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(containerRequest, this.portletEntityId);
        IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
        Lock portletEntityLock = this.portletEntityRegistry.getPortletEntityLock(containerRequest, portletEntityId);
        boolean locked = portletEntityLock.tryLock();
        try {
            if (!locked) {
                this.logger.warn("Concurrent portlet preferences modification by: " + portletEntity + " " + "This has the potential for changes to preferences to be lost. " + "This portlet should be modified to synchronize its preference modifications appropriately", new Throwable());
                portletEntityLock.lock();
                locked = true;
            }
            boolean bl = (Boolean)this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
            return bl;
        }
        finally {
            if (locked) {
                portletEntityLock.unlock();
            }
        }
    }

    static /* synthetic */ IPortletEntityRegistry access$000(PortletEntityPreferencesImpl x0) {
        return x0.portletEntityRegistry;
    }
}

