/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.PortletActionResponseContext;
import org.apache.pluto.container.PortletEnvironmentService;
import org.apache.pluto.container.PortletEventResponseContext;
import org.apache.pluto.container.PortletRenderResponseContext;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.ActionResponseImpl;
import org.apache.pluto.container.impl.EventResponseImpl;
import org.jasig.portal.portlet.container.services.PortletEnvironmentServiceImpl;
import org.jasig.portal.portlet.container.services.PortletPreferencesFactory;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.session.ScopingPortletSessionImpl;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="portletEnvironmentService")
public class PortletEnvironmentServiceImpl
implements PortletEnvironmentService {
    private PortletPreferencesFactory portletPreferencesFactory;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortalRequestUtils portalRequestUtils;

    @Autowired
    public void setPortletPreferencesFactory(PortletPreferencesFactory portletPreferencesFactory) {
        this.portletPreferencesFactory = portletPreferencesFactory;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public PortletSession createPortletSession(PortletContext portletContext, PortletWindow portletWindow, HttpSession session) {
        HttpServletRequest request = this.portalRequestUtils.getCurrentPortalRequest();
        IPortletWindow internalPortletWindow = this.portletWindowRegistry.convertPortletWindow(request, portletWindow);
        IPortletEntity portletEntity = internalPortletWindow.getPortletEntity();
        IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
        return new ScopingPortletSessionImpl(portletEntityId, portletContext, portletWindow, session);
    }

    public ActionRequest createActionRequest(PortletRequestContext requestContext, PortletActionResponseContext responseContext) {
        return new ExtendedActionRequestImpl(this.portletPreferencesFactory, requestContext, responseContext, null);
    }

    public EventRequest createEventRequest(PortletRequestContext requestContext, PortletEventResponseContext responseContext, Event event) {
        return new ExtendedEventRequestImpl(this.portletPreferencesFactory, requestContext, responseContext, event, null);
    }

    public RenderRequest createRenderRequest(PortletRequestContext requestContext, PortletRenderResponseContext responseContext) {
        return new ExtendedRenderRequestImpl(this.portletPreferencesFactory, requestContext, responseContext, null);
    }

    public ResourceRequest createResourceRequest(PortletResourceRequestContext requestContext, PortletResourceResponseContext responseContext) {
        return new ExtendedResourceRequestImpl(this.portletPreferencesFactory, requestContext, responseContext, null);
    }

    public ActionResponse createActionResponse(PortletActionResponseContext responseContext) {
        return new ActionResponseImpl(responseContext);
    }

    public EventResponse createEventResponse(PortletEventResponseContext responseContext) {
        return new EventResponseImpl(responseContext);
    }

    public RenderResponse createRenderResponse(PortletRenderResponseContext responseContext) {
        return new ExtendedRenderResponseImpl(responseContext, null);
    }

    public ResourceResponse createResourceResponse(PortletResourceResponseContext responseContext, String requestCacheLevel) {
        return new ExtendedResourceResponseImpl(responseContext, requestCacheLevel, null);
    }
}

