/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletWindow;
import org.jasig.portal.portlet.container.services.GuestPortletEntityPreferencesImpl;
import org.jasig.portal.portlet.container.services.PortletDefinitionPreferencesImpl;
import org.jasig.portal.portlet.container.services.PortletEntityPreferencesImpl;
import org.jasig.portal.portlet.container.services.PortletPreferencesFactory;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionOperations;

@Service
public class PortletPreferencesFactoryImpl
implements PortletPreferencesFactory {
    private IPersonManager personManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private TransactionOperations transactionOperations;
    private boolean storeGuestPreferencesInMemory = true;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    @Qualifier(value="PortalDb")
    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    @Value(value="${org.jasig.portal.portlet.container.services.PortletPreferencesFactoryImpl.storeGuestPreferencesInMemory:true}")
    public void setStoreGuestPreferencesInMemory(boolean storeGuestPreferencesInMemory) {
        this.storeGuestPreferencesInMemory = storeGuestPreferencesInMemory;
    }

    public PortletPreferences createPortletPreferences(PortletRequestContext requestContext, boolean render) {
        HttpServletRequest containerRequest = requestContext.getContainerRequest();
        PortletWindow plutoPortletWindow = requestContext.getPortletWindow();
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(containerRequest, plutoPortletWindow);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        boolean configMode = IPortletRenderer.CONFIG.equals((Object)portletWindow.getPortletMode());
        if (configMode) {
            IPortletDefinitionId portletDefinitionId = portletEntity.getPortletDefinitionId();
            return new PortletDefinitionPreferencesImpl(this.portletDefinitionRegistry, this.transactionOperations, portletDefinitionId, render);
        }
        if (this.isStoreInMemory(containerRequest)) {
            IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
            return new GuestPortletEntityPreferencesImpl(requestContext, this.portletEntityRegistry, this.portletDefinitionRegistry, portletEntityId, render);
        }
        IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
        return new PortletEntityPreferencesImpl(requestContext, this.portletEntityRegistry, this.portletDefinitionRegistry, this.transactionOperations, portletEntityId, render);
    }

    protected boolean isStoreInMemory(HttpServletRequest containerRequest) {
        return this.storeGuestPreferencesInMemory && this.isGuestUser(containerRequest);
    }

    protected boolean isGuestUser(HttpServletRequest containerRequest) {
        IPerson person = this.personManager.getPerson(containerRequest);
        ISecurityContext securityContext = person.getSecurityContext();
        return !securityContext.isAuthenticated();
    }
}

