/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.jasig.portal.portlet.om.IPortletCookie;
import org.joda.time.DateTime;

class SessionOnlyPortletCookieImpl
implements IPortletCookie,
Serializable {
    private static final long serialVersionUID = -7216859047141530039L;
    private final String name;
    private String value;
    private String comment;
    private String domain;
    private String path;
    private int version = 0;
    private boolean secure;
    private DateTime expires;

    SessionOnlyPortletCookieImpl(String name) {
        this.name = name;
    }

    SessionOnlyPortletCookieImpl(Cookie cookie) {
        this.name = cookie.getName();
        this.value = cookie.getValue();
        this.comment = cookie.getComment();
        this.domain = cookie.getDomain();
        this.path = cookie.getPath();
        this.version = cookie.getVersion();
        this.secure = cookie.getSecure();
        this.setMaxAge(cookie.getMaxAge());
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getMaxAge() {
        if (this.expires == null) {
            return -1;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.expires.getMillis());
    }

    public void setMaxAge(int maxAge) {
        this.expires = maxAge < 0 ? null : DateTime.now().plusSeconds(maxAge);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public void setExpires(DateTime expires) {
        this.expires = expires;
    }

    public Cookie toCookie() {
        Cookie cookie = new Cookie(this.name, this.value);
        cookie.setComment(this.comment);
        if (this.domain != null) {
            cookie.setDomain(this.domain);
        }
        cookie.setMaxAge(this.getMaxAge());
        cookie.setPath(this.path);
        cookie.setSecure(this.secure);
        cookie.setVersion(this.version);
        return cookie;
    }

    public void updateFromCookie(Cookie cookie) {
        this.setComment(cookie.getComment());
        this.setDomain(cookie.getDomain());
        this.setExpires(DateTime.now().plusSeconds(cookie.getMaxAge()));
        this.setPath(cookie.getPath());
        this.setSecure(cookie.getSecure());
        this.setValue(cookie.getValue());
    }
}

