/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import com.google.common.base.Function;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Attribute;
import javax.servlet.http.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.portlet.dao.IPortletCookieDao;
import org.jasig.portal.portlet.dao.jpa.PortalCookieImpl;
import org.jasig.portal.portlet.dao.jpa.PortalCookieImpl_;
import org.jasig.portal.portlet.dao.jpa.PortletCookieImpl;
import org.jasig.portal.portlet.dao.jpa.PortletCookieImpl_;
import org.jasig.portal.portlet.om.IPortalCookie;
import org.jasig.portal.portlet.om.IPortletCookie;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="portletCookieDao")
@Qualifier(value="persistence")
public class JpaPortletCookieDaoImpl
extends BasePortalJpaDao
implements IPortletCookieDao {
    private final SecureRandom secureRandom = new SecureRandom();
    private String deletePortalCookieQueryString;
    private String deleteEmptyPortalCookieQueryString;
    private String deletePortletCookieQueryString;
    private CriteriaQuery<PortletCookieImpl> findExpiredByParentPortletCookiesQuery;
    private ParameterExpression<DateTime> nowParameter;
    protected static final int DEFAULT_EMPTY_MAX_AGE = (int)TimeUnit.DAYS.toSeconds(1L);
    private int emptyCookieMaxAge = DEFAULT_EMPTY_MAX_AGE;

    public void afterPropertiesSet() throws Exception {
        this.nowParameter = this.createParameterExpression(DateTime.class, "now");
        this.deletePortalCookieQueryString = "DELETE FROM " + PortalCookieImpl.class.getName() + " e " + "WHERE e." + PortalCookieImpl_.expires.getName() + " <= :" + this.nowParameter.getName();
        this.deleteEmptyPortalCookieQueryString = "DELETE FROM " + PortalCookieImpl.class.getName() + " e " + "WHERE e." + PortalCookieImpl_.expires.getName() + " <= :" + this.nowParameter.getName() + " AND " + "e." + PortalCookieImpl_.portletCookies.getName() + " IS EMPTY";
        this.deletePortletCookieQueryString = "DELETE FROM " + PortletCookieImpl.class.getName() + " e " + "WHERE e." + PortletCookieImpl_.expires.getName() + " <= :" + this.nowParameter.getName();
        this.findExpiredByParentPortletCookiesQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String generateNewCookieId() {
        byte[] keyBytes = new byte[30];
        this.secureRandom.nextBytes(keyBytes);
        return Base64.encodeBase64URLSafeString((byte[])keyBytes);
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortalCookie createPortalCookie(int maxAge) {
        String uniqueId;
        while (this.getPortalCookie(uniqueId = this.generateNewCookieId()) != null) {
        }
        DateTime expiration = DateTime.now().plusSeconds(maxAge);
        PortalCookieImpl portalCookie = new PortalCookieImpl(uniqueId, expiration);
        this.getEntityManager().persist((Object)portalCookie);
        return portalCookie;
    }

    @OpenEntityManager(unitName="PortalDb")
    public IPortalCookie getPortalCookie(String portalCookieValue) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(PortalCookieImpl.class);
        query.using((Attribute)PortalCookieImpl_.value, (Object)portalCookieValue);
        return (IPortalCookie)query.load();
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortalCookie updatePortalCookieExpiration(IPortalCookie portalCookie, int maxAge) {
        DateTime expiration = DateTime.now().plusSeconds(maxAge);
        portalCookie.setExpires(expiration);
        this.getEntityManager().persist((Object)portalCookie);
        return portalCookie;
    }

    @BasePortalJpaDao.PortalTransactional
    public void purgeExpiredCookies(int maxAge) {
        DateTime now = DateTime.now();
        this.logger.debug("begin portlet cookie expiration");
        EntityManager entityManager = this.getEntityManager();
        Query deletePortletCookieQuery = entityManager.createQuery(this.deletePortletCookieQueryString);
        deletePortletCookieQuery.setParameter(this.nowParameter.getName(), (Object)now);
        int deletedPortletCookies = deletePortletCookieQuery.executeUpdate();
        this.logger.debug("finished purging {} portlet cookies with expiration before {}", (Object)deletedPortletCookies, (Object)now);
        TypedQuery expiredByParentCookiesQuery = this.createQuery(this.findExpiredByParentPortletCookiesQuery);
        expiredByParentCookiesQuery.setParameter(this.nowParameter.getName(), (Object)now);
        List indirectlyExpiredCookies = expiredByParentCookiesQuery.getResultList();
        for (PortletCookieImpl portletCookieImpl : indirectlyExpiredCookies) {
            entityManager.remove((Object)portletCookieImpl);
        }
        this.logger.debug("finished purging {} portlet cookies with parent expiration before {}", (Object)indirectlyExpiredCookies.size(), (Object)now);
        this.logger.debug("begin portal cookie expiration");
        Query deletePortalCookieQuery = entityManager.createQuery(this.deletePortalCookieQueryString);
        deletePortalCookieQuery.setParameter(this.nowParameter.getName(), (Object)now);
        int deletedPortalCookies = deletePortalCookieQuery.executeUpdate();
        this.logger.debug("finished purging {} portal cookies with expiration before {}", (Object)deletedPortalCookies, (Object)now);
        Query deleteEmptyPortalCookieQuery = entityManager.createQuery(this.deleteEmptyPortalCookieQueryString);
        DateTime emptyExpiration = now.plusSeconds(maxAge).minusSeconds(this.emptyCookieMaxAge);
        deleteEmptyPortalCookieQuery.setParameter(this.nowParameter.getName(), (Object)emptyExpiration);
        int deletedEmptyPortalCookies = deleteEmptyPortalCookieQuery.executeUpdate();
        this.logger.debug("finished purging {} empty portal cookies with expiration before {}", (Object)deletedEmptyPortalCookies, (Object)emptyExpiration);
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortalCookie addOrUpdatePortletCookie(IPortalCookie portalCookie, Cookie cookie) {
        Set portletCookies = portalCookie.getPortletCookies();
        boolean found = false;
        String name = cookie.getName();
        EntityManager entityManager = this.getEntityManager();
        Iterator portletCookieItr = portletCookies.iterator();
        while (portletCookieItr.hasNext()) {
            IPortletCookie portletCookie = (IPortletCookie)portletCookieItr.next();
            if (!name.equals(portletCookie.getName())) continue;
            if (cookie.getMaxAge() == 0) {
                portletCookieItr.remove();
                entityManager.remove((Object)portletCookie);
            } else {
                portletCookie.updateFromCookie(cookie);
            }
            found = true;
            break;
        }
        if (!found) {
            PortletCookieImpl newPortletCookie = new PortletCookieImpl(portalCookie, cookie);
            portletCookies.add(newPortletCookie);
        }
        entityManager.persist((Object)portalCookie);
        return portalCookie;
    }

    static /* synthetic */ ParameterExpression access$000(JpaPortletCookieDaoImpl x0) {
        return x0.nowParameter;
    }
}

