/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.commons.lang.Validate;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl_;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl_;
import org.jasig.portal.portlet.dao.jpa.PortletPreferencesImpl_;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.spring.tx.DialectAwareTransactional;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPortletDefinitionDao
extends BasePortalJpaDao
implements IPortletDefinitionDao {
    private CriteriaQuery<PortletDefinitionImpl> findAllPortletDefinitions;
    private CriteriaQuery<PortletDefinitionImpl> findDefinitionByNameQuery;
    private CriteriaQuery<PortletDefinitionImpl> findDefinitionByNameOrTitleQuery;
    private CriteriaQuery<PortletDefinitionImpl> searchDefinitionByNameOrTitleQuery;
    private ParameterExpression<String> nameParameter;
    private ParameterExpression<String> titleParameter;

    public void afterPropertiesSet() throws Exception {
        this.nameParameter = this.createParameterExpression(String.class, "name");
        this.titleParameter = this.createParameterExpression(String.class, "title");
        this.findAllPortletDefinitions = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findDefinitionByNameQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findDefinitionByNameOrTitleQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.searchDefinitionByNameOrTitleQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addFetches(Root<PortletDefinitionImpl> definitionRoot) {
        definitionRoot.fetch(PortletDefinitionImpl_.portletPreferences, JoinType.LEFT).fetch((PluralAttribute)PortletPreferencesImpl_.portletPreferences, JoinType.LEFT).fetch((PluralAttribute)PortletPreferenceImpl_.values, JoinType.LEFT);
        definitionRoot.fetch((PluralAttribute)PortletDefinitionImpl_.parameters, JoinType.LEFT);
        definitionRoot.fetch((PluralAttribute)PortletDefinitionImpl_.localizations, JoinType.LEFT);
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public IPortletDefinition getPortletDefinition(IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        long internalPortletDefinitionId = this.getNativePortletDefinitionId(portletDefinitionId);
        PortletDefinitionImpl portletDefinition = (PortletDefinitionImpl)this.getEntityManager().find(PortletDefinitionImpl.class, (Object)internalPortletDefinitionId);
        return portletDefinition;
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public IPortletDefinition getPortletDefinition(String portletDefinitionIdString) {
        Validate.notNull((Object)portletDefinitionIdString, (String)"portletDefinitionIdString can not be null");
        long internalPortletDefinitionId = this.getNativePortletDefinitionId(portletDefinitionIdString);
        PortletDefinitionImpl portletDefinition = (PortletDefinitionImpl)this.getEntityManager().find(PortletDefinitionImpl.class, (Object)internalPortletDefinitionId);
        return portletDefinition;
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public IPortletDefinition getPortletDefinitionByFname(String fname) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(PortletDefinitionImpl.class);
        query.using((Attribute)PortletDefinitionImpl_.fname, (Object)fname);
        return (IPortletDefinition)query.load();
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public IPortletDefinition getPortletDefinitionByName(String name) {
        TypedQuery query = this.createCachedQuery(this.findDefinitionByNameQuery);
        query.setParameter((Parameter)this.nameParameter, (Object)name);
        List portletDefinitions = query.getResultList();
        return (IPortletDefinition)DataAccessUtils.uniqueResult((Collection)portletDefinitions);
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public List<IPortletDefinition> searchForPortlets(String term, boolean allowPartial) {
        CriteriaQuery criteriaQuery;
        if (allowPartial) {
            criteriaQuery = this.searchDefinitionByNameOrTitleQuery;
            term = "%" + term.toUpperCase() + "%";
        } else {
            criteriaQuery = this.findDefinitionByNameOrTitleQuery;
        }
        TypedQuery query = this.createCachedQuery(criteriaQuery);
        query.setParameter("name", (Object)term);
        query.setParameter("title", (Object)term);
        List portletDefinitions = query.getResultList();
        return new ArrayList<IPortletDefinition>(portletDefinitions);
    }

    @BasePortalJpaDao.PortalTransactional
    public void deletePortletDefinition(IPortletDefinition definition) {
        Validate.notNull((Object)definition, (String)"definition can not be null");
        EntityManager entityManager = this.getEntityManager();
        IPortletDefinition persistentPortletDefinition = entityManager.contains((Object)definition) ? definition : (IPortletDefinition)entityManager.merge((Object)definition);
        entityManager.remove((Object)persistentPortletDefinition);
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public List<IPortletDefinition> getPortletDefinitions() {
        TypedQuery query = this.createCachedQuery(this.findAllPortletDefinitions);
        List portletDefinitions = query.getResultList();
        return new ArrayList<IPortletDefinition>(new LinkedHashSet(portletDefinitions));
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortletDefinition createPortletDefinition(IPortletType portletType, String fname, String name, String title, String applicationId, String portletName, boolean isFramework) {
        Validate.notNull((Object)portletType, (String)"portletType can not be null");
        Validate.notEmpty((String)fname, (String)"fname can not be null");
        Validate.notEmpty((String)name, (String)"name can not be null");
        Validate.notEmpty((String)title, (String)"title can not be null");
        PortletDefinitionImpl portletDefinition = new PortletDefinitionImpl(portletType, fname, name, title, applicationId, portletName, isFramework);
        this.getEntityManager().persist((Object)portletDefinition);
        return portletDefinition;
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortletDefinition updatePortletDefinition(IPortletDefinition portletDefinition) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        this.getEntityManager().persist((Object)portletDefinition);
        return portletDefinition;
    }

    protected long getNativePortletDefinitionId(IPortletDefinitionId portletDefinitionId) {
        return Long.parseLong(portletDefinitionId.getStringId());
    }

    protected long getNativePortletDefinitionId(String portletDefinitionId) {
        return Long.parseLong(portletDefinitionId);
    }

    static /* synthetic */ ParameterExpression access$000(JpaPortletDefinitionDao x0) {
        return x0.nameParameter;
    }

    static /* synthetic */ ParameterExpression access$100(JpaPortletDefinitionDao x0) {
        return x0.titleParameter;
    }
}

