/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import com.google.common.base.Function;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.dao.jpa.PortletEntityImpl;
import org.jasig.portal.portlet.dao.jpa.PortletEntityImpl_;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl_;
import org.jasig.portal.portlet.dao.jpa.PortletPreferencesImpl_;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.spring.tx.DialectAwareTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="persistence")
public class JpaPortletEntityDao
extends BasePortalJpaDao
implements IPortletEntityDao {
    private CriteriaQuery<PortletEntityImpl> findEntitiesForDefinitionQuery;
    private CriteriaQuery<PortletEntityImpl> findEntitiesForUserIdQuery;
    private ParameterExpression<Integer> userIdParameter;
    private ParameterExpression<PortletDefinitionImpl> portletDefinitionParameter;
    private IPortletDefinitionDao portletDefinitionDao;

    @Autowired
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.userIdParameter = this.createParameterExpression(Integer.class, "userId");
        this.portletDefinitionParameter = this.createParameterExpression(PortletDefinitionImpl.class, "portletDefinition");
        this.findEntitiesForDefinitionQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findEntitiesForUserIdQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addFetches(Root<PortletEntityImpl> definitionRoot) {
        definitionRoot.fetch(PortletEntityImpl_.portletPreferences, JoinType.LEFT).fetch((PluralAttribute)PortletPreferencesImpl_.portletPreferences, JoinType.LEFT).fetch((PluralAttribute)PortletPreferenceImpl_.values, JoinType.LEFT);
        definitionRoot.fetch((PluralAttribute)PortletEntityImpl_.windowStates, JoinType.LEFT);
    }

    @BasePortalJpaDao.PortalTransactional
    public IPortletEntity createPortletEntity(IPortletDefinitionId portletDefinitionId, String layoutNodeId, int userId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        Validate.notEmpty((String)layoutNodeId, (String)"layoutNodeId can not be null");
        IPortletDefinition portletDefinition = this.portletDefinitionDao.getPortletDefinition(portletDefinitionId);
        if (portletDefinition == null) {
            throw new DataRetrievalFailureException("No IPortletDefinition exists for IPortletDefinitionId='" + portletDefinitionId + "'");
        }
        PortletEntityImpl portletEntity = new PortletEntityImpl(portletDefinition, layoutNodeId, userId);
        this.getEntityManager().persist((Object)portletEntity);
        return portletEntity;
    }

    @BasePortalJpaDao.PortalTransactional
    public void deletePortletEntity(IPortletEntity portletEntity) {
        Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
        EntityManager entityManager = this.getEntityManager();
        IPortletEntity persistentPortletEntity = entityManager.contains((Object)portletEntity) ? portletEntity : (IPortletEntity)entityManager.merge((Object)portletEntity);
        entityManager.remove((Object)persistentPortletEntity);
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public IPortletEntity getPortletEntity(IPortletEntityId portletEntityId) {
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        long internalPortletEntityId = this.getNativePortletEntityId(portletEntityId);
        PortletEntityImpl portletEntity = (PortletEntityImpl)this.getEntityManager().find(PortletEntityImpl.class, (Object)internalPortletEntityId);
        return portletEntity;
    }

    @BasePortalJpaDao.PortalTransactionalRequiresNew
    public boolean portletEntityExists(IPortletEntityId portletEntityId) {
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        EntityManager entityManager = this.getEntityManager();
        entityManager.clear();
        long internalPortletEntityId = this.getNativePortletEntityId(portletEntityId);
        PortletEntityImpl portletEntity = (PortletEntityImpl)entityManager.find(PortletEntityImpl.class, (Object)internalPortletEntityId);
        return portletEntity != null;
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public IPortletEntity getPortletEntity(String layoutNodeId, int userId) {
        Validate.notNull((Object)layoutNodeId, (String)"portletEntity can not be null");
        Set entities = this.getPortletEntitiesForUser(userId);
        for (IPortletEntity entity : entities) {
            if (!StringUtils.equals((String)entity.getLayoutNodeId(), (String)layoutNodeId)) continue;
            return entity;
        }
        return null;
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public Set<IPortletEntity> getPortletEntities(IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletEntity can not be null");
        IPortletDefinition portletDefinition = this.portletDefinitionDao.getPortletDefinition(portletDefinitionId);
        TypedQuery query = this.createCachedQuery(this.findEntitiesForDefinitionQuery);
        query.setParameter((Parameter)this.portletDefinitionParameter, (Object)((PortletDefinitionImpl)portletDefinition));
        List portletEntities = query.getResultList();
        return new HashSet<IPortletEntity>(portletEntities);
    }

    @DialectAwareTransactional(value={PostgreSQL81Dialect.class}, exclude=false)
    @BasePortalJpaDao.PortalTransactionalReadOnly
    @OpenEntityManager(unitName="PortalDb")
    public Set<IPortletEntity> getPortletEntitiesForUser(int userId) {
        TypedQuery query = this.createCachedQuery(this.findEntitiesForUserIdQuery);
        query.setParameter((Parameter)this.userIdParameter, (Object)userId);
        List portletEntities = query.getResultList();
        return new HashSet<IPortletEntity>(portletEntities);
    }

    @BasePortalJpaDao.PortalTransactional
    public void updatePortletEntity(IPortletEntity portletEntity) {
        Validate.notNull((Object)portletEntity, (String)"portletEntity can not be null");
        this.getEntityManager().persist((Object)portletEntity);
    }

    protected long getNativePortletEntityId(IPortletEntityId portletEntityId) {
        long internalPortletEntityId = Long.parseLong(portletEntityId.getStringId());
        return internalPortletEntityId;
    }

    static /* synthetic */ ParameterExpression access$000(JpaPortletEntityDao x0) {
        return x0.portletDefinitionParameter;
    }

    static /* synthetic */ ParameterExpression access$100(JpaPortletEntityDao x0) {
        return x0.userIdParameter;
    }
}

