/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.portlet.WindowState;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.jasig.portal.layout.dao.jpa.StylesheetDescriptorImpl;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.dao.jpa.PortletEntityIdImpl;
import org.jasig.portal.portlet.dao.jpa.PortletPreferencesImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;

@Entity
@Table(name="UP_PORTLET_ENT")
@SequenceGenerator(name="UP_PORTLET_ENT_GEN", sequenceName="UP_PORTLET_ENT_SEQ", allocationSize=10)
@TableGenerator(name="UP_PORTLET_ENT_GEN", pkColumnValue="UP_PORTLET_ENT", allocationSize=10)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class PortletEntityImpl
implements IPortletEntity {
    @Id
    @GeneratedValue(generator="UP_PORTLET_ENT_GEN")
    @Column(name="PORTLET_ENT_ID")
    private final long internalPortletEntityId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="LAYOUT_NODE_ID", nullable=false)
    private final String layoutNodeId;
    @NaturalId
    @Index(name="IDX_UP_PORTLET_ENT__UP_USER")
    @Column(name="USER_ID", nullable=false)
    private final int userId;
    @ManyToOne(targetEntity=PortletDefinitionImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="PORTLET_DEF_ID", nullable=false)
    private final IPortletDefinition portletDefinition;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="UP_PORTLET_ENT__STATES", joinColumns={@JoinColumn(name="PORTLET_ENT_ID")})
    @MapKeyJoinColumn(name="STYLESHEET_DESCRIPTOR_ID")
    @Column(name="WINDOW_STATE")
    @Type(type="windowState")
    private final Map<StylesheetDescriptorImpl, WindowState> windowStates = new HashMap(0);
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="PORTLET_PREFS_ID", nullable=false)
    @Fetch(value=FetchMode.JOIN)
    private final PortletPreferencesImpl portletPreferences;
    @Transient
    private IPortletEntityId portletEntityId = null;

    @PostLoad
    @PostPersist
    @PostUpdate
    @PostRemove
    private void init() {
        this.portletEntityId = new PortletEntityIdImpl(this.internalPortletEntityId);
    }

    private PortletEntityImpl() {
        this.internalPortletEntityId = -1L;
        this.entityVersion = -1L;
        this.portletDefinition = null;
        this.layoutNodeId = null;
        this.userId = -1;
        this.portletPreferences = null;
    }

    public PortletEntityImpl(IPortletDefinition portletDefinition, String channelSubscribeId, int userId) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        Validate.notNull((Object)channelSubscribeId, (String)"layoutNodeId can not be null");
        this.internalPortletEntityId = -1L;
        this.entityVersion = -1L;
        this.portletDefinition = portletDefinition;
        this.layoutNodeId = channelSubscribeId;
        this.userId = userId;
        this.portletPreferences = new PortletPreferencesImpl();
    }

    public IPortletDefinitionId getPortletDefinitionId() {
        return this.portletDefinition.getPortletDefinitionId();
    }

    public IPortletEntityId getPortletEntityId() {
        return this.portletEntityId;
    }

    public IPortletDefinition getPortletDefinition() {
        return this.portletDefinition;
    }

    public String getLayoutNodeId() {
        return this.layoutNodeId;
    }

    public int getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, WindowState> getWindowStates() {
        LinkedHashMap<Long, WindowState> simpleWindowStates = new LinkedHashMap<Long, WindowState>();
        Map map = this.windowStates;
        synchronized (map) {
            for (Map.Entry windowStateEntry : this.windowStates.entrySet()) {
                StylesheetDescriptorImpl stylesheetDescriptor = (StylesheetDescriptorImpl)windowStateEntry.getKey();
                long stylesheetDescriptorId = stylesheetDescriptor.getId();
                WindowState windowState = (WindowState)windowStateEntry.getValue();
                simpleWindowStates.put(stylesheetDescriptorId, windowState);
            }
        }
        return Collections.unmodifiableMap(simpleWindowStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowState getWindowState(IStylesheetDescriptor stylesheetDescriptor) {
        Map map = this.windowStates;
        synchronized (map) {
            return (WindowState)this.windowStates.get(stylesheetDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowState(IStylesheetDescriptor stylesheetDescriptor, WindowState state) {
        Map map = this.windowStates;
        synchronized (map) {
            if (state == null) {
                this.windowStates.remove(stylesheetDescriptor);
            } else {
                this.windowStates.put((StylesheetDescriptorImpl)stylesheetDescriptor, state);
            }
        }
    }

    public List<IPortletPreference> getPortletPreferences() {
        return this.portletPreferences.getPortletPreferences();
    }

    public boolean setPortletPreferences(List<IPortletPreference> portletPreferences) {
        return this.portletPreferences.setPortletPreferences(portletPreferences);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.layoutNodeId == null ? 0 : this.layoutNodeId.hashCode());
        result = 31 * result + (this.portletDefinition == null ? 0 : this.portletDefinition.hashCode());
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IPortletEntity.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IPortletEntity other = (IPortletEntity)obj;
        if (this.layoutNodeId == null ? other.getLayoutNodeId() != null : !this.layoutNodeId.equals(other.getLayoutNodeId())) {
            return false;
        }
        if (this.portletDefinition == null ? other.getPortletDefinition() != null : !this.portletDefinition.equals((Object)other.getPortletDefinition())) {
            return false;
        }
        return this.userId == other.getUserId();
    }

    public String toString() {
        return "PortletEntity [portletEntityId=" + this.portletEntityId + ", " + "layoutNodeId=" + this.layoutNodeId + ", " + "userId=" + this.userId + ", " + "portletDefinition=" + this.portletDefinition + "]";
    }
}

