/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.IndexColumn;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletPreference;

@Entity
@Table(name="UP_PORTLET_PREFS")
@SequenceGenerator(name="UP_PORTLET_PREFS_GEN", sequenceName="UP_PORTLET_PREFS_SEQ", allocationSize=10)
@TableGenerator(name="UP_PORTLET_PREFS_GEN", pkColumnValue="UP_PORTLET_PREFS", allocationSize=10)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class PortletPreferencesImpl {
    @Id
    @GeneratedValue(generator="UP_PORTLET_PREFS_GEN")
    @Column(name="PORTLET_PREFS_ID")
    private final long portletPreferencesId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=PortletPreferenceImpl.class, fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="PORTLET_PREFS_ID")
    @IndexColumn(name="PREF_ORDER")
    @Fetch(value=FetchMode.JOIN)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<IPortletPreference> portletPreferences = new ArrayList(0);
    @Transient
    private final List<IPortletPreference> filteringPortletPreferences = new /* Unavailable Anonymous Inner Class!! */;

    public PortletPreferencesImpl() {
        this.portletPreferencesId = -1L;
        this.entityVersion = -1L;
    }

    public List<IPortletPreference> getPortletPreferences() {
        return this.filteringPortletPreferences;
    }

    public boolean setPortletPreferences(List<IPortletPreference> newPreferences) {
        if (this.portletPreferences == newPreferences) {
            return false;
        }
        if (newPreferences == null) {
            boolean modified = !this.portletPreferences.isEmpty();
            this.portletPreferences = new ArrayList(0);
            return modified;
        }
        boolean modified = false;
        LinkedHashMap<String, IPortletPreference> oldPreferences = new LinkedHashMap<String, IPortletPreference>();
        for (IPortletPreference preference : this.portletPreferences) {
            oldPreferences.put(preference.getName(), preference);
        }
        this.portletPreferences.clear();
        for (IPortletPreference preference : newPreferences) {
            String name = preference.getName();
            IPortletPreference existingPreference = (IPortletPreference)oldPreferences.remove(name);
            if (existingPreference == null) {
                modified = true;
                this.portletPreferences.add(preference);
                continue;
            }
            modified = modified || !existingPreference.equals(preference);
            existingPreference.setValues(preference.getValues());
            existingPreference.setReadOnly(preference.isReadOnly());
            this.portletPreferences.add(existingPreference);
        }
        return modified;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PortletPreferencesImpl)) {
            return false;
        }
        PortletPreferencesImpl rhs = (PortletPreferencesImpl)object;
        return new EqualsBuilder().append((Object)this.portletPreferences, (Object)rhs.getPortletPreferences()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1904185833, -1222355625).append((Object)this.portletPreferences).toHashCode();
    }

    public String toString() {
        return "PortletPreferencesImpl [portletPreferencesId=" + this.portletPreferencesId + ", entityVersion=" + this.entityVersion + "]";
    }

    static /* synthetic */ List access$100(PortletPreferencesImpl x0) {
        return x0.portletPreferences;
    }
}

