/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletType;

@Entity
@Table(name="UP_PORTLET_TYPE")
@SequenceGenerator(name="UP_PORTLET_TYPE_GEN", sequenceName="UP_PORTLET_TYPE_SEQ", allocationSize=1)
@TableGenerator(name="UP_PORTLET_TYPE_GEN", pkColumnValue="UP_PORTLET_TYPE", allocationSize=1)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PortletTypeImpl
implements Serializable,
IPortletType {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_PORTLET_TYPE_GEN")
    @Column(name="TYPE_ID")
    private final int internalId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @OneToMany(mappedBy="portletType", targetEntity=PortletDefinitionImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private transient Set<IPortletDefinition> portletDefinitions = null;
    @NaturalId
    @Column(name="TYPE_NAME", length=70)
    private final String name;
    @Column(name="TYPE_DESCR", length=2000)
    private String descr;
    @Column(name="TYPE_DEF_URI", length=255, nullable=false)
    private String cpdUri;

    private PortletTypeImpl() {
        this.internalId = -1;
        this.entityVersion = -1L;
        this.name = null;
    }

    public PortletTypeImpl(String name, String cpdUri) {
        this.internalId = -1;
        this.entityVersion = -1L;
        this.name = name;
        this.cpdUri = cpdUri;
    }

    public int getId() {
        return this.internalId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.descr;
    }

    public String getCpdUri() {
        return this.cpdUri;
    }

    public void setDescription(String descr) {
        this.descr = descr;
    }

    public void setCpdUri(String cpdUri) {
        this.cpdUri = cpdUri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IPortletType.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IPortletType other = (IPortletType)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return "PortletTypeImpl [internalId=" + this.internalId + ", name=" + this.name + ", descr=" + this.descr + ", cpdUri=" + this.cpdUri + "]";
    }

    public String getDataId() {
        return Integer.toString(this.getId());
    }

    public String getDataTitle() {
        return this.name;
    }

    public String getDataDescription() {
        return this.descr;
    }
}

