/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.trans;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.portlet.dao.IPortletEntityDao;
import org.jasig.portal.portlet.dao.trans.TransientPortletEntity;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="transient")
public class TransientPortletEntityDao
implements IPortletEntityDao {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletEntityDao delegatePortletEntityDao;
    private IUserInstanceManager userInstanceManager;
    private IPortalRequestUtils portalRequestUtils;

    @Autowired
    public void setDelegatePortletEntityDao(@Qualifier(value="persistence") IPortletEntityDao delegatePortletEntityDao) {
        this.delegatePortletEntityDao = delegatePortletEntityDao;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletEntity createPortletEntity(IPortletDefinitionId portletDefinitionId, String layoutNodeId, int userId) {
        if (layoutNodeId.startsWith("ctf")) {
            String transientLayoutNodeId = layoutNodeId;
            layoutNodeId = this.getPersistentLayoutNodeId(portletDefinitionId);
            IPortletEntity portletEntity = this.delegatePortletEntityDao.createPortletEntity(portletDefinitionId, layoutNodeId, userId);
            return new TransientPortletEntity(portletEntity, transientLayoutNodeId);
        }
        return this.delegatePortletEntityDao.createPortletEntity(portletDefinitionId, layoutNodeId, userId);
    }

    public void deletePortletEntity(IPortletEntity portletEntity) {
        portletEntity = this.unwrapEntity(portletEntity);
        this.delegatePortletEntityDao.deletePortletEntity(portletEntity);
    }

    public Set<IPortletEntity> getPortletEntities(IPortletDefinitionId portletDefinitionId) {
        Set portletEntities = this.delegatePortletEntityDao.getPortletEntities(portletDefinitionId);
        return this.wrapEntities(portletEntities);
    }

    public Set<IPortletEntity> getPortletEntitiesForUser(int userId) {
        Set portletEntities = this.delegatePortletEntityDao.getPortletEntitiesForUser(userId);
        return this.wrapEntities(portletEntities);
    }

    public IPortletEntity getPortletEntity(IPortletEntityId portletEntityId) {
        IPortletEntity portletEntity = this.delegatePortletEntityDao.getPortletEntity(portletEntityId);
        return this.wrapEntity(portletEntity);
    }

    public boolean portletEntityExists(IPortletEntityId portletEntityId) {
        return this.delegatePortletEntityDao.portletEntityExists(portletEntityId);
    }

    public IPortletEntity getPortletEntity(String layoutNodeId, int userId) {
        if (layoutNodeId.startsWith("ctf")) {
            String databaseChannelSubscribeId = this.determineDatabaseChannelSubscribeId(layoutNodeId);
            IPortletEntity portletEntity = this.delegatePortletEntityDao.getPortletEntity(databaseChannelSubscribeId, userId);
            return this.wrapEntity(portletEntity);
        }
        return this.delegatePortletEntityDao.getPortletEntity(layoutNodeId, userId);
    }

    public void updatePortletEntity(IPortletEntity portletEntity) {
        portletEntity = this.unwrapEntity(portletEntity);
        this.delegatePortletEntityDao.updatePortletEntity(portletEntity);
    }

    protected IPortletEntity unwrapEntity(IPortletEntity portletEntity) {
        if (portletEntity instanceof TransientPortletEntity) {
            return ((TransientPortletEntity)portletEntity).getDelegatePortletEntity();
        }
        return portletEntity;
    }

    protected IPortletEntity wrapEntity(IPortletEntity portletEntity) {
        if (portletEntity == null) {
            return null;
        }
        String persistentLayoutNodeId = portletEntity.getLayoutNodeId();
        if (persistentLayoutNodeId.startsWith("ctf")) {
            IUserLayoutManager userLayoutManager = this.getUserLayoutManager();
            if (userLayoutManager == null) {
                this.logger.warn((Object)("Could not find IUserLayoutManager when trying to wrap transient portlet entity: " + portletEntity));
                return portletEntity;
            }
            IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
            String fname = portletDefinition.getFName();
            String layoutNodeId = userLayoutManager.getSubscribeId(fname);
            return new TransientPortletEntity(portletEntity, layoutNodeId);
        }
        return portletEntity;
    }

    protected Set<IPortletEntity> wrapEntities(Set<IPortletEntity> portletEntities) {
        LinkedHashSet<IPortletEntity> wrappedPortletEntities = new LinkedHashSet<IPortletEntity>(portletEntities.size());
        for (IPortletEntity portletEntity : portletEntities) {
            IPortletEntity wrappedEntity = this.wrapEntity(portletEntity);
            if (wrappedEntity == null) continue;
            wrappedPortletEntities.add(wrappedEntity);
        }
        return wrappedPortletEntities;
    }

    protected String determineDatabaseChannelSubscribeId(String layoutNodeId) {
        IUserLayoutManager userLayoutManager = this.getUserLayoutManager();
        IUserLayoutChannelDescription channelNode = (IUserLayoutChannelDescription)userLayoutManager.getNode(layoutNodeId);
        String portletPublishId = channelNode.getChannelPublishId();
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(portletPublishId);
        return this.getPersistentLayoutNodeId(portletDefinition.getPortletDefinitionId());
    }

    protected String getPersistentLayoutNodeId(IPortletDefinitionId portletDefinitionId) {
        return "ctf." + portletDefinitionId.getStringId();
    }

    protected IUserLayoutManager getUserLayoutManager() {
        HttpServletRequest portalRequest = this.portalRequestUtils.getCurrentPortalRequest();
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(portalRequest);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        return preferencesManager.getUserLayoutManager();
    }
}

