/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation;

import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.api.portlet.DelegationRequest;
import org.jasig.portal.api.portlet.DelegationResponse;
import org.jasig.portal.api.portlet.PortletDelegationDispatcher;
import org.jasig.portal.api.portlet.PortletDelegationLocator;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.View;

public class PortletDelegationView
implements View {
    public static final String DELEGATE_RENDER_OUTPUT_HANDLER = "DELEGATE_RENDER_OUTPUT_HANDLER";
    public static final String DELEGATE_REQUEST = "DELEGATE_REQUEST";
    public static final String DELEGATE_PORTLET_WINDOW_ID = "DELEGATE_PORTLET_WINDOW_ID";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletDelegationLocator portletDelegationLocator;

    @Autowired
    public void setPortletDelegationLocator(PortletDelegationLocator portletDelegationLocator) {
        this.portletDelegationLocator = portletDelegationLocator;
    }

    public String getContentType() {
        return null;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DelegationResponse delegationResponse;
        IPortletWindowId portletWindowId = (IPortletWindowId)model.get(DELEGATE_PORTLET_WINDOW_ID);
        DelegationRequest delegationRequest = (DelegationRequest)model.get(DELEGATE_REQUEST);
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletDelegationDispatcher requestDispatcher = this.portletDelegationLocator.getRequestDispatcher(portletRequest, portletWindowId);
        if (requestDispatcher == null) {
            throw new IllegalArgumentException("No PortletDelegationDispatcher exists for portlet window id: " + portletWindowId);
        }
        this.logger.debug("Found delegation dispatcher for portlet window id {} - {}", (Object)portletWindowId, (Object)requestDispatcher);
        String phase = (String)request.getAttribute("javax.portlet.lifecycle_phase");
        if ("RENDER_PHASE".equals(phase)) {
            PortletOutputHandler portletOutputHandler = (PortletOutputHandler)model.get(DELEGATE_RENDER_OUTPUT_HANDLER);
            if (portletOutputHandler != null) {
                this.logger.debug("Delegating RenderRequest with custom Writer and {}", (Object)delegationRequest);
                delegationResponse = requestDispatcher.doRender((RenderRequest)portletRequest, (RenderResponse)portletResponse, delegationRequest, portletOutputHandler);
            } else {
                this.logger.debug("Delegating RenderRequest with default Writer and {}", (Object)delegationRequest);
                delegationResponse = requestDispatcher.doRender((RenderRequest)portletRequest, (RenderResponse)portletResponse, delegationRequest);
            }
        } else if ("RESOURCE_PHASE".equals(phase)) {
            this.logger.debug("Delegating ResourceRequest and {}", (Object)delegationRequest);
            delegationResponse = requestDispatcher.doServeResource((ResourceRequest)portletRequest, (ResourceResponse)portletResponse, delegationRequest);
        } else {
            throw new UnsupportedOperationException("Portlet lifecycle phase " + phase + " is not supported by the delegation view");
        }
        this.logger.debug("{}", (Object)delegationResponse);
    }
}

