/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.PortletCategory;
import org.jasig.portal.portlet.registry.IPortletCategoryRegistry;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="portletCategoryRegistry")
public class PortletCategoryRegistryImpl
implements IPortletCategoryRegistry {
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private final Log log = LogFactory.getLog(this.getClass());

    @Autowired(required=true)
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public void addCategoryToCategory(PortletCategory child, PortletCategory parent) {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup((String)childKey);
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup((String)parentKey);
        parentGroup.addMember((IGroupMember)childGroup);
        parentGroup.updateMembers();
    }

    public void deletePortletCategory(PortletCategory category) {
        String key = String.valueOf(category.getId());
        ILockableEntityGroup categoryGroup = GroupService.findLockableGroup((String)key, (String)"UP_PORTLET_PUBLISH");
        categoryGroup.delete();
    }

    public Set<PortletCategory> getAllChildCategories(PortletCategory parent) {
        HashSet<PortletCategory> rslt = new HashSet<PortletCategory>();
        for (PortletCategory child : this.getChildCategories(parent)) {
            rslt.add(child);
            rslt.addAll(this.getAllChildCategories(child));
        }
        return rslt;
    }

    public Set<IPortletDefinition> getAllChildPortlets(PortletCategory parent) {
        HashSet<IPortletDefinition> rslt = new HashSet<IPortletDefinition>();
        try {
            for (IPortletDefinition portlet : this.getChildPortlets(parent)) {
                rslt.add(portlet);
            }
            for (PortletCategory category : this.getAllChildCategories(parent)) {
                for (IPortletDefinition portlet : this.getChildPortlets(category)) {
                    rslt.add(portlet);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain child portlets for the specified parent '" + parent.getName() + "', id=" + parent.getId();
            throw new PortalException(msg, (Throwable)e);
        }
        return rslt;
    }

    public PortletCategory getPortletCategory(String portletCategoryId) {
        IEntityGroup categoryGroup = GroupService.findGroup((String)portletCategoryId);
        if (categoryGroup == null) {
            return null;
        }
        PortletCategory category = new PortletCategory(portletCategoryId);
        category.setName(categoryGroup.getName());
        category.setDescription(categoryGroup.getDescription());
        category.setCreatorId(categoryGroup.getCreatorID());
        return category;
    }

    public Set<PortletCategory> getChildCategories(PortletCategory parent) {
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup((String)parentKey);
        HashSet<PortletCategory> categories = new HashSet<PortletCategory>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            categories.add(this.getPortletCategory(categoryId));
        }
        return categories;
    }

    public Set<IPortletDefinition> getChildPortlets(PortletCategory parent) {
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup((String)parentKey);
        HashSet<IPortletDefinition> portletDefs = new HashSet<IPortletDefinition>();
        Iterator iter = parentGroup.getMembers();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isEntity()) continue;
            IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(gm.getKey());
            if (portletDefinition != null) {
                portletDefs.add(portletDefinition);
                continue;
            }
            this.log.warn((Object)("portletDefinition was null for groupMember: " + gm));
        }
        return portletDefs;
    }

    public Set<PortletCategory> getParentCategories(PortletCategory child) {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup((String)childKey);
        HashSet<PortletCategory> parents = new HashSet<PortletCategory>();
        Iterator iter = childGroup.getContainingGroups();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            parents.add(this.getPortletCategory(categoryId));
        }
        return parents;
    }

    public Set<PortletCategory> getParentCategories(IPortletDefinition child) {
        String childKey = child.getPortletDefinitionId().getStringId();
        IEntity childEntity = GroupService.getEntity((String)childKey, IPortletDefinition.class);
        HashSet<PortletCategory> parents = new HashSet<PortletCategory>();
        Iterator iter = childEntity.getContainingGroups();
        while (iter.hasNext()) {
            IGroupMember gm = (IGroupMember)iter.next();
            if (!gm.isGroup()) continue;
            String categoryId = gm.getKey();
            parents.add(this.getPortletCategory(categoryId));
        }
        return parents;
    }

    public PortletCategory getTopLevelPortletCategory() {
        IEntityGroup categoryGroup = GroupService.getDistinguishedGroup((String)IGroupConstants.PORTLET_CATEGORIES);
        return this.getPortletCategory(categoryGroup.getKey());
    }

    public PortletCategory createPortletCategory(String name, String description, String creatorId) {
        IEntityGroup categoryGroup = GroupService.newGroup(IPortletDefinition.class);
        categoryGroup.setName(name);
        categoryGroup.setCreatorID(creatorId);
        categoryGroup.setDescription(description);
        categoryGroup.update();
        String id = categoryGroup.getKey();
        PortletCategory cat = new PortletCategory(id);
        cat.setName(name);
        cat.setDescription(description);
        cat.setCreatorId(creatorId);
        return cat;
    }

    public void removeCategoryFromCategory(PortletCategory child, PortletCategory parent) {
        String childKey = String.valueOf(child.getId());
        IEntityGroup childGroup = GroupService.findGroup((String)childKey);
        String parentKey = String.valueOf(parent.getId());
        IEntityGroup parentGroup = GroupService.findGroup((String)parentKey);
        parentGroup.removeMember((IGroupMember)childGroup);
        parentGroup.updateMembers();
    }

    public void updatePortletCategory(PortletCategory category) {
        IEntityGroup categoryGroup = GroupService.findGroup((String)category.getId());
        categoryGroup.setName(category.getName());
        categoryGroup.setDescription(category.getDescription());
        categoryGroup.setCreatorID(category.getCreatorId());
        categoryGroup.update();
    }
}

