/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.lang.Validate;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindowDescriptor;
import org.jasig.portal.portlet.om.IPortletWindowId;

class PortletWindowData
implements IPortletWindowDescriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IPortletEntityId portletEntityId;
    private final IPortletWindowId portletWindowId;
    private final IPortletWindowId delegationParentId;
    private volatile Map<String, String[]> renderParameters = Collections.emptyMap();
    private volatile Map<String, String[]> publicRenderParameters = Collections.emptyMap();
    private volatile transient PortletMode portletMode = PortletMode.VIEW;
    private volatile transient WindowState windowState = WindowState.NORMAL;
    private volatile Integer expirationCache = null;

    public PortletWindowData(IPortletWindowId portletWindowId, IPortletEntityId portletEntityId, IPortletWindowId delegationParentId) {
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        this.portletWindowId = portletWindowId;
        this.portletEntityId = portletEntityId;
        this.delegationParentId = delegationParentId;
    }

    public PortletWindowData(IPortletWindowId portletWindowId, IPortletEntityId portletEntityId) {
        this(portletWindowId, portletEntityId, null);
    }

    public Map<String, String[]> getRenderParameters() {
        return this.renderParameters;
    }

    public void setRenderParameters(Map<String, String[]> renderParameters) {
        Validate.notNull(renderParameters, (String)"renderParameters can not be null");
        this.renderParameters = renderParameters;
    }

    public Map<String, String[]> getPublicRenderParameters() {
        return this.publicRenderParameters;
    }

    public void setPublicRenderParameters(Map<String, String[]> publicRenderParameters) {
        Validate.notNull(publicRenderParameters, (String)"publicRenderParameters can not be null");
        this.publicRenderParameters = publicRenderParameters;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setPortletMode(PortletMode portletMode) {
        Validate.notNull((Object)portletMode, (String)"PortletMode can not be null");
        this.portletMode = portletMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setWindowState(WindowState windowState) {
        Validate.notNull((Object)windowState, (String)"WindowState can not be null");
        this.windowState = windowState;
    }

    public Integer getExpirationCache() {
        return this.expirationCache;
    }

    public void setExpirationCache(Integer expirationCache) {
        this.expirationCache = expirationCache;
    }

    public IPortletEntityId getPortletEntityId() {
        return this.portletEntityId;
    }

    public IPortletWindowId getPortletWindowId() {
        return this.portletWindowId;
    }

    public IPortletWindowId getDelegationParentId() {
        return this.delegationParentId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegationParentId == null ? 0 : this.delegationParentId.hashCode());
        result = 31 * result + (this.portletEntityId == null ? 0 : this.portletEntityId.hashCode());
        result = 31 * result + (this.portletWindowId == null ? 0 : this.portletWindowId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortletWindowData other = (PortletWindowData)obj;
        if (this.delegationParentId == null ? other.delegationParentId != null : !this.delegationParentId.equals(other.delegationParentId)) {
            return false;
        }
        if (this.portletEntityId == null ? other.portletEntityId != null : !this.portletEntityId.equals(other.portletEntityId)) {
            return false;
        }
        return !(this.portletWindowId == null ? other.portletWindowId != null : !this.portletWindowId.equals(other.portletWindowId));
    }

    public String toString() {
        return "PortletWindow [portletWindowId=" + this.portletWindowId + ", " + "delegationParentId=" + this.delegationParentId + ", " + "portletMode=" + this.portletMode + ", " + "windowState=" + this.windowState + ", " + "expirationCache=" + this.expirationCache + ", " + "renderParameters=" + this.renderParameters + ", " + "publicRenderParameters=" + this.publicRenderParameters + ", " + "portletEntityId=" + this.portletEntityId + "]";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.portletMode.toString());
        oos.writeObject(this.windowState.toString());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.portletWindowId == null) {
            throw new InvalidObjectException("portletWindowId can not be null");
        }
        if (this.portletEntityId == null) {
            throw new InvalidObjectException("portletEntityId can not be null");
        }
        String portletModeStr = (String)ois.readObject();
        if (portletModeStr == null) {
            throw new InvalidObjectException("portletMode can not be null");
        }
        this.portletMode = PortletUtils.getPortletMode((String)portletModeStr);
        String windowStateStr = (String)ois.readObject();
        if (windowStateStr == null) {
            throw new InvalidObjectException("windowState can not be null");
        }
        this.windowState = PortletUtils.getWindowState((String)windowStateStr);
    }
}

