/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.registry;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import org.apache.commons.lang.Validate;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.PortletWindowID;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.concurrency.caching.RequestCache;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetParameterDescriptor;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowDescriptor;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.registry.PortletWindowCache;
import org.jasig.portal.portlet.registry.PortletWindowData;
import org.jasig.portal.portlet.registry.PortletWindowIdImpl;
import org.jasig.portal.portlet.registry.PortletWindowImpl;
import org.jasig.portal.portlet.registry.StatelessPortletWindowImpl;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.WebUtils;

@Service
public class PortletWindowRegistryImpl
implements IPortletWindowRegistry {
    public static final QName PORTLET_WINDOW_ID_ATTR_NAME = new QName("portletWindowId");
    static final char ID_PART_SEPERATOR = '.';
    static final Pattern ID_PART_SEPERATOR_PATTERN = Pattern.compile(Pattern.quote(String.valueOf('.')));
    static final String STATELESS_PORTLET_WINDOW_ID = "tw";
    static final String PORTLET_WINDOW_DATA_ATTRIBUTE = PortletWindowRegistryImpl.class.getName() + ".PORTLET_WINDOW_DATA";
    static final String PORTLET_WINDOW_ATTRIBUTE = PortletWindowRegistryImpl.class.getName() + ".PORTLET_WINDOW.thread-";
    static final String DISABLE_PERSISTENT_WINDOWS = PortletWindowRegistryImpl.class.getName() + ".DISABLE_PERSISTENT_WINDOWS";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private Set<WindowState> persistentWindowStates = Sets.newHashSet((Object[])new WindowState[]{WindowState.MINIMIZED});
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IStylesheetDescriptorDao stylesheetDescriptorDao;
    private IUserInstanceManager userInstanceManager;
    private IPortalRequestUtils portalRequestUtils;
    private IUrlSyntaxProvider urlSyntaxProvider;

    public void setPersistentWindowStates(Set<WindowState> persistentWindowStates) {
        this.persistentWindowStates = persistentWindowStates;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletWindow convertPortletWindow(HttpServletRequest request, PortletWindow plutoPortletWindow) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)plutoPortletWindow, (String)"portletWindow can not be null");
        PortletWindowID plutoWindowId = plutoPortletWindow.getId();
        Object portletWindowId = plutoWindowId instanceof IPortletWindowId ? (IPortletWindowId)plutoWindowId : this.getPortletWindowId(request, plutoWindowId.getStringId());
        return this.getPortletWindow(request, portletWindowId);
    }

    public IPortletWindow getOrCreateDefaultPortletWindowByFname(HttpServletRequest request, String fname) {
        Validate.notNull((Object)request, (String)"HttpServletRequest cannot be null");
        Validate.notNull((Object)fname, (String)"fname cannot be null");
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntityByFname(request, userInstance, fname);
        if (portletEntity == null) {
            return null;
        }
        IPortletWindow portletWindow = this.getOrCreateDefaultPortletWindow(request, portletEntity.getPortletEntityId());
        this.logger.trace("Found portlet window {} for portlet definition fname {}", (Object)portletWindow, (Object)fname);
        return portletWindow;
    }

    public IPortletWindow getOrCreateDefaultPortletWindowByLayoutNodeId(HttpServletRequest request, String subscribeId) {
        Validate.notNull((Object)request, (String)"HttpServletRequest cannot be null");
        Validate.notNull((Object)subscribeId, (String)"subscribeId cannot be null");
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(request, userInstance, subscribeId);
        if (portletEntity == null) {
            this.logger.debug("No portlet entity found for id {}, no IPortletWindow will be returned.", (Object)subscribeId);
            return null;
        }
        this.logger.trace("Found portlet entity {} for id {}", (Object)portletEntity, (Object)subscribeId);
        IPortletWindow portletWindow = this.getOrCreateDefaultPortletWindow(request, portletEntity.getPortletEntityId());
        this.logger.trace("Found portlet window {} for layout node {}", (Object)portletWindow, (Object)subscribeId);
        return portletWindow;
    }

    public IPortletWindow getOrCreateDefaultPortletWindow(HttpServletRequest request, IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)request, (String)"HttpServletRequest cannot be null");
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinition cannot be null");
        IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreateDefaultPortletEntity(request, portletDefinitionId);
        IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
        return this.getOrCreateDefaultPortletWindow(request, portletEntityId);
    }

    public IPortletWindow getOrCreateDefaultPortletWindow(HttpServletRequest request, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletWindowId portletWindowId = this.getDefaultPortletWindowId(request, portletEntityId);
        PortletWindowCache portletWindowMap = this.getPortletWindowMap(request);
        IPortletWindow portletWindow = (IPortletWindow)portletWindowMap.getWindow(portletWindowId);
        if (portletWindow != null) {
            this.logger.trace("Found IPortletWindow {} in request cache", (Object)portletWindow.getPortletWindowId());
            return portletWindow;
        }
        PortletWindowData portletWindowData = this.getOrCreateDefaultPortletWindowData(request, portletEntityId, portletWindowId);
        portletWindow = this.wrapPortletWindowData(request, portletWindowData);
        if (portletWindow == null) {
            return null;
        }
        return (IPortletWindow)portletWindowMap.storeIfAbsentWindow((IPortletWindowDescriptor)portletWindow);
    }

    public IPortletWindow getPortletWindow(HttpServletRequest request, IPortletWindowId portletWindowId) {
        PortletWindowCache statelessPortletWindowDataMap;
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        PortletWindowCache portletWindowMap = this.getPortletWindowMap(request);
        IPortletWindow portletWindow = (IPortletWindow)portletWindowMap.getWindow(portletWindowId);
        if (portletWindow != null) {
            this.logger.trace("Found IPortletWindow {} in request cache", (Object)portletWindow.getPortletWindowId());
            return portletWindow;
        }
        PortletWindowIdImpl localPortletWindowId = this.convertPortletWindowId(request, portletWindowId);
        Object portletWindowData = STATELESS_PORTLET_WINDOW_ID.equals(localPortletWindowId.getWindowInstanceId()) ? ((statelessPortletWindowDataMap = this.getStatelessPortletWindowDataMap(request, false)) != null ? (PortletWindowData)statelessPortletWindowDataMap.getWindow(portletWindowId) : null) : this.getPortletWindowData(request, portletWindowId);
        if (portletWindowData == null) {
            this.logger.trace("No IPortletWindow {} exists, returning null");
            return null;
        }
        portletWindow = this.wrapPortletWindowData(request, portletWindowData);
        return (IPortletWindow)portletWindowMap.storeIfAbsentWindow((IPortletWindowDescriptor)portletWindow);
    }

    public PortletWindowIdImpl getPortletWindowId(HttpServletRequest request, String portletWindowId) {
        String instanceId;
        String entityIdStr;
        Validate.notNull((Object)portletWindowId, (String)"portletWindowId can not be null");
        String[] portletWindowIdParts = ID_PART_SEPERATOR_PATTERN.split(portletWindowId);
        if (portletWindowIdParts.length == 1) {
            entityIdStr = portletWindowIdParts[0];
            instanceId = null;
        } else if (portletWindowIdParts.length == 2) {
            entityIdStr = portletWindowIdParts[0];
            instanceId = portletWindowIdParts[1];
        } else {
            throw new IllegalArgumentException("Provided portlet window ID '" + portletWindowId + "' is not valid");
        }
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(request, entityIdStr);
        if (portletEntity == null) {
            throw new IllegalArgumentException("No parent IPortletEntity found for id '" + entityIdStr + "' from portlet window id: " + portletWindowId);
        }
        return this.createPortletWindowId(instanceId, portletEntity.getPortletEntityId());
    }

    public IPortletWindowId getDefaultPortletWindowId(HttpServletRequest request, IPortletEntityId portletEntityId) {
        PortletWindowIdImpl portletWindowId = this.createPortletWindowId(null, portletEntityId);
        this.logger.trace("Determined default portlet window id {} for portlet entity {}", (Object)portletWindowId, (Object)portletEntityId);
        return portletWindowId;
    }

    public IPortletWindow createDelegatePortletWindow(HttpServletRequest request, IPortletEntityId portletEntityId, IPortletWindowId delegationParentId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        IPortletWindowId portletWindowId = this.getDefaultPortletWindowId(request, portletEntityId);
        PortletWindowCache portletWindowMap = this.getPortletWindowMap(request);
        IPortletWindow portletWindow = (IPortletWindow)portletWindowMap.getWindow(portletWindowId);
        if (portletWindow != null) {
            this.logger.trace("Found IPortletWindow {} in request cache", (Object)portletWindow.getPortletWindowId());
            return portletWindow;
        }
        PortletWindowData portletWindowData = this.getOrCreateDefaultPortletWindowData(request, portletEntityId, portletWindowId, delegationParentId);
        portletWindow = this.wrapPortletWindowData(request, portletWindowData);
        if (portletWindow == null) {
            return null;
        }
        return (IPortletWindow)portletWindowMap.storeIfAbsentWindow((IPortletWindowDescriptor)portletWindow);
    }

    public Set<IPortletWindow> getAllPortletWindowsForEntity(HttpServletRequest request, IPortletEntityId portletEntityId) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletEntityId, (String)"portletEntityId can not be null");
        PortletWindowCache portletWindowMap = this.getPortletWindowMap(request);
        LinkedHashSet<IPortletWindow> portletWindows = new LinkedHashSet<IPortletWindow>(portletWindowMap.getWindows(portletEntityId));
        PortletWindowCache portletWindowDataMap = this.getPortletWindowDataMap(request);
        this.addPortletWindowData(request, portletEntityId, portletWindows, portletWindowMap, portletWindowDataMap);
        PortletWindowCache statelessPortletWindowDataMap = this.getStatelessPortletWindowDataMap(request, false);
        if (statelessPortletWindowDataMap != null) {
            this.addPortletWindowData(request, portletEntityId, portletWindows, portletWindowMap, statelessPortletWindowDataMap);
        }
        if (portletWindows.isEmpty()) {
            IPortletWindow portletWindow = this.getOrCreateDefaultPortletWindow(request, portletEntityId);
            portletWindows.add(portletWindow);
        }
        return portletWindows;
    }

    public Tuple<IPortletWindow, StartElement> getPortletWindow(HttpServletRequest request, StartElement element) {
        Attribute windowIdAttribute = element.getAttributeByName(PORTLET_WINDOW_ID_ATTR_NAME);
        if (windowIdAttribute != null) {
            String windowIdStr = windowIdAttribute.getValue();
            PortletWindowIdImpl portletWindowId = this.getPortletWindowId(request, windowIdStr);
            IPortletWindow portletWindow = this.getPortletWindow(request, (IPortletWindowId)portletWindowId);
            return new Tuple((Object)portletWindow, (Object)element);
        }
        Attribute nodeIdAttribute = element.getAttributeByName(IUserLayoutManager.ID_ATTR_NAME);
        String layoutNodeId = nodeIdAttribute.getValue();
        IPortletWindow portletWindow = this.getOrCreateDefaultPortletWindowByLayoutNodeId(request, layoutNodeId);
        if (portletWindow == null) {
            return null;
        }
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        if (portalRequestInfo.getUrlState() == UrlState.DETACHED) {
            IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
            portletWindow = this.getOrCreateStatelessPortletWindow(request, portletWindowId);
        }
        element = this.addPortletWindowId(element, portletWindow.getPortletWindowId());
        return new Tuple((Object)portletWindow, (Object)element);
    }

    protected StartElement addPortletWindowId(StartElement element, IPortletWindowId portletWindowId) {
        Attribute windowIdAttribute = this.xmlEventFactory.createAttribute(PORTLET_WINDOW_ID_ATTR_NAME, portletWindowId.getStringId());
        QName name = element.getName();
        String prefix = name.getPrefix();
        String namespaceURI = name.getNamespaceURI();
        String localPart = name.getLocalPart();
        Iterator<Attribute> attributes = element.getAttributes();
        Iterator<Namespace> namespaces = element.getNamespaces();
        NamespaceContext namespaceContext = element.getNamespaceContext();
        Iterator newAttributes = Iterators.concat(attributes, (Iterator)Iterators.forArray((Object[])new Attribute[]{windowIdAttribute}));
        return this.xmlEventFactory.createStartElement(prefix, namespaceURI, localPart, newAttributes, namespaces, namespaceContext);
    }

    protected void addPortletWindowData(HttpServletRequest request, IPortletEntityId portletEntityId, Set<IPortletWindow> portletWindows, PortletWindowCache<IPortletWindow> portletWindowMap, PortletWindowCache<PortletWindowData> portletWindowDataMap) {
        Set windows = portletWindowDataMap.getWindows(portletEntityId);
        if (windows == null) {
            return;
        }
        for (PortletWindowData portletWindowData : windows) {
            IPortletWindowId portletWindowId = portletWindowData.getPortletWindowId();
            if (!portletEntityId.equals(portletWindowData.getPortletEntityId()) || portletWindowMap.containsWindow(portletWindowId)) continue;
            IPortletWindow portletWindow = this.wrapPortletWindowData(request, portletWindowData);
            portletWindow = (IPortletWindow)portletWindowMap.storeIfAbsentWindow((IPortletWindowDescriptor)portletWindow);
            portletWindows.add(portletWindow);
        }
    }

    public IPortletWindow getOrCreateStatelessPortletWindow(HttpServletRequest request, IPortletWindowId basePortletWindowId) {
        IPortletEntityId portletEntityId;
        PortletWindowIdImpl statelessPortletWindowId;
        IPortletWindow statelessPortletWindow;
        if (!(basePortletWindowId instanceof PortletWindowIdImpl)) {
            String basePortletWindowIdStr = basePortletWindowId.getStringId();
            basePortletWindowId = this.getPortletWindowId(request, basePortletWindowIdStr);
        }
        if ((statelessPortletWindow = this.getPortletWindow(request, (IPortletWindowId)(statelessPortletWindowId = this.createPortletWindowId(STATELESS_PORTLET_WINDOW_ID, portletEntityId = ((PortletWindowIdImpl)basePortletWindowId).getPortletEntityId())))) != null) {
            return statelessPortletWindow;
        }
        IPortletWindow basePortletWindow = this.getPortletWindow(request, basePortletWindowId);
        PortletWindowCache statelessPortletWindowDataMap = this.getStatelessPortletWindowDataMap(request, true);
        if (basePortletWindow == null) {
            IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(request, portletEntityId);
            if (portletEntity == null) {
                throw new IllegalArgumentException("No IPortletEntity could be found for " + portletEntity + " while creating stateless portlet window for " + basePortletWindowId);
            }
            IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
            IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
            PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinitionId);
            PortletWindowData portletWindowData = new PortletWindowData((IPortletWindowId)statelessPortletWindowId, portletEntityId);
            statelessPortletWindowDataMap.storeWindow((IPortletWindowDescriptor)portletWindowData);
            statelessPortletWindow = new StatelessPortletWindowImpl(portletWindowData, portletEntity, portletDescriptor);
        } else {
            PortletWindowData portletWindowData = new PortletWindowData((IPortletWindowId)statelessPortletWindowId, portletEntityId);
            portletWindowData.setExpirationCache(basePortletWindow.getExpirationCache());
            portletWindowData.setPortletMode(basePortletWindow.getPortletMode());
            portletWindowData.setWindowState(basePortletWindow.getWindowState());
            portletWindowData.setPublicRenderParameters(basePortletWindow.getPublicRenderParameters());
            portletWindowData.setRenderParameters(basePortletWindow.getRenderParameters());
            statelessPortletWindowDataMap.storeWindow((IPortletWindowDescriptor)portletWindowData);
            IPortletEntity portletEntity = basePortletWindow.getPortletEntity();
            PortletDefinition portletDescriptor = basePortletWindow.getPlutoPortletWindow().getPortletDefinition();
            statelessPortletWindow = new StatelessPortletWindowImpl(portletWindowData, portletEntity, portletDescriptor);
        }
        PortletWindowCache portletWindowMap = this.getPortletWindowMap(request);
        portletWindowMap.storeWindow((IPortletWindowDescriptor)statelessPortletWindow);
        return statelessPortletWindow;
    }

    public void disablePersistentWindowStates(HttpServletRequest request) {
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        request.setAttribute(DISABLE_PERSISTENT_WINDOWS, (Object)Boolean.TRUE);
    }

    protected boolean isDisablePersistentWindowStates(HttpServletRequest request) {
        return Boolean.TRUE == (request = this.portalRequestUtils.getOriginalPortalRequest(request)).getAttribute(DISABLE_PERSISTENT_WINDOWS);
    }

    public void storePortletWindow(HttpServletRequest request, IPortletWindow portletWindow) {
        IPortletEntity portletEntity;
        WindowState entityWindowState;
        if (this.isDisablePersistentWindowStates(request)) {
            return;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPerson person = userInstance.getPerson();
        if (person.isGuest()) {
            return;
        }
        IStylesheetDescriptor themeStylesheetDescriptor = this.getThemeStylesheetDescriptor(request);
        WindowState windowState = portletWindow.getWindowState();
        if (windowState != (entityWindowState = (portletEntity = portletWindow.getPortletEntity()).getWindowState(themeStylesheetDescriptor)) && !windowState.equals((Object)entityWindowState)) {
            WindowState defaultWindowState = this.getDefaultWindowState(themeStylesheetDescriptor);
            if (!defaultWindowState.equals((Object)windowState) && this.persistentWindowStates.contains(windowState)) {
                portletEntity.setWindowState(themeStylesheetDescriptor, windowState);
            } else if (entityWindowState != null) {
                portletEntity.setWindowState(themeStylesheetDescriptor, null);
            }
            this.portletEntityRegistry.storePortletEntity(request, portletEntity);
        }
    }

    @RequestCache(keyMask={false})
    public Set<IPortletWindow> getAllLayoutPortletWindows(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        Set allSubscribedChannels = userLayoutManager.getAllSubscribedChannels();
        LinkedHashSet<IPortletWindow> allLayoutWindows = new LinkedHashSet<IPortletWindow>(allSubscribedChannels.size());
        for (String channelSubscribeId : allSubscribedChannels) {
            IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(request, userInstance, channelSubscribeId);
            if (portletEntity == null) {
                this.logger.debug("No portlet entity found for layout node {} for user {}", (Object)channelSubscribeId, (Object)userInstance.getPerson().getUserName());
                continue;
            }
            IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
            IPortletWindow portletWindow = this.getOrCreateDefaultPortletWindow(request, portletEntityId);
            if (portletWindow == null) {
                this.logger.debug("No portlet window found for {}", (Object)portletEntity);
                continue;
            }
            allLayoutWindows.add(portletWindow);
        }
        return allLayoutWindows;
    }

    @RequestCache(keyMask={false})
    public Set<IPortletWindow> getAllPortletWindows(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        Set allSubscribedChannels = userLayoutManager.getAllSubscribedChannels();
        LinkedHashSet<IPortletWindow> allLayoutWindows = new LinkedHashSet<IPortletWindow>(allSubscribedChannels.size());
        for (String channelSubscribeId : allSubscribedChannels) {
            IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(request, userInstance, channelSubscribeId);
            IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
            Set portletWindows = this.getAllPortletWindowsForEntity(request, portletEntityId);
            allLayoutWindows.addAll(portletWindows);
        }
        return allLayoutWindows;
    }

    protected PortletWindowIdImpl convertPortletWindowId(HttpServletRequest request, IPortletWindowId portletWindowId) {
        if (portletWindowId instanceof PortletWindowIdImpl) {
            return (PortletWindowIdImpl)portletWindowId;
        }
        return this.getPortletWindowId(request, portletWindowId.getStringId());
    }

    protected IPortletWindow wrapPortletWindowData(HttpServletRequest request, PortletWindowData portletWindowData) {
        IPortletEntityId portletEntityId = portletWindowData.getPortletEntityId();
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(request, portletEntityId);
        if (portletEntity == null) {
            return null;
        }
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinition.getPortletDefinitionId());
        if (portletDescriptor == null) {
            return null;
        }
        PortletWindowImpl portletWindow = new PortletWindowImpl(portletDescriptor, portletEntity, portletWindowData);
        this.logger.trace("Wrapping PortletWindowData {} as IPortletWindow", (Object)portletWindow.getPortletWindowId());
        return portletWindow;
    }

    protected PortletWindowData getPortletWindowData(HttpServletRequest request, IPortletWindowId portletWindowId) {
        PortletWindowCache portletWindowDataMap = this.getPortletWindowDataMap(request, false);
        if (portletWindowDataMap == null) {
            return null;
        }
        PortletWindowData portletWindowData = (PortletWindowData)portletWindowDataMap.getWindow(portletWindowId);
        if (portletWindowData == null) {
            this.logger.trace("No PortletWindowData {} in session cache", (Object)portletWindowId);
            return null;
        }
        this.logger.trace("Found PortletWindowData {} in session cache", (Object)portletWindowData.getPortletWindowId());
        return portletWindowData;
    }

    protected PortletWindowCache<IPortletWindow> getPortletWindowMap(HttpServletRequest request) {
        String mapAttributeName;
        PortletWindowCache windowCache = (PortletWindowCache)(request = this.portalRequestUtils.getOriginalPortletOrPortalRequest(request)).getAttribute(mapAttributeName = PORTLET_WINDOW_ATTRIBUTE + Thread.currentThread().getId());
        if (windowCache == null) {
            windowCache = new PortletWindowCache(false);
            request.setAttribute(mapAttributeName, (Object)windowCache);
        }
        return windowCache;
    }

    protected PortletWindowCache<PortletWindowData> getPortletWindowDataMap(HttpServletRequest request) {
        return this.getPortletWindowDataMap(request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletWindowCache<PortletWindowData> getPortletWindowDataMap(HttpServletRequest request, boolean create) {
        PortletWindowCache windowCache;
        Object mutex;
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        HttpSession session = request.getSession(create);
        if (!create && session == null) {
            return null;
        }
        Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
        synchronized (object) {
            windowCache = (PortletWindowCache)session.getAttribute(PORTLET_WINDOW_DATA_ATTRIBUTE);
            if (windowCache == null) {
                windowCache = new PortletWindowCache();
                session.setAttribute(PORTLET_WINDOW_DATA_ATTRIBUTE, (Object)windowCache);
            }
        }
        return windowCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletWindowCache<PortletWindowData> getStatelessPortletWindowDataMap(HttpServletRequest request, boolean create) {
        PortletWindowCache windowCache;
        Object mutex;
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        Object object = mutex = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (object) {
            windowCache = (PortletWindowCache)request.getAttribute(PORTLET_WINDOW_DATA_ATTRIBUTE);
            if (windowCache == null) {
                windowCache = new PortletWindowCache();
                request.setAttribute(PORTLET_WINDOW_DATA_ATTRIBUTE, (Object)windowCache);
            }
        }
        return windowCache;
    }

    protected PortletWindowData getOrCreateDefaultPortletWindowData(HttpServletRequest request, IPortletEntityId portletEntityId, IPortletWindowId portletWindowId) {
        return this.getOrCreateDefaultPortletWindowData(request, portletEntityId, portletWindowId, null);
    }

    protected PortletWindowData getOrCreateDefaultPortletWindowData(HttpServletRequest request, IPortletEntityId portletEntityId, IPortletWindowId portletWindowId, IPortletWindowId delegationParentId) {
        PortletWindowCache portletWindowDataMap = this.getPortletWindowDataMap(request);
        PortletWindowData portletWindowData = (PortletWindowData)portletWindowDataMap.getWindow(portletWindowId);
        if (portletWindowData != null) {
            this.logger.trace("Found PortletWindowData {} in session cache", (Object)portletWindowData.getPortletWindowId());
            return portletWindowData;
        }
        portletWindowData = new PortletWindowData(portletWindowId, portletEntityId, delegationParentId);
        this.initializePortletWindowData(request, portletWindowData);
        portletWindowData = (PortletWindowData)portletWindowDataMap.storeIfAbsentWindow((IPortletWindowDescriptor)portletWindowData);
        this.logger.trace("Created PortletWindowData {} and stored session cache, wrapping as IPortletWindow and returning", (Object)portletWindowData.getPortletWindowId());
        return portletWindowData;
    }

    protected void initializePortletWindowData(HttpServletRequest request, PortletWindowData portletWindowData) {
        IStylesheetDescriptor stylesheetDescriptor = this.getThemeStylesheetDescriptor(request);
        IPortletEntityId portletEntityId = portletWindowData.getPortletEntityId();
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(request, portletEntityId);
        WindowState entityWindowState = portletEntity.getWindowState(stylesheetDescriptor);
        if (this.persistentWindowStates.contains(entityWindowState)) {
            portletWindowData.setWindowState(entityWindowState);
        } else if (entityWindowState != null) {
            this.logger.warn("PortletEntity.windowState=" + entityWindowState + " but that state is not in the set of persistent WindowStates. PortletEntity.windowState will be set to null");
            portletEntity.setWindowState(stylesheetDescriptor, null);
            this.portletEntityRegistry.storePortletEntity(request, portletEntity);
        }
    }

    protected WindowState getDefaultWindowState(IStylesheetDescriptor stylesheetDescriptor) {
        IStylesheetParameterDescriptor defaultWindowStateParam = stylesheetDescriptor.getStylesheetParameterDescriptor("dashboardForcedWindowState");
        if (defaultWindowStateParam != null) {
            return PortletUtils.getWindowState((String)defaultWindowStateParam.getDefaultValue());
        }
        return WindowState.NORMAL;
    }

    protected IStylesheetDescriptor getThemeStylesheetDescriptor(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserProfile userProfile = preferencesManager.getUserProfile();
        int themeStylesheetId = userProfile.getThemeStylesheetId();
        return this.stylesheetDescriptorDao.getStylesheetDescriptor((long)themeStylesheetId);
    }

    protected PortletWindowIdImpl createPortletWindowId(String windowInstanceId, IPortletEntityId portletEntityId) {
        StringBuilder compositeIdString = new StringBuilder(portletEntityId.getStringId());
        if (windowInstanceId != null) {
            compositeIdString.append('.').append(windowInstanceId);
        }
        return new PortletWindowIdImpl(portletEntityId, windowInstanceId, compositeIdString.toString());
    }
}

