/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.portlet.Event;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.portlet.container.EventImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletEventCoordinationService;
import org.jasig.portal.portlet.rendering.PortletEventQueue;
import org.jasig.portal.portlet.rendering.QueuedEvent;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.jasig.portal.xml.XmlUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="eventCoordinationService")
public class PortletEventCoordinatationService
implements IPortletEventCoordinationService {
    public static final String GLOBAL_EVENT__CONTAINER_OPTION = "org.jasig.portal.globalEvent";
    private static final String PORTLET_EVENT_QUEUE = PortletEventCoordinatationService.class.getName() + ".PORTLET_EVENT_QUEUE";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IUserInstanceManager userInstanceManager;
    private Ehcache supportedEventCache;
    private IPortalRequestUtils portalRequestUtils;
    private XmlUtilities xmlUtilities;
    private PortletContextService portletContextService;

    @Autowired
    public void setPortletContextService(PortletContextService portletContextService) {
        this.portletContextService = portletContextService;
    }

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setSupportedEventCache(@Qualifier(value="org.jasig.portal.portlet.rendering.SupportedEventCache") Ehcache supportedEventCache) {
        this.supportedEventCache = supportedEventCache;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletEventQueue getPortletEventQueue(HttpServletRequest request) {
        request = this.portalRequestUtils.getOriginalPortalRequest(request);
        Object object = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (object) {
            PortletEventQueue portletEventQueue = (PortletEventQueue)request.getAttribute(PORTLET_EVENT_QUEUE);
            if (portletEventQueue == null) {
                portletEventQueue = new PortletEventQueue();
                request.setAttribute(PORTLET_EVENT_QUEUE, (Object)portletEventQueue);
            }
            return portletEventQueue;
        }
    }

    public void processEvents(PortletContainer container, PortletWindow plutoPortletWindow, HttpServletRequest request, HttpServletResponse response, List<Event> events) {
        PortletEventQueue requestPortletEventQueue = this.getPortletEventQueue(request);
        this.logger.debug("Queued {} from {}", events, (Object)plutoPortletWindow);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(request, plutoPortletWindow);
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        List queuedEvents = Lists.transform(events, (Function)new /* Unavailable Anonymous Inner Class!! */);
        requestPortletEventQueue.addEvents((Collection)queuedEvents);
    }

    public void resolvePortletEvents(HttpServletRequest request, PortletEventQueue portletEventQueue) {
        Queue events = portletEventQueue.getUnresolvedEvents();
        if (events.isEmpty()) {
            return;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        LinkedHashSet allLayoutNodeIds = new LinkedHashSet(userLayoutManager.getAllSubscribedChannels());
        LinkedHashMap<String, IPortletEntity> portletEntityCache = new LinkedHashMap<String, IPortletEntity>();
        while (!events.isEmpty()) {
            QueuedEvent queuedEvent = (QueuedEvent)events.poll();
            if (queuedEvent == null) {
                return;
            }
            IPortletWindowId sourceWindowId = queuedEvent.getPortletWindowId();
            Event event = queuedEvent.getEvent();
            boolean globalEvent = this.isGlobalEvent(request, sourceWindowId, event);
            LinkedHashSet portletDefinitions = new LinkedHashSet();
            if (globalEvent) {
                portletDefinitions.addAll(this.portletDefinitionRegistry.getAllPortletDefinitions());
            }
            Iterator layoutNodeIdItr = allLayoutNodeIds.iterator();
            while (layoutNodeIdItr.hasNext()) {
                IPortletDefinition portletDefinition;
                IPortletDefinitionId portletDefinitionId;
                String layoutNodeId = (String)layoutNodeIdItr.next();
                IPortletEntity portletEntity = (IPortletEntity)portletEntityCache.get(layoutNodeId);
                if (portletEntity == null) {
                    portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(request, userInstance, layoutNodeId);
                    if (portletEntity == null) {
                        layoutNodeIdItr.remove();
                        continue;
                    }
                    IPortletDefinitionId portletDefinitionId2 = portletEntity.getPortletDefinitionId();
                    PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinitionId2);
                    if (portletDescriptor == null) {
                        layoutNodeIdItr.remove();
                        continue;
                    }
                    List supportedProcessingEvents = portletDescriptor.getSupportedProcessingEvents();
                    if (supportedProcessingEvents == null || supportedProcessingEvents.size() == 0) {
                        layoutNodeIdItr.remove();
                        continue;
                    }
                    portletEntityCache.put(layoutNodeId, portletEntity);
                }
                if (this.supportsEvent(event, portletDefinitionId = (portletDefinition = portletEntity.getPortletDefinition()).getPortletDefinitionId())) {
                    this.logger.debug("{} supports event {}", (Object)portletDefinition, (Object)event);
                    IPortletEntity defaultPortletEntity = this.portletEntityRegistry.getOrCreateDefaultPortletEntity(request, portletDefinitionId);
                    if (defaultPortletEntity.equals((Object)portletEntity)) {
                        portletDefinitions.remove(portletDefinition);
                    }
                    IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
                    Set portletWindows = this.portletWindowRegistry.getAllPortletWindowsForEntity(request, portletEntityId);
                    for (IPortletWindow portletWindow : portletWindows) {
                        this.logger.debug("{} resolved target {}", (Object)event, (Object)portletWindow);
                        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
                        Event unmarshalledEvent = this.unmarshall(portletWindow, event);
                        portletEventQueue.offerEvent(portletWindowId, new QueuedEvent(sourceWindowId, unmarshalledEvent));
                    }
                    continue;
                }
                portletDefinitions.remove(portletDefinition);
            }
            if (portletDefinitions.isEmpty()) continue;
            IPerson user = userInstance.getPerson();
            EntityIdentifier ei = user.getEntityIdentifier();
            IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
            for (IPortletDefinition portletDefinition : portletDefinitions) {
                IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
                if (!ap.canRender(portletDefinitionId.getStringId()) || !this.supportsEvent(event, portletDefinitionId)) continue;
                this.logger.debug("{} supports event {}", (Object)portletDefinition, (Object)event);
                IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreateDefaultPortletEntity(request, portletDefinitionId);
                IPortletEntityId portletEntityId = portletEntity.getPortletEntityId();
                Set portletWindows = this.portletWindowRegistry.getAllPortletWindowsForEntity(request, portletEntityId);
                for (IPortletWindow portletWindow : portletWindows) {
                    this.logger.debug("{} resolved target {}", (Object)event, (Object)portletWindow);
                    IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
                    Event unmarshalledEvent = this.unmarshall(portletWindow, event);
                    portletEventQueue.offerEvent(portletWindowId, new QueuedEvent(sourceWindowId, unmarshalledEvent));
                }
            }
        }
    }

    protected boolean isGlobalEvent(HttpServletRequest request, IPortletWindowId sourceWindowId, Event event) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, sourceWindowId);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        IPortletDefinitionId portletDefinitionId = portletDefinition.getPortletDefinitionId();
        PortletApplicationDefinition parentPortletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinitionId);
        ContainerRuntimeOption globalEvents = parentPortletApplicationDescriptor.getContainerRuntimeOption(GLOBAL_EVENT__CONTAINER_OPTION);
        if (globalEvents != null) {
            QName qName = event.getQName();
            String qNameStr = qName.toString();
            for (String globalEvent : globalEvents.getValues()) {
                if (!qNameStr.equals(globalEvent)) continue;
                return true;
            }
        }
        return false;
    }

    protected Event unmarshall(IPortletWindow portletWindow, Event event) {
        JAXBElement result;
        Class<Serializable> clazz;
        ClassLoader loader;
        XMLStreamReader xml;
        String value = (String)((Object)event.getValue());
        XMLInputFactory xmlInputFactory = this.xmlUtilities.getXmlInputFactory();
        try {
            xml = xmlInputFactory.createXMLStreamReader(new StringReader(value));
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Failed to create XMLStreamReader for portlet event: " + event, e);
        }
        EventDefinition eventDefinitionDD = this.getEventDefintion(portletWindow, event.getQName());
        PortletDefinition portletDefinition = portletWindow.getPlutoPortletWindow().getPortletDefinition();
        PortletApplicationDefinition application = portletDefinition.getApplication();
        String portletApplicationName = application.getName();
        try {
            loader = this.portletContextService.getClassLoader(portletApplicationName);
        }
        catch (PortletContainerException e) {
            throw new IllegalStateException("Failed to get ClassLoader for portlet application: " + portletApplicationName, e);
        }
        String eventType = eventDefinitionDD.getValueType();
        try {
            clazz = loader.loadClass(eventType).asSubclass(Serializable.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Declared event type '" + eventType + "' cannot be found in portlet application: " + portletApplicationName, e);
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            result = unmarshaller.unmarshal(xml, clazz);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot create JAXBContext for event type '" + eventType + "' from portlet application: " + portletApplicationName, e);
        }
        return new EventImpl(event.getQName(), (Serializable)result.getValue());
    }

    protected EventDefinition getEventDefintion(IPortletWindow portletWindow, QName name) {
        PortletApplicationDefinition appDD = portletWindow.getPlutoPortletWindow().getPortletDefinition().getApplication();
        for (EventDefinition def : appDD.getEventDefinitions()) {
            QName tmp;
            if (!(def.getQName() != null ? def.getQName().equals(name) : (tmp = new QName(appDD.getDefaultNamespace(), def.getName())).equals(name))) continue;
            return def;
        }
        throw new IllegalStateException();
    }

    protected Set<QName> getAllAliases(QName eventName, PortletApplicationDefinition portletApplicationDefinition) {
        List eventDefinitions = portletApplicationDefinition.getEventDefinitions();
        if (eventDefinitions == null || eventDefinitions.isEmpty()) {
            return Collections.emptySet();
        }
        String defaultNamespace = portletApplicationDefinition.getDefaultNamespace();
        for (EventDefinition eventDefinition : eventDefinitions) {
            QName defQName = eventDefinition.getQualifiedName(defaultNamespace);
            if (defQName == null || !defQName.equals(eventName)) continue;
            List aliases = eventDefinition.getAliases();
            if (aliases == null || aliases.isEmpty()) {
                return Collections.emptySet();
            }
            return new LinkedHashSet<QName>(aliases);
        }
        return Collections.emptySet();
    }

    protected boolean supportsEvent(Event event, IPortletDefinitionId portletDefinitionId) {
        Boolean supported;
        QName eventName = event.getQName();
        Tuple key = new Tuple((Object)portletDefinitionId, (Object)eventName);
        Element element = this.supportedEventCache.get((Serializable)key);
        if (element != null && (supported = (Boolean)element.getValue()) != null) {
            return supported;
        }
        PortletApplicationDefinition portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinitionId);
        if (portletApplicationDescriptor == null) {
            return false;
        }
        Set aliases = this.getAllAliases(eventName, portletApplicationDescriptor);
        String defaultNamespace = portletApplicationDescriptor.getDefaultNamespace();
        PortletDefinition portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinitionId);
        if (portletDescriptor == null) {
            return false;
        }
        List supportedProcessingEvents = portletDescriptor.getSupportedProcessingEvents();
        for (EventDefinitionReference eventDefinitionReference : supportedProcessingEvents) {
            QName namespacedName;
            QName qualifiedName = eventDefinitionReference.getQualifiedName(defaultNamespace);
            if (qualifiedName == null) continue;
            if (qualifiedName.equals(eventName) || aliases.contains(qualifiedName)) {
                this.supportedEventCache.put(new Element((Serializable)key, (Serializable)Boolean.TRUE));
                return true;
            }
            if (!StringUtils.isEmpty((String)qualifiedName.getNamespaceURI()) || !eventName.equals(namespacedName = new QName(defaultNamespace, qualifiedName.getLocalPart()))) continue;
            this.supportedEventCache.put(new Element((Serializable)key, (Serializable)Boolean.TRUE));
            return true;
        }
        this.supportedEventCache.put(new Element((Serializable)key, (Serializable)Boolean.FALSE));
        return false;
    }
}

