/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.portlet.CacheControl;
import javax.portlet.Event;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.api.portlet.PortletDelegationLocator;
import org.jasig.portal.events.IPortletExecutionEventFactory;
import org.jasig.portal.portlet.PortletDispatchException;
import org.jasig.portal.portlet.container.cache.CacheControlImpl;
import org.jasig.portal.portlet.container.cache.CacheState;
import org.jasig.portal.portlet.container.cache.CachedPortletData;
import org.jasig.portal.portlet.container.cache.CachedPortletResourceData;
import org.jasig.portal.portlet.container.cache.CachingPortletOutputHandler;
import org.jasig.portal.portlet.container.cache.CachingPortletResourceOutputHandler;
import org.jasig.portal.portlet.container.cache.HeaderSettingCacheControl;
import org.jasig.portal.portlet.container.cache.IPortletCacheControlService;
import org.jasig.portal.portlet.container.cache.PortletCachingHeaderUtils;
import org.jasig.portal.portlet.container.services.AdministrativeRequestListenerController;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.jasig.portal.portlet.rendering.PortletRenderResult;
import org.jasig.portal.portlet.rendering.PortletRendererImpl;
import org.jasig.portal.portlet.rendering.PortletResourceHttpServletResponseWrapper;
import org.jasig.portal.portlet.rendering.PortletResourceOutputHandler;
import org.jasig.portal.portlet.rendering.RenderPortletOutputHandler;
import org.jasig.portal.portlet.rendering.ResourcePortletOutputHandler;
import org.jasig.portal.portlet.session.PortletSessionAdministrativeRequestListener;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.utils.web.PortletHttpServletRequestWrapper;
import org.jasig.portal.utils.web.PortletHttpServletResponseWrapper;
import org.jasig.portal.utils.web.PortletMimeHttpServletResponseWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortletRendererImpl
implements IPortletRenderer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPersonManager personManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private PortletContainer portletContainer;
    private PortletDelegationLocator portletDelegationLocator;
    private IPortletCacheControlService portletCacheControlService;
    private IPortletExecutionEventFactory portalEventFactory;
    private IUrlSyntaxProvider urlSyntaxProvider;

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setPortalEventFactory(IPortletExecutionEventFactory portalEventFactory) {
        this.portalEventFactory = portalEventFactory;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletContainer(PortletContainer portletContainer) {
        this.portletContainer = portletContainer;
    }

    @Autowired
    public void setPortletDelegationLocator(PortletDelegationLocator portletDelegationLocator) {
        this.portletDelegationLocator = portletDelegationLocator;
    }

    @Autowired
    public void setPortletCacheControlService(IPortletCacheControlService portletCacheControlService) {
        this.portletCacheControlService = portletCacheControlService;
    }

    public long doAction(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.portletCacheControlService.purgeCachedPortletData(portletWindowId, httpServletRequest);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        httpServletRequest = this.setupPortletRequest(httpServletRequest);
        httpServletResponse = PortletHttpServletResponseWrapper.create((HttpServletResponse)httpServletResponse, (IPortletWindow)portletWindow);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing portlet action for window '" + portletWindow + "'"));
        }
        long start = System.nanoTime();
        try {
            this.portletContainer.doAction(portletWindow.getPlutoPortletWindow(), httpServletRequest, httpServletResponse);
        }
        catch (PortletException pe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing action.", portletWindow, (Throwable)pe);
        }
        catch (PortletContainerException pce) {
            throw new PortletDispatchException("The portlet container threw an exception while executing action on portlet window '" + portletWindow + "'.", portletWindow, (Throwable)pce);
        }
        catch (IOException ioe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing action.", portletWindow, (Throwable)ioe);
        }
        long executionTime = System.nanoTime() - start;
        this.portalEventFactory.publishPortletActionExecutionEvent(httpServletRequest, (Object)this, portletWindowId, executionTime);
        return executionTime;
    }

    public long doEvent(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Event event) {
        this.portletCacheControlService.purgeCachedPortletData(portletWindowId, httpServletRequest);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        httpServletRequest = this.setupPortletRequest(httpServletRequest);
        httpServletResponse = PortletHttpServletResponseWrapper.create((HttpServletResponse)httpServletResponse, (IPortletWindow)portletWindow);
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing portlet event for window '" + portletWindow + "'"));
        }
        long start = System.nanoTime();
        try {
            this.portletContainer.doEvent(portletWindow.getPlutoPortletWindow(), httpServletRequest, httpServletResponse, event);
        }
        catch (PortletException pe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing event.", portletWindow, (Throwable)pe);
        }
        catch (PortletContainerException pce) {
            throw new PortletDispatchException("The portlet container threw an exception while executing event on portlet window '" + portletWindow + "'.", portletWindow, (Throwable)pce);
        }
        catch (IOException ioe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing event.", portletWindow, (Throwable)ioe);
        }
        long executionTime = System.nanoTime() - start;
        this.portalEventFactory.publishPortletEventExecutionEvent(httpServletRequest, (Object)this, portletWindowId, executionTime, event.getQName());
        return executionTime;
    }

    public PortletRenderResult doRenderHeader(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletOutputHandler portletOutputHandler) throws IOException {
        return this.doRender(portletWindowId, httpServletRequest, httpServletResponse, portletOutputHandler, RenderPart.HEADERS);
    }

    public PortletRenderResult doRenderMarkup(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletOutputHandler portletOutputHandler) throws IOException {
        return this.doRender(portletWindowId, httpServletRequest, httpServletResponse, portletOutputHandler, RenderPart.MARKUP);
    }

    protected PortletRenderResult doRender(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletOutputHandler portletOutputHandler, RenderPart renderPart) throws IOException {
        CachedPortletData cachedPortletData;
        boolean shouldCache;
        CacheState cacheState = renderPart.getCacheState(this.portletCacheControlService, httpServletRequest, portletWindowId);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        if (EXCLUSIVE.equals((Object)portletWindow.getWindowState())) {
            portletOutputHandler = new ResourcePortletOutputHandler(httpServletResponse);
        }
        if (cacheState.isUseCachedData()) {
            return this.doRenderReplayCachedContent(portletWindow, httpServletRequest, cacheState, portletOutputHandler, renderPart, 0L);
        }
        int cacheSizeThreshold = this.portletCacheControlService.getCacheSizeThreshold();
        CachingPortletOutputHandler cachingPortletOutputHandler = new CachingPortletOutputHandler(portletOutputHandler, cacheSizeThreshold);
        CacheControl cacheControl = cacheState.getCacheControl();
        httpServletRequest = this.setupPortletRequest(httpServletRequest);
        httpServletResponse = PortletMimeHttpServletResponseWrapper.create((HttpServletResponse)httpServletResponse, (IPortletWindow)portletWindow, (PortletOutputHandler)portletOutputHandler, (CacheControl)cacheControl);
        httpServletRequest.setAttribute(ATTRIBUTE__PORTLET_CACHE_CONTROL, (Object)cacheControl);
        httpServletRequest.setAttribute(ATTRIBUTE__PORTLET_OUTPUT_HANDLER, (Object)cachingPortletOutputHandler);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering portlet body for window '" + portletWindow + "'"));
        }
        long renderStartTime = System.nanoTime();
        try {
            httpServletRequest.setAttribute("javax.portlet.render_part", (Object)renderPart.getRenderPart());
            this.portletContainer.doRender(portletWindow.getPlutoPortletWindow(), httpServletRequest, httpServletResponse);
        }
        catch (PortletException pe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing renderMarkup.", portletWindow, (Throwable)pe);
        }
        catch (PortletContainerException pce) {
            throw new PortletDispatchException("The portlet container threw an exception while executing renderMarkup on portlet window '" + portletWindow + "'.", portletWindow, (Throwable)pce);
        }
        catch (IOException ioe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing renderMarkup.", portletWindow, (Throwable)ioe);
        }
        long executionTime = System.nanoTime() - renderStartTime;
        boolean useCachedContent = cacheControl.useCachedContent();
        if (useCachedContent) {
            CachedPortletData cachedPortletData2 = (CachedPortletData)cacheState.getCachedPortletData();
            if (cachedPortletData2 == null) {
                throw new PortletDispatchException("The portlet window '" + portletWindow + "' indicated via CacheControl#useCachedContent " + "that the portal should render cached content, however there is no cached content to return. " + "This is a portlet bug.", portletWindow);
            }
            cachedPortletData2.updateExpirationTime(cacheControl.getExpirationTime());
            renderPart.cachePortletOutput(this.portletCacheControlService, portletWindowId, httpServletRequest, cacheState, cachedPortletData2);
            return this.doRenderReplayCachedContent(portletWindow, httpServletRequest, cacheState, portletOutputHandler, renderPart, executionTime);
        }
        this.publishRenderEvent(portletWindow, httpServletRequest, renderPart, executionTime, false);
        PortletRenderResult portletRenderResult = this.constructPortletRenderResult(httpServletRequest, executionTime);
        if (cacheState != null && (shouldCache = this.portletCacheControlService.shouldOutputBeCached(cacheControl)) && (cachedPortletData = cachingPortletOutputHandler.getCachedPortletData((Serializable)portletRenderResult, cacheControl)) != null) {
            renderPart.cachePortletOutput(this.portletCacheControlService, portletWindowId, httpServletRequest, cacheState, cachedPortletData);
        }
        return portletRenderResult;
    }

    protected PortletRenderResult doRenderReplayCachedContent(IPortletWindow portletWindow, HttpServletRequest httpServletRequest, CacheState<CachedPortletData<PortletRenderResult>, PortletRenderResult> cacheState, PortletOutputHandler portletOutputHandler, RenderPart renderPart, long baseExecutionTime) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Replaying cached content for Render " + renderPart + " request to " + portletWindow));
        }
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        long renderStartTime = System.nanoTime();
        CachedPortletData cachedPortletData = (CachedPortletData)cacheState.getCachedPortletData();
        cachedPortletData.replay(portletOutputHandler);
        long executionTime = baseExecutionTime + (System.nanoTime() - renderStartTime);
        this.publishRenderEvent(portletWindow, httpServletRequest, renderPart, executionTime, true);
        PortletRenderResult portletResult = (PortletRenderResult)cachedPortletData.getPortletResult();
        return new PortletRenderResult(portletResult, executionTime);
    }

    protected void publishRenderEvent(IPortletWindow portletWindow, HttpServletRequest httpServletRequest, RenderPart renderPart, long executionTime, boolean cached) {
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(httpServletRequest);
        boolean targeted = portletWindowId.equals(portalRequestInfo.getTargetedPortletWindowId());
        renderPart.publishRenderExecutionEvent(this.portalEventFactory, this, httpServletRequest, portletWindowId, executionTime, targeted, cached);
    }

    protected PortletRenderResult constructPortletRenderResult(HttpServletRequest httpServletRequest, long renderTime) {
        String title = (String)httpServletRequest.getAttribute(IPortletRenderer.ATTRIBUTE__PORTLET_TITLE);
        String newItemCountString = (String)httpServletRequest.getAttribute(IPortletRenderer.ATTRIBUTE__PORTLET_NEW_ITEM_COUNT);
        int newItemCount = newItemCountString != null && StringUtils.isNumeric((String)newItemCountString) ? Integer.parseInt(newItemCountString) : 0;
        String link = (String)httpServletRequest.getAttribute(IPortletRenderer.ATTRIBUTE__PORTLET_LINK);
        return new PortletRenderResult(title, link, newItemCount, renderTime);
    }

    public long doServeResource(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PortletResourceOutputHandler portletOutputHandler) throws IOException {
        CachedPortletResourceData cachedPortletResourceData;
        boolean shouldCache;
        CacheState cacheState = this.portletCacheControlService.getPortletResourceState(httpServletRequest, portletWindowId);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        if (cacheState.isUseBrowserData()) {
            return this.doResourceReplayBrowserContent(portletWindow, httpServletRequest, cacheState, portletOutputHandler);
        }
        if (cacheState.isUseCachedData()) {
            return this.doResourceReplayCachedContent(portletWindow, httpServletRequest, cacheState, portletOutputHandler, 0L);
        }
        int cacheSizeThreshold = this.portletCacheControlService.getCacheSizeThreshold();
        CachingPortletResourceOutputHandler cachingPortletOutputHandler = new CachingPortletResourceOutputHandler(portletOutputHandler, cacheSizeThreshold);
        CacheControl cacheControl = cacheState.getCacheControl();
        cacheControl = new HeaderSettingCacheControl(cacheControl, (PortletResourceOutputHandler)cachingPortletOutputHandler);
        httpServletRequest = this.setupPortletRequest(httpServletRequest);
        httpServletResponse = PortletResourceHttpServletResponseWrapper.create((HttpServletResponse)httpServletResponse, (IPortletWindow)portletWindow, (PortletResourceOutputHandler)portletOutputHandler, (CacheControl)cacheControl);
        httpServletRequest.setAttribute(ATTRIBUTE__PORTLET_CACHE_CONTROL, (Object)cacheControl);
        httpServletRequest.setAttribute(ATTRIBUTE__PORTLET_OUTPUT_HANDLER, (Object)cachingPortletOutputHandler);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing resource request for window '" + portletWindow + "'"));
        }
        long start = System.nanoTime();
        try {
            this.portletContainer.doServeResource(portletWindow.getPlutoPortletWindow(), httpServletRequest, httpServletResponse);
        }
        catch (PortletException pe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing serveResource.", portletWindow, (Throwable)pe);
        }
        catch (PortletContainerException pce) {
            throw new PortletDispatchException("The portlet container threw an exception while executing serveResource on portlet window '" + portletWindow + "'.", portletWindow, (Throwable)pce);
        }
        catch (IOException ioe) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing serveResource.", portletWindow, (Throwable)ioe);
        }
        long executionTime = System.nanoTime() - start;
        boolean useCachedContent = cacheControl.useCachedContent();
        if (useCachedContent) {
            CachedPortletResourceData cachedPortletResourceData2 = (CachedPortletResourceData)cacheState.getCachedPortletData();
            if (cachedPortletResourceData2 != null) {
                CachedPortletData cachedPortletData = cachedPortletResourceData2.getCachedPortletData();
                cachedPortletData.updateExpirationTime(cacheControl.getExpirationTime());
                this.portletCacheControlService.cachePortletResourceOutput(portletWindowId, httpServletRequest, cacheState, cachedPortletResourceData2);
            }
            if (cacheState.isBrowserSetEtag()) {
                return this.doResourceReplayBrowserContent(portletWindow, httpServletRequest, cacheState, portletOutputHandler);
            }
            return this.doResourceReplayCachedContent(portletWindow, httpServletRequest, cacheState, (PortletResourceOutputHandler)cachingPortletOutputHandler, executionTime);
        }
        this.publishResourceEvent(portletWindow, httpServletRequest, executionTime, false, false);
        if (cacheState != null && (shouldCache = this.portletCacheControlService.shouldOutputBeCached(cacheControl)) && (cachedPortletResourceData = cachingPortletOutputHandler.getCachedPortletResourceData((Serializable)Long.valueOf(executionTime), cacheControl)) != null) {
            this.portletCacheControlService.cachePortletResourceOutput(portletWindowId, httpServletRequest, cacheState, cachedPortletResourceData);
        }
        return executionTime;
    }

    protected long doResourceReplayBrowserContent(IPortletWindow portletWindow, HttpServletRequest httpServletRequest, CacheState<CachedPortletResourceData<Long>, Long> cacheState, PortletResourceOutputHandler portletOutputHandler) {
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending 304 for resource request to " + portletWindow));
        }
        if (portletOutputHandler.isCommitted()) {
            throw new IllegalStateException("Attempting to send 304 but response is already committed");
        }
        long start = System.nanoTime();
        portletOutputHandler.setStatus(304);
        CachedPortletResourceData cachedPortletResourceData = (CachedPortletResourceData)cacheState.getCachedPortletData();
        if (cachedPortletResourceData != null) {
            CachedPortletData cachedPortletData = cachedPortletResourceData.getCachedPortletData();
            PortletCachingHeaderUtils.setCachingHeaders((CachedPortletData)cachedPortletData, (PortletResourceOutputHandler)portletOutputHandler);
        }
        long executionTime = System.nanoTime() - start;
        this.publishResourceEvent(portletWindow, httpServletRequest, executionTime, true, false);
        return executionTime;
    }

    protected Long doResourceReplayCachedContent(IPortletWindow portletWindow, HttpServletRequest httpServletRequest, CacheState<CachedPortletResourceData<Long>, Long> cacheState, PortletResourceOutputHandler portletOutputHandler, long baseExecutionTime) throws IOException {
        this.enforceConfigPermission(httpServletRequest, portletWindow);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Replaying cached content for resource request to " + portletWindow));
        }
        long renderStartTime = System.nanoTime();
        CachedPortletResourceData cachedPortletResourceData = (CachedPortletResourceData)cacheState.getCachedPortletData();
        if (cachedPortletResourceData == null) {
            throw new PortletDispatchException("The portlet window '" + portletWindow + "' indicated via CacheControl#useCachedContent " + "that the portal should render cached content, however there is no cached content to return. " + "This is a portlet bug.", portletWindow);
        }
        cachedPortletResourceData.replay(portletOutputHandler);
        long executionTime = baseExecutionTime + (System.nanoTime() - renderStartTime);
        this.publishResourceEvent(portletWindow, httpServletRequest, executionTime, false, true);
        return executionTime;
    }

    protected void publishResourceEvent(IPortletWindow portletWindow, HttpServletRequest httpServletRequest, long executionTime, boolean usedBrowserCache, boolean usedPortalCache) {
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        this.portalEventFactory.publishPortletResourceExecutionEvent(httpServletRequest, (Object)this, portletWindowId, executionTime, usedBrowserCache, usedPortalCache);
    }

    public void doReset(IPortletWindowId portletWindowId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpServletRequest, portletWindowId);
        if (portletWindow != null) {
            portletWindow.setPortletMode(PortletMode.VIEW);
            portletWindow.setRenderParameters((Map)new ParameterMap());
            portletWindow.setExpirationCache(null);
            httpServletRequest = this.setupPortletRequest(httpServletRequest);
            httpServletResponse = PortletHttpServletResponseWrapper.create((HttpServletResponse)httpServletResponse, (IPortletWindow)portletWindow);
            httpServletRequest.setAttribute(AdministrativeRequestListenerController.DEFAULT_LISTENER_KEY_ATTRIBUTE, (Object)"sessionActionListener");
            httpServletRequest.setAttribute("org.jasig.portal.portlet.session.ACTION", (Object)PortletSessionAdministrativeRequestListener.SessionAction.CLEAR);
            httpServletRequest.setAttribute("org.jasig.portal.portlet.session.SCOPE", (Object)2);
            String characterEncoding = httpServletResponse.getCharacterEncoding();
            httpServletRequest.setAttribute(ATTRIBUTE__PORTLET_OUTPUT_HANDLER, (Object)new RenderPortletOutputHandler(characterEncoding));
            httpServletRequest.setAttribute(ATTRIBUTE__PORTLET_CACHE_CONTROL, (Object)new CacheControlImpl());
            try {
                this.portletContainer.doAdmin(portletWindow.getPlutoPortletWindow(), httpServletRequest, httpServletResponse);
            }
            catch (PortletException pe) {
                throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing admin command to clear session.", portletWindow, (Throwable)pe);
            }
            catch (PortletContainerException pce) {
                throw new PortletDispatchException("The portlet container threw an exception while executing admin command to clear session on portlet window '" + portletWindow + "'.", portletWindow, (Throwable)pce);
            }
            catch (IOException ioe) {
                throw new PortletDispatchException("The portlet window '" + portletWindow + "' threw an exception while executing admin command to clear session.", portletWindow, (Throwable)ioe);
            }
        } else {
            this.logger.debug((Object)("ignoring doReset as portletWindowRegistry#getPortletWindow returned a null result for portletWindowId " + portletWindowId));
        }
    }

    protected HttpServletRequest setupPortletRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest portletHttpServletRequestWrapper = PortletHttpServletRequestWrapper.create((HttpServletRequest)httpServletRequest);
        portletHttpServletRequestWrapper.setAttribute(PortletDelegationLocator.PORTLET_DELECATION_LOCATOR_ATTR, (Object)this.portletDelegationLocator);
        return portletHttpServletRequestWrapper;
    }

    protected void enforceConfigPermission(HttpServletRequest httpServletRequest, IPortletWindow portletWindow) {
        Validate.notNull((Object)httpServletRequest, (String)"Servlet request must not be null to determine a remote user.");
        Validate.notNull((Object)portletWindow, (String)"Portlet window must not be null to determine its mode.");
        PortletMode portletMode = portletWindow.getPortletMode();
        if (portletMode != null && IPortletRenderer.CONFIG.equals((Object)portletMode)) {
            IPortletEntity portletEntity;
            IPortletDefinition portletDefinition;
            IPerson person = this.personManager.getPerson(httpServletRequest);
            EntityIdentifier ei = person.getEntityIdentifier();
            AuthorizationService authorizationService = AuthorizationService.instance();
            IAuthorizationPrincipal ap = authorizationService.newPrincipal(ei.getKey(), ei.getType());
            if (!ap.canConfigure((portletDefinition = (portletEntity = portletWindow.getPortletEntity()).getPortletDefinition()).getPortletDefinitionId().getStringId())) {
                this.logger.error((Object)("User " + person + " attempted to use portlet " + portletDefinition.getFName() + " in " + portletMode + " mode " + "but lacks permission to use that mode.  " + "THIS MAY BE AN ATTEMPT TO EXPLOIT A HISTORICAL SECURITY FLAW.  " + "YOU SHOULD PROBABLY FIGURE OUT WHO THIS USER IS AND" + " WHY THEY ARE TRYING TO ACCESS UNAUTHORIZED MODES ILLICITLY.  NAUGHTY!"));
                throw new AuthorizationException(person.getUserName() + " does not have permission to use '" + portletDefinition.getFName() + "' in " + portletMode + " PortletMode");
            }
        }
    }
}

