/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.worker.GuardingHttpServletRequest;
import org.jasig.portal.portlet.rendering.worker.GuardingHttpServletResponse;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionInterceptor;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.PortletExecutionCallable;
import org.jasig.portal.portlet.rendering.worker.PortletExecutionWorker;

abstract class PortletExecutionWorker<V>
implements IPortletExecutionWorker<V> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, Object> executionAttributes = new ConcurrentHashMap();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final ExecutorService executorService;
    private final List<IPortletExecutionInterceptor> interceptors;
    final IPortletRenderer portletRenderer;
    final IPortletWindowId portletWindowId;
    final String portletFname;
    final long timeout;
    final HttpServletRequest request;
    final HttpServletResponse response;
    private volatile Future<V> future;
    private volatile Thread workerThread;
    private volatile long submitted = 0L;
    private volatile long started = 0L;
    private volatile long complete = 0L;
    private final AtomicInteger cancelCount = new AtomicInteger();
    private final AtomicBoolean canceled = new AtomicBoolean();
    private volatile boolean retrieved = false;

    public PortletExecutionWorker(ExecutorService executorService, List<IPortletExecutionInterceptor> interceptors, IPortletRenderer portletRenderer, HttpServletRequest request, HttpServletResponse response, IPortletWindow portletWindow, long timeout) {
        this.executorService = executorService;
        this.interceptors = interceptors;
        this.portletRenderer = portletRenderer;
        this.request = new GuardingHttpServletRequest(request, this.canceled);
        this.response = new GuardingHttpServletResponse(response, this.canceled);
        this.portletWindowId = portletWindow.getPortletWindowId();
        this.portletFname = portletWindow.getPortletEntity().getPortletDefinition().getFName();
        this.timeout = timeout;
    }

    public Object setExecutionAttribute(String name, Object value) {
        if (value == null) {
            return this.executionAttributes.remove(name);
        }
        return this.executionAttributes.put(name, value);
    }

    public Object getExecutionAttribute(String name) {
        return this.executionAttributes.get(name);
    }

    public IPortletWindowId getPortletWindowId() {
        return this.portletWindowId;
    }

    public String getPortletFname() {
        return this.portletFname;
    }

    public long getApplicableTimeout() {
        return this.timeout;
    }

    public final void submit() {
        if (this.submitted > 0L) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " for " + this.getPortletWindowId() + " has already been submitted.");
        }
        this.submitted = System.currentTimeMillis();
        try {
            for (IPortletExecutionInterceptor interceptor : this.interceptors) {
                interceptor.preSubmit(this.request, this.response, (IPortletExecutionContext)this);
            }
            PortletExecutionCallable callable = new PortletExecutionCallable((IPortletExecutionContext)this, (Callable)new ExecutionLifecycleCallable(this, (Callable)new /* Unavailable Anonymous Inner Class!! */));
            this.future = this.executorService.submit(callable);
        }
        catch (Exception e) {
            ExecutionLifecycleCallable callable = new ExecutionLifecycleCallable(this, (Callable)new /* Unavailable Anonymous Inner Class!! */);
            try {
                this.future = (Future)callable.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startExecution() {
        this.workerThread = Thread.currentThread();
        this.started = System.currentTimeMillis();
        this.startLatch.countDown();
    }

    private void runPreExecutionInterceptors() {
        for (IPortletExecutionInterceptor interceptor : this.interceptors) {
            interceptor.preExecution(this.request, this.response, (IPortletExecutionContext)this);
        }
    }

    private void executionComplete() {
        this.complete = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Execution complete on portlet " + this.portletWindowId + " in " + this.getDuration() + "ms"));
        }
        this.workerThread = null;
    }

    private void doPostExecution(Exception e) {
        ListIterator listIterator = this.interceptors.listIterator(this.interceptors.size());
        while (listIterator.hasPrevious()) {
            IPortletExecutionInterceptor interceptor = (IPortletExecutionInterceptor)listIterator.previous();
            try {
                interceptor.postExecution(this.request, this.response, (IPortletExecutionContext)this, e);
            }
            catch (Throwable ex2) {
                this.logger.error((Object)"HandlerInterceptor.postExecution threw exception", ex2);
            }
        }
    }

    protected abstract V callInternal() throws Exception;

    public final boolean isStarted() {
        return this.started > 0L;
    }

    public boolean isSubmitted() {
        return this.submitted > 0L;
    }

    public boolean isComplete() {
        return this.complete > 0L || this.workerThread == null || this.workerThread.getState() == Thread.State.TERMINATED;
    }

    public boolean isRetrieved() {
        return this.retrieved;
    }

    public final long waitForStart(long timeout) throws InterruptedException {
        this.startLatch.await(timeout, TimeUnit.MILLISECONDS);
        return this.started;
    }

    public V get(long timeout) throws Exception {
        if (this.future == null) {
            throw new IllegalStateException("submit() must be called before get(long) can be called");
        }
        this.retrieved = true;
        try {
            long startTime = this.waitForStart(timeout);
            long waitTime = Math.max(0L, timeout - (System.currentTimeMillis() - startTime));
            return this.future.get(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)("Execution interrupted on portlet window " + this.portletWindowId), (Throwable)e);
            throw e;
        }
        catch (ExecutionException e) {
            this.logger.warn((Object)("Execution failed on portlet window " + this.portletWindowId), (Throwable)e);
            throw e;
        }
        catch (TimeoutException e) {
            StringBuilder errorBuilder = new StringBuilder("Execution timed out on portlet window ");
            errorBuilder.append(this.portletWindowId);
            Thread localWorkerThread = this.workerThread;
            if (localWorkerThread != null) {
                Thread.State state = localWorkerThread.getState();
                StackTraceElement[] stackTrace = localWorkerThread.getStackTrace();
                errorBuilder.append("\n\tPortlet Thread State: ").append((Object)state).append("\n");
                errorBuilder.append("\tPortlet Thread Stack Trace: \n");
                for (StackTraceElement stackTraceElement : stackTrace) {
                    errorBuilder.append("\t\tat ").append(stackTraceElement).append("\n");
                }
                errorBuilder.append("Portal Stack Trace:");
            }
            this.logger.warn((Object)errorBuilder, (Throwable)e);
            throw e;
        }
    }

    public final void cancel() {
        Thread thread;
        if (this.future == null) {
            throw new IllegalStateException("submit() must be called before cancel() can be called");
        }
        if (this.isComplete()) {
            return;
        }
        this.retrieved = true;
        this.canceled.set(true);
        this.future.cancel(true);
        int count = this.cancelCount.getAndIncrement();
        if (count > 0 && (thread = this.workerThread) != null) {
            thread.interrupt();
        }
    }

    public final int getCancelCount() {
        return this.cancelCount.get();
    }

    public final long getSubmittedTime() {
        return this.submitted;
    }

    public final long getStartedTime() {
        return this.started;
    }

    public final long getCompleteTime() {
        return this.complete;
    }

    public final long getWait() {
        return this.started - this.submitted;
    }

    public final long getDuration() {
        return this.complete - this.started;
    }

    public String toString() {
        return "PortletExecutionWorker [portletFname=" + this.portletFname + ", " + "timeout=" + this.timeout + ", " + "portletWindowId=" + this.portletWindowId + ", " + "started=" + this.started + ", " + "submitted=" + this.submitted + ", " + "complete=" + this.complete + ", " + "retrieved=" + this.retrieved + ", " + "canceled=" + this.canceled + ", " + "cancelCount=" + this.cancelCount + ", " + "wait=" + this.getWait() + ", " + "duration=" + this.getDuration() + "]";
    }

    static /* synthetic */ void access$000(PortletExecutionWorker x0) {
        x0.startExecution();
    }

    static /* synthetic */ void access$100(PortletExecutionWorker x0) {
        x0.runPreExecutionInterceptors();
    }

    static /* synthetic */ void access$200(PortletExecutionWorker x0, Exception x1) {
        x0.doPostExecution(x1);
    }

    static /* synthetic */ void access$300(PortletExecutionWorker x0) {
        x0.executionComplete();
    }
}

