/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.worker.IPortletActionExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletEventExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionInterceptor;
import org.jasig.portal.portlet.rendering.worker.IPortletFailureExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletRenderExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletResourceExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.IPortletWorkerFactory;
import org.jasig.portal.portlet.rendering.worker.PortletActionExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.PortletEventExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.PortletFailureExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.PortletRenderExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.PortletRenderHeaderExecutionWorker;
import org.jasig.portal.portlet.rendering.worker.PortletResourceExecutionWorker;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PortletWorkerFactoryImpl
implements IPortletWorkerFactory {
    public static final String DEFAULT_ERROR_PORTLET_FNAME = "error";
    private ExecutorService portletThreadPool;
    private IPortletRenderer portletRenderer;
    private List<IPortletExecutionInterceptor> executionInterceptors;
    private String errorPortletFName = "error";
    private IUserInstanceManager userInstanceManager;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletWindowRegistry portletWindowRegistry;

    public void setErrorPortletFName(String errorPortletFName) {
        this.errorPortletFName = errorPortletFName;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletThreadPool(@Qualifier(value="portletThreadPool") ExecutorService portletThreadPool) {
        this.portletThreadPool = portletThreadPool;
    }

    @Autowired
    public void setPortletRenderer(IPortletRenderer portletRenderer) {
        this.portletRenderer = portletRenderer;
    }

    @Resource(name="portletExecutionInterceptors")
    public void setExecutionInterceptors(List<IPortletExecutionInterceptor> executionInterceptors) {
        this.executionInterceptors = executionInterceptors;
    }

    public IPortletActionExecutionWorker createActionWorker(HttpServletRequest request, HttpServletResponse response, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        return new PortletActionExecutionWorker(this.portletThreadPool, this.executionInterceptors, this.portletRenderer, request, response, portletWindow);
    }

    public IPortletEventExecutionWorker createEventWorker(HttpServletRequest request, HttpServletResponse response, IPortletWindowId portletWindowId, Event event) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        return new PortletEventExecutionWorker(this.portletThreadPool, this.executionInterceptors, this.portletRenderer, request, response, portletWindow, event);
    }

    public IPortletRenderExecutionWorker createRenderHeaderWorker(HttpServletRequest request, HttpServletResponse response, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        return new PortletRenderHeaderExecutionWorker(this.portletThreadPool, this.executionInterceptors, this.portletRenderer, request, response, portletWindow);
    }

    public IPortletRenderExecutionWorker createRenderWorker(HttpServletRequest request, HttpServletResponse response, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        return new PortletRenderExecutionWorker(this.portletThreadPool, this.executionInterceptors, this.portletRenderer, request, response, portletWindow);
    }

    public IPortletResourceExecutionWorker createResourceWorker(HttpServletRequest request, HttpServletResponse response, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        return new PortletResourceExecutionWorker(this.portletThreadPool, this.executionInterceptors, this.portletRenderer, request, response, portletWindow);
    }

    public IPortletFailureExecutionWorker createFailureWorker(HttpServletRequest request, HttpServletResponse response, IPortletWindowId failedPortletWindowId, Exception cause) {
        IPortletWindowId errorPortletWindowId = this.getErrorPortletWindowId(request, this.errorPortletFName);
        return new PortletFailureExecutionWorker(this.portletRenderer, this.executionInterceptors, request, response, errorPortletWindowId, failedPortletWindowId, this.errorPortletFName, cause);
    }

    protected IPortletWindowId getErrorPortletWindowId(HttpServletRequest request, String fname) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IPortletEntity errorPortletEntity = this.portletEntityRegistry.getOrCreatePortletEntityByFname(request, userInstance, fname);
        IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindow(request, errorPortletEntity.getPortletEntityId());
        return portletWindow.getPortletWindowId();
    }

    protected String getPortletFname(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        return portletDefinition.getFName();
    }
}

