/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.rendering.worker;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.worker.IPortletExecutionContext;
import org.jasig.portal.portlet.rendering.worker.PortletExecutionInterceptorAdaptor;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ThreadNamingPortletExecutionInterceptorAdaptor")
public class ThreadNamingPortletExecutionInterceptorAdaptor
extends PortletExecutionInterceptorAdaptor {
    private static final String THREAD_NAME = ThreadNamingPortletExecutionInterceptorAdaptor.class.getName() + ".THREAD_NAME";
    private IPortletWindowRegistry portletWindowRegistry;
    private IPersonManager personManager;

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public void preExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context) {
        IPortletWindowId portletWindowId = context.getPortletWindowId();
        String fname = this.getFname(request, portletWindowId);
        String userName = this.getUserName(request);
        Thread currentThread = Thread.currentThread();
        String threadName = currentThread.getName();
        context.setExecutionAttribute(THREAD_NAME, (Object)threadName);
        IPortletExecutionContext.ExecutionType executionType = context.getExecutionType();
        currentThread.setName(threadName + "-" + userName + "-" + executionType + "-[" + fname + "]");
    }

    public void postExecution(HttpServletRequest request, HttpServletResponse response, IPortletExecutionContext context, Exception e) {
        String threadName = (String)context.getExecutionAttribute(THREAD_NAME);
        Thread currentThread = Thread.currentThread();
        currentThread.setName(threadName);
    }

    protected String getFname(HttpServletRequest request, IPortletWindowId portletWindowId) {
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        if (portletWindow == null) {
            this.logger.warn("Failed to resolve IPortletWindow for id: " + portletWindowId + ", the id will be used instead of the fname");
            return portletWindowId.toString();
        }
        IPortletEntity portletEntity = portletWindow.getPortletEntity();
        IPortletDefinition portletDefinition = portletEntity.getPortletDefinition();
        return portletDefinition.getFName();
    }

    protected String getUserName(HttpServletRequest request) {
        IPerson person = this.personManager.getPerson(request);
        if (person == null) {
            return null;
        }
        return person.getUserName();
    }
}

