/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.session;

import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.PortletSessionImpl;
import org.jasig.portal.portlet.om.IPortletEntityId;

public class ScopingPortletSessionImpl
extends PortletSessionImpl {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final IPortletEntityId portletEntityId;

    public ScopingPortletSessionImpl(IPortletEntityId portletEntityId, PortletContext portletContext, PortletWindow portletWindow, HttpSession httpSession) {
        super(portletContext, portletWindow, httpSession);
        this.portletEntityId = portletEntityId;
    }

    protected String createPortletScopedId(String name) {
        return "javax.portlet.p." + this.portletEntityId.getStringId() + '?' + name;
    }

    protected boolean isInCurrentPortletScope(String name) {
        if (name.startsWith("javax.portlet.p.") && name.indexOf(63) > -1) {
            String id = name.substring("javax.portlet.p.".length(), name.indexOf(63));
            return id.equals(this.portletEntityId.getStringId());
        }
        return false;
    }

    public void setAttribute(String name, Object value) {
        this.checkForExceptionAttribute(name, value);
        super.setAttribute(name, value);
    }

    public void setAttribute(String name, Object value, int scope) {
        this.checkForExceptionAttribute(name, value);
        super.setAttribute(name, value, scope);
    }

    private void checkForExceptionAttribute(String name, Object value) throws Error {
        if ("org.springframework.web.portlet.DispatcherPortlet.ACTION_EXCEPTION".equals(name)) {
            if (value instanceof RuntimeException) {
                throw (RuntimeException)value;
            }
            if (value instanceof Error) {
                throw (Error)value;
            }
            if (value instanceof Throwable) {
                throw new RuntimeException((Throwable)value);
            }
        }
    }
}

