/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.url;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.pluto.container.PortletURLProvider;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.UrlType;

public class PortletURLProviderImpl
implements PortletURLProvider {
    private final IPortletUrlBuilder portletUrlBuilder;

    public PortletURLProviderImpl(IPortletUrlBuilder portletUrlBuilder) {
        this.portletUrlBuilder = portletUrlBuilder;
    }

    public String getCacheability() {
        return this.portletUrlBuilder.getCacheability();
    }

    public PortletMode getPortletMode() {
        return this.portletUrlBuilder.getPortletMode();
    }

    public Map<String, List<String>> getProperties() {
        return Collections.emptyMap();
    }

    public Map<String, String[]> getPublicRenderParameters() {
        return Collections.emptyMap();
    }

    public Map<String, String[]> getRenderParameters() {
        return this.portletUrlBuilder.getParameters();
    }

    public String getResourceID() {
        return this.portletUrlBuilder.getResourceId();
    }

    public PortletURLProvider.TYPE getType() {
        IPortalUrlBuilder portalUrlBuilder = this.portletUrlBuilder.getPortalUrlBuilder();
        UrlType urlType = portalUrlBuilder.getUrlType();
        return urlType.getPortletUrlType();
    }

    public WindowState getWindowState() {
        return this.portletUrlBuilder.getWindowState();
    }

    public boolean isSecure() {
        return false;
    }

    public void setCacheability(String cacheability) {
        this.portletUrlBuilder.setCacheability(cacheability);
    }

    public void setPortletMode(PortletMode mode) {
        this.portletUrlBuilder.setPortletMode(mode);
    }

    public void setResourceID(String resourceId) {
        this.portletUrlBuilder.setResourceId(resourceId);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
    }

    public void setWindowState(WindowState state) {
        this.portletUrlBuilder.setWindowState(state);
    }

    public String toURL() {
        IPortalUrlBuilder portalUrlBuilder = this.portletUrlBuilder.getPortalUrlBuilder();
        return portalUrlBuilder.getUrlString();
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        String url = this.toURL();
        if (escapeXML) {
            StringEscapeUtils.escapeXml((Writer)out, (String)url);
        } else {
            out.write(url);
        }
    }
}

