/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.account.selfedit;

import org.apache.commons.lang.StringUtils;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.portlets.account.selfedit.AccountPasswordForm;
import org.jasig.portal.security.IPortalPasswordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.stereotype.Component;

@Component(value="accountPasswordFormValidator")
public class AccountPasswordFormValidator {
    private ILocalAccountDao accountDao;
    private IPortalPasswordService passwordService;

    @Autowired(required=true)
    public void setLocalAccountDao(ILocalAccountDao accountDao) {
        this.accountDao = accountDao;
    }

    @Autowired(required=true)
    public void setPortalPasswordService(IPortalPasswordService passwordService) {
        this.passwordService = passwordService;
    }

    public void validateEnterPassword(AccountPasswordForm form, MessageContext context) {
        if (StringUtils.isBlank((String)form.getCurrentPassword())) {
            context.addMessage(new MessageBuilder().error().source((Object)"currentPassword").code("please.enter.current.password").defaultText("Please enter your current password").build());
        } else {
            ILocalAccountPerson account = this.accountDao.getPerson(form.getUserId());
            if (!this.passwordService.validatePassword(form.getCurrentPassword(), account.getPassword())) {
                context.addMessage(new MessageBuilder().error().source((Object)"currentPassword").code("current.password.doesnt.match").defaultText("Provided password does not match the current account password").build());
            }
        }
        if (StringUtils.isBlank((String)form.getNewPassword())) {
            context.addMessage(new MessageBuilder().error().source((Object)"newPassword").code("please.enter.new.password").defaultText("Please enter a new password").build());
        }
        if (StringUtils.isBlank((String)form.getConfirmNewPassword())) {
            context.addMessage(new MessageBuilder().error().source((Object)"confirmNewPassword").code("please.enter.confirm.password").defaultText("Please confirm your new password").build());
        }
        if (StringUtils.isNotBlank((String)form.getNewPassword()) && StringUtils.isNotBlank((String)form.getConfirmNewPassword()) && !form.getNewPassword().equals(form.getConfirmNewPassword())) {
            context.addMessage(new MessageBuilder().error().source((Object)"confirmPassword").code("passwords.must.match").defaultText("Passwords must match").build());
        }
    }
}

