/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.backgroundpreference;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.jasig.portal.portlets.backgroundpreference.BackgroundSetSelectionStrategy;
import org.jasig.portal.portlets.backgroundpreference.RoleBasedBackgroundSetSelectionStrategy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewBackgroundPreferenceController {
    BackgroundSetSelectionStrategy imageSetSelectionStrategy = new RoleBasedBackgroundSetSelectionStrategy();

    public void setImageSetSelectionStrategy(BackgroundSetSelectionStrategy imageSetSelectionStrategy) {
        this.imageSetSelectionStrategy = imageSetSelectionStrategy;
    }

    @RenderMapping
    public String getView(RenderRequest req, Model model) {
        String[] images = this.imageSetSelectionStrategy.getImageSet((PortletRequest)req);
        model.addAttribute("images", (Object)images);
        String[] thumbnailImages = this.imageSetSelectionStrategy.getImageThumbnailSet((PortletRequest)req);
        model.addAttribute("thumbnailImages", (Object)thumbnailImages);
        String preferredBackgroundImage = this.imageSetSelectionStrategy.getSelectedImage((PortletRequest)req);
        model.addAttribute("backgroundImage", (Object)preferredBackgroundImage);
        String backgroundContainerSelector = this.imageSetSelectionStrategy.getBackgroundContainerSelector((PortletRequest)req);
        model.addAttribute("backgroundContainerSelector", (Object)backgroundContainerSelector);
        PortletPreferences prefs = req.getPreferences();
        model.addAttribute("applyOpacityTo", (Object)prefs.getValue("applyOpacityTo", null));
        model.addAttribute("opacityCssValue", (Object)prefs.getValue("opacityCssValue", "1.0"));
        return "/jsp/BackgroundPreference/viewBackgroundPreference";
    }

    @ActionMapping(params={"action=savePreferences"})
    public void savePreferences(ActionRequest req, ActionResponse res, @RequestParam(required=false) String backgroundImage) throws Exception {
        this.imageSetSelectionStrategy.setSelectedImage(req, backgroundImage);
        res.sendRedirect(req.getContextPath() + "/api" + "/ajax-success");
    }
}

