/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class PortletErrorController {
    public static final String REQUEST_ATTRIBUTE__CURRENT_FAILED_PORTLET_WINDOW_ID = PortletErrorController.class.getName() + ".CURRENT_FAILED_PORTLET_WINDOW_ID";
    public static final String REQUEST_ATTRIBUTE__CURRENT_EXCEPTION_CAUSE = PortletErrorController.class.getName() + ".CURRENT_EXCEPTION_CAUSE";
    protected static final String ERROR_OWNER = "UP_ERROR_CHAN";
    protected static final String ERROR_ACTIVITY = "VIEW";
    protected static final String ERROR_TARGET = "DETAILS";
    private IUserInstanceManager userInstanceManager;
    private IPortalRequestUtils portalRequestUtils;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletRenderer portletRenderer;
    private IPortalUrlProvider portalUrlProvider;

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortletRenderer(IPortletRenderer portletRenderer) {
        this.portletRenderer = portletRenderer;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider portalUrlProvider) {
        this.portalUrlProvider = portalUrlProvider;
    }

    @RequestMapping(value={"VIEW"})
    public String renderError(RenderRequest request, RenderResponse response, ModelMap model) throws Exception {
        HttpServletRequest httpRequest = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)request);
        IPortletWindowId currentFailedPortletWindowId = (IPortletWindowId)request.getAttribute(REQUEST_ATTRIBUTE__CURRENT_FAILED_PORTLET_WINDOW_ID);
        model.addAttribute("portletWindowId", (Object)currentFailedPortletWindowId);
        Exception cause = (Exception)request.getAttribute(REQUEST_ATTRIBUTE__CURRENT_EXCEPTION_CAUSE);
        model.addAttribute("exception", (Object)cause);
        String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)cause);
        model.addAttribute("rootCauseMessage", (Object)rootCauseMessage);
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(httpRequest);
        if (this.hasAdminPrivileges(userInstance)) {
            IPortletWindow window = this.portletWindowRegistry.getPortletWindow(httpRequest, currentFailedPortletWindowId);
            window.setRenderParameters((Map)new ParameterMap());
            IPortalUrlBuilder adminRetryUrl = this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(httpRequest, currentFailedPortletWindowId, UrlType.RENDER);
            model.addAttribute("adminRetryUrl", (Object)adminRetryUrl.getUrlString());
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(httpRequest, currentFailedPortletWindowId);
            IPortletEntity parentPortletEntity = portletWindow.getPortletEntity();
            IPortletDefinition parentPortletDefinition = parentPortletEntity.getPortletDefinition();
            model.addAttribute("channelDefinition", (Object)parentPortletDefinition);
            StringWriter stackTraceWriter = new StringWriter();
            cause.printStackTrace(new PrintWriter(stackTraceWriter));
            model.addAttribute("stackTrace", (Object)stackTraceWriter.toString());
            return "/jsp/PortletError/detailed";
        }
        return "/jsp/PortletError/generic";
    }

    @RequestMapping(value={"VIEW"})
    public void executeReset(ActionRequest request, ActionResponse response) throws Exception {
        String windowId = request.getParameter("failedPortletWindowId");
        if (StringUtils.isNotBlank((String)windowId)) {
            HttpServletRequest httpRequest = this.portalRequestUtils.getPortletHttpRequest((PortletRequest)request);
            IPortletWindowId portletWindowId = this.portletWindowRegistry.getPortletWindowId(httpRequest, windowId);
            HttpServletResponse httpResponse = this.portalRequestUtils.getOriginalPortalResponse((PortletRequest)request);
            this.portletRenderer.doReset(portletWindowId, httpRequest, httpResponse);
            IPortalUrlBuilder builder = this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(httpRequest, portletWindowId, UrlType.RENDER);
            response.sendRedirect(builder.getUrlString());
        }
    }

    protected boolean hasAdminPrivileges(IUserInstance userInstance) {
        EntityIdentifier ei = userInstance.getPerson().getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission(ERROR_OWNER, ERROR_ACTIVITY, ERROR_TARGET);
    }
}

