/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.googleanalytics;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ResourceRequest;
import javax.portlet.ValidatorException;
import org.jasig.portal.portlets.PortletPreferencesJsonDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class GoogleAnalyticsConfigController {
    public static final String CONFIG_PREF_NAME = "config";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletPreferencesJsonDao portletPreferencesJsonDao;

    @Autowired
    public void setPortletPreferencesJsonDao(PortletPreferencesJsonDao portletPreferencesJsonDao) {
        this.portletPreferencesJsonDao = portletPreferencesJsonDao;
    }

    @RenderMapping
    public String renderAnalyticsHeader(PortletRequest request, ModelMap model) throws IOException {
        PortletPreferences preferences = request.getPreferences();
        JsonNode config = this.portletPreferencesJsonDao.getJsonNode(preferences, CONFIG_PREF_NAME);
        model.put((Object)"data", (Object)config);
        return "jsp/GoogleAnalytics/config";
    }

    @ResourceMapping(value="getData")
    public String getData(PortletRequest portletRequest, ModelMap model) throws IOException {
        PortletPreferences preferences = portletRequest.getPreferences();
        JsonNode config = this.portletPreferencesJsonDao.getJsonNode(preferences, CONFIG_PREF_NAME);
        model.put((Object)"data", (Object)config);
        return "jsonView";
    }

    @ResourceMapping(value="storeData")
    public String storeData(ResourceRequest request, @RequestParam JsonNode config) throws ValidatorException, IOException, ReadOnlyException {
        PortletPreferences preferences = request.getPreferences();
        this.portletPreferencesJsonDao.storeJson(preferences, CONFIG_PREF_NAME, (Object)config);
        return "jsonView";
    }

    @ActionMapping(value="configDone")
    public void configComplete(ActionResponse response) throws PortletModeException {
        response.setPortletMode(PortletMode.VIEW);
    }
}

