/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.googleanalytics;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.portlets.PortletPreferencesJsonDao;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class GoogleAnalyticsController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletPreferencesJsonDao portletPreferencesJsonDao;

    @Autowired
    public void setPortletPreferencesJsonDao(PortletPreferencesJsonDao portletPreferencesJsonDao) {
        this.portletPreferencesJsonDao = portletPreferencesJsonDao;
    }

    @RenderMapping
    public String renderAnalyticsHeader(RenderRequest request, ModelMap model) throws IOException {
        String remoteUser = request.getRemoteUser();
        IGroupMember groupMember = GroupService.getGroupMember((String)remoteUser, IPerson.class);
        HashMap isMemberCache = new HashMap();
        PortletPreferences preferences = request.getPreferences();
        JsonNode config = this.portletPreferencesJsonDao.getJsonNode(preferences, "config");
        JsonNode propertyConfig = config.get("defaultConfig");
        this.filterAnalyticsGroups(groupMember, propertyConfig, isMemberCache);
        JsonNode hosts = config.get("hosts");
        if (hosts != null) {
            Iterator hostsItr = hosts.elements();
            while (hostsItr.hasNext()) {
                JsonNode institution = (JsonNode)hostsItr.next();
                this.filterAnalyticsGroups(groupMember, institution, isMemberCache);
            }
        }
        model.put((Object)"data", (Object)config);
        if (propertyConfig == null || propertyConfig.get("propertyId") == null) {
            return "jsp/GoogleAnalytics/noop";
        }
        return "jsp/GoogleAnalytics/init";
    }

    protected void filterAnalyticsGroups(IGroupMember groupMember, JsonNode config, Map<String, Boolean> isMemberCache) {
        if (config == null) {
            return;
        }
        JsonNode dimensionGroups = config.get("dimensionGroups");
        if (dimensionGroups == null) {
            return;
        }
        Iterator groupItr = dimensionGroups.elements();
        while (groupItr.hasNext()) {
            JsonNode group = (JsonNode)groupItr.next();
            JsonNode valueNode = group.get("value");
            if (valueNode == null) continue;
            String groupName = valueNode.asText();
            Boolean isMember = isMemberCache.get(groupName);
            if (isMember == null) {
                isMember = this.isMember(groupMember, groupName);
                isMemberCache.put(groupName, isMember);
            }
            if (isMember.booleanValue()) continue;
            groupItr.remove();
        }
    }

    protected boolean isMember(IGroupMember groupMember, String groupName) {
        try {
            IEntityGroup group = GroupService.findGroup((String)groupName);
            if (group != null) {
                return groupMember.isDeepMemberOf((IGroupMember)group);
            }
            EntityIdentifier[] results = GroupService.searchForGroups((String)groupName, (int)1, IPerson.class);
            if (results == null || results.length == 0) {
                this.logger.warn("No portal group found for '{}' no users will be placed in that group for analytics", (Object)groupName);
                return false;
            }
            if (results.length > 1) {
                this.logger.warn("{} groups were found for groupName '{}'. The first result will be used.", (Object)results.length, (Object)groupName);
            }
            group = GroupService.getGroupMember((EntityIdentifier)results[0]);
            return groupMember.isDeepMemberOf((IGroupMember)group);
        }
        catch (Exception e) {
            this.logger.warn("Failed to determine if {} is a member of {}, returning false", new Object[]{groupMember, groupName, e});
            return false;
        }
    }
}

