/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.localization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.PortalException;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.portlets.localization.LocaleBean;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserLocaleHelper {
    private IUserInstanceManager userInstanceManager;
    private IPortalRequestUtils portalRequestUtils;
    private ILocaleStore localeStore;

    @Autowired
    public void setLocaleStore(ILocaleStore localeStore) {
        this.localeStore = localeStore;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public List<LocaleBean> getLocales(Locale currentLocale) {
        Locale[] portalLocales;
        ArrayList<LocaleBean> locales = new ArrayList<LocaleBean>();
        for (Locale locale : portalLocales = this.getPortalLocales()) {
            if (currentLocale != null) {
                locales.add(new LocaleBean(locale, currentLocale));
                continue;
            }
            locales.add(new LocaleBean(locale));
        }
        return locales;
    }

    public Locale getCurrentUserLocale(PortletRequest request) {
        HttpServletRequest originalPortalRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        IUserInstance ui = this.userInstanceManager.getUserInstance(originalPortalRequest);
        IUserPreferencesManager upm = ui.getPreferencesManager();
        IUserProfile userProfile = upm.getUserProfile();
        LocaleManager localeManager = userProfile.getLocaleManager();
        Locale[] sessionLocales = localeManager.getSessionLocales();
        if (sessionLocales != null && sessionLocales.length > 0) {
            return sessionLocales[0];
        }
        Locale[] userLocales = localeManager.getUserLocales();
        if (userLocales != null && userLocales.length > 0) {
            return userLocales[0];
        }
        return null;
    }

    public void updateUserLocale(HttpServletRequest request, String localeString) {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager upm = ui.getPreferencesManager();
        IUserProfile userProfile = upm.getUserProfile();
        LocaleManager localeManager = userProfile.getLocaleManager();
        if (localeString != null) {
            Locale userLocale = this.parseLocale(localeString);
            Locale[] locales = new Locale[]{userLocale};
            localeManager.setSessionLocales(locales);
            IPerson person = ui.getPerson();
            if (!person.isGuest()) {
                try {
                    localeManager.persistUserLocales(new Locale[]{userLocale});
                    this.localeStore.updateUserLocales(person, new Locale[]{userLocale});
                    person.setAttribute("RDBMDistributedLayoutStore.PLF", null);
                    upm.getUserLayoutManager().loadUserLayout(true);
                }
                catch (Exception e) {
                    throw new PortalException((Throwable)e);
                }
            }
        }
    }

    protected Locale[] getPortalLocales() {
        return LocaleManager.getPortalLocales();
    }

    protected Locale parseLocale(String localeString) {
        return LocaleManager.parseLocale((String)localeString);
    }
}

