/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.login;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;

@Service
public class LoginPortletHelper {
    private IUserInstanceManager userInstanceManager;
    private IPortalRequestUtils portalRequestUtils;
    private Map<String, String> mappings = Collections.emptyMap();

    @Autowired(required=true)
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        Validate.notNull((Object)userInstanceManager);
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired(required=true)
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    @Required
    @Resource(name="profileKeyMappings")
    public void setProfileMappings(Map<String, String> mappings) {
        Validate.notNull(mappings);
        this.mappings = mappings;
    }

    public String getSelectedProfile(PortletRequest request) {
        PortletSession session = request.getPortletSession();
        String profileName = (String)session.getAttribute("profileKey", 1);
        if (profileName == null) {
            HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
            IUserInstance ui = this.userInstanceManager.getUserInstance(httpServletRequest);
            IUserProfile profile = ui.getPreferencesManager().getUserProfile();
            for (Map.Entry entry : this.mappings.entrySet()) {
                if (!((String)entry.getValue()).equals(profile.getProfileFname())) continue;
                profileName = (String)entry.getKey();
                break;
            }
        }
        return profileName;
    }
}

