/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.lookup;

import java.util.Map;
import java.util.Set;
import org.jasig.portal.portlets.lookup.IPersonLookupHelper;
import org.jasig.portal.portlets.lookup.PersonQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class PersonQueryValidator {
    private IPersonLookupHelper personLookupHelper;

    public IPersonLookupHelper getPersonLookupHelper() {
        return this.personLookupHelper;
    }

    @Autowired
    public void setPersonLookupHelper(IPersonLookupHelper personLookupHelper) {
        this.personLookupHelper = personLookupHelper;
    }

    public void validatePersonLookup(PersonQuery personQuery, MessageContext context) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        ExternalContext externalContext = requestContext.getExternalContext();
        Set queryAttributes = this.personLookupHelper.getQueryAttributes(externalContext);
        Map attributes = personQuery.getAttributes();
        for (String attribute : attributes.keySet()) {
            if (queryAttributes.contains(attribute)) continue;
            MessageBuilder messageBuilder = new MessageBuilder();
            messageBuilder.error();
            messageBuilder.source((Object)("attributes[" + attribute + "].value"));
            messageBuilder.code("personLookup.invalidQueryAttribute");
            messageBuilder.arg((Object)attribute);
            MessageResolver errorMessage = messageBuilder.build();
            context.addMessage(errorMessage);
        }
    }
}

