/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.permissionsadmin;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlets.permissionsadmin.Assignment;

public class Assignment
implements Comparable<Assignment>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String principalId;
    private final JsonEntityBean principal;
    private Type type;
    private final Set<Assignment> children = new TreeSet();

    public Assignment(String principalId, JsonEntityBean principal) {
        this(principalId, principal, Type.INHERIT_DENY);
    }

    public Assignment(String principalId, JsonEntityBean principal, Type type) {
        if (principal == null) {
            String msg = "Argument 'principal' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (type == null) {
            String msg = "Argument 'type' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        this.principalId = principalId;
        this.principal = principal;
        this.type = type;
    }

    public Assignment addChild(Assignment a) {
        if (a == null) {
            String msg = "Argument 'a' [Assignment] cannot be null";
            throw new IllegalArgumentException(msg);
        }
        this.children.add(a);
        return this;
    }

    @Override
    public int compareTo(Assignment a) {
        return this.principal.getName().compareTo(a.principal.getName());
    }

    public Set<Assignment> getChildren() {
        return new TreeSet<Assignment>(this.children);
    }

    public JsonEntityBean getPrincipal() {
        return this.principal;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Assignment findDecendentOrSelfIfExists(JsonEntityBean principal) {
        if (principal == null) {
            String msg = "Argument 'principal' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        Assignment rslt = null;
        if (principal.getId().equals(this.principal.getId()) && principal.getEntityTypeAsString().equals(this.principal.getEntityTypeAsString())) {
            rslt = this;
        } else {
            Assignment a;
            Iterator i$ = this.children.iterator();
            while (i$.hasNext() && (rslt = (a = (Assignment)i$.next()).findDecendentOrSelfIfExists(principal)) == null) {
            }
        }
        return rslt;
    }

    public String getPrincipalId() {
        return this.principalId;
    }
}

