/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.permissionsadmin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.permission.IPermissionActivity;
import org.jasig.portal.permission.IPermissionOwner;
import org.jasig.portal.portlets.permissionsadmin.IPermissionAdministrationHelper;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionAdministrationHelper
implements IPermissionAdministrationHelper {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IGroupListHelper groupListHelper;
    private IPermissionStore permissionStore;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    @Autowired(required=true)
    public void setPermissionStore(IPermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    public boolean canEditOwner(IPerson currentUser, String owner) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_PERMISSIONS", "EDIT_PERMISSIONS", "ALL");
    }

    public boolean canViewOwner(IPerson currentUser, String owner) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_PERMISSIONS", "VIEW_PERMISSIONS", "ALL");
    }

    public boolean canEditActivity(IPerson currentUser, String activity) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_PERMISSIONS", "EDIT_PERMISSIONS", "ALL");
    }

    public boolean canViewActivity(IPerson currentUser, String activity) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_PERMISSIONS", "VIEW_PERMISSIONS", "ALL");
    }

    public boolean canEditPermission(IPerson currentUser, String target) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_PERMISSIONS", "EDIT_PERMISSIONS", "ALL");
    }

    public boolean canViewPermission(IPerson currentUser, String target) {
        EntityIdentifier ei = currentUser.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        return ap.hasPermission("UP_PERMISSIONS", "VIEW_PERMISSIONS", "ALL");
    }

    public Set<JsonEntityBean> getEntitiesForPrincipals(Collection<String> principals) {
        HashSet<JsonEntityBean> entities = new HashSet<JsonEntityBean>();
        for (String principal : principals) {
            JsonEntityBean entity = this.groupListHelper.getEntityForPrincipal(principal);
            entities.add(entity);
        }
        return entities;
    }

    public Set<String> getPrincipalsForEntities(Collection<JsonEntityBean> entities) {
        HashSet<String> principals = new HashSet<String>();
        for (JsonEntityBean entity : entities) {
            principals.add(entity.getPrincipalString());
        }
        return principals;
    }

    public Set<String> getCurrentPrincipals(IPermissionOwner owner, IPermissionActivity activity, String targetKey) {
        IPermission[] permissions = this.permissionStore.select(owner.getFname(), null, activity.getFname(), targetKey, null);
        HashSet<String> principals = new HashSet<String>();
        for (IPermission p : permissions) {
            principals.add(p.getPrincipal());
        }
        return principals;
    }
}

