/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.popular;

import com.google.visualization.datasource.base.TypeMismatchException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregation;
import org.jasig.portal.events.aggr.portletlayout.PortletLayoutAggregationDao;
import org.jasig.portal.events.aggr.portlets.AggregatedPortletMapping;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlets.popular.PortletUsage;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.url.IPortalRequestUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class PopularPortletsController {
    public static final AggregationInterval AGGREGATION_INTERVAL = AggregationInterval.DAY;
    private IPersonManager personManager;
    private IPortalRequestUtils portalRequestUtils;
    private PortletLayoutAggregationDao<PortletLayoutAggregation> portletLayoutDao;
    private AggregatedGroupLookupDao aggregatedGroupLookupDao;
    private IPortletDefinitionDao portletDefinitionDao;

    @Autowired
    public void setPortletDefinitionDao(IPortletDefinitionDao portletDefinitionDao) {
        this.portletDefinitionDao = portletDefinitionDao;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setAggregatedGroupLookupDao(AggregatedGroupLookupDao aggregatedGroupLookupDao) {
        this.aggregatedGroupLookupDao = aggregatedGroupLookupDao;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    @Autowired
    public void setPortletLayoutDao(PortletLayoutAggregationDao<PortletLayoutAggregation> portletLayoutDao) {
        this.portletLayoutDao = portletLayoutDao;
    }

    @RenderMapping
    public String getReportList() throws TypeMismatchException {
        return "jsp/PopularPortlets/listPortlets";
    }

    @ResourceMapping(value="popularPortletCounts")
    public ModelAndView getEventCounts(PortletRequest req, @RequestParam(value="days", required=false) Integer days) {
        HashMap<String, List> model = new HashMap<String, List>();
        List counts = this.getCounts(req, days);
        model.put("counts", counts);
        return new ModelAndView("jsonView", model);
    }

    private final List<PortletUsage> getCounts(PortletRequest portletRequest, Integer days) {
        HttpServletRequest servletRequest = this.portalRequestUtils.getPortletHttpRequest(portletRequest);
        IPerson user = this.personManager.getPerson(servletRequest);
        List resultList = this.buildEventCounts(days, user, portletRequest.getLocale());
        return resultList;
    }

    private List<PortletUsage> buildEventCounts(Integer days, IPerson user, Locale locale) {
        DateTime end = new DateTime();
        DateTime begin = end.minusDays(days.intValue());
        IEntityGroup everyone = GroupService.getRootGroup(IPerson.class);
        AggregatedGroupMapping group = this.aggregatedGroupLookupDao.getGroupMapping(everyone.getKey());
        List aggregations = this.portletLayoutDao.getAggregationsForAllPortlets(begin, end, AGGREGATION_INTERVAL, group, new AggregatedGroupMapping[0]);
        EntityIdentifier ei = user.getEntityIdentifier();
        AuthorizationService authService = AuthorizationService.instance();
        IAuthorizationPrincipal ap = authService.newPrincipal(ei.getKey(), ei.getType());
        HashMap<String, PortletUsage> resultBuilder = new HashMap<String, PortletUsage>();
        for (PortletLayoutAggregation aggregation : aggregations) {
            AggregatedPortletMapping portlet = aggregation.getPortletMapping();
            String fname = portlet.getFname();
            PortletUsage portletUsage = (PortletUsage)resultBuilder.get(fname);
            if (portletUsage == null) {
                IPortletDefinition portletDefinition = this.portletDefinitionDao.getPortletDefinitionByFname(fname);
                if (portletDefinition == null || !ap.canSubscribe(portletDefinition.getPortletDefinitionId().getStringId())) continue;
                portletUsage = new PortletUsage(portletDefinition.getPortletDefinitionId().getLongId(), fname, portletDefinition.getTitle(locale.toString()), portletDefinition.getDescription(locale.toString()));
                resultBuilder.put(fname, portletUsage);
            }
            portletUsage.incrementCount(aggregation.getAddCount());
        }
        ArrayList<PortletUsage> results = new ArrayList<PortletUsage>(resultBuilder.values());
        Collections.sort(results);
        return results;
    }
}

