/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PortalDriverContainerServices;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Supports;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.api.portlet.DelegateState;
import org.jasig.portal.api.portlet.DelegationActionResponse;
import org.jasig.portal.api.portlet.PortletDelegationDispatcher;
import org.jasig.portal.api.portlet.PortletDelegationLocator;
import org.jasig.portal.channel.IPortletPublishingService;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.om.PortletCategory;
import org.jasig.portal.portlet.om.PortletLifecycleState;
import org.jasig.portal.portlet.registry.IPortletCategoryRegistry;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletTypeRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portletpublishing.xml.MultiValuedPreferenceInputType;
import org.jasig.portal.portletpublishing.xml.Parameter;
import org.jasig.portal.portletpublishing.xml.ParameterInputType;
import org.jasig.portal.portletpublishing.xml.PortletPublishingDefinition;
import org.jasig.portal.portletpublishing.xml.Preference;
import org.jasig.portal.portletpublishing.xml.PreferenceInputType;
import org.jasig.portal.portletpublishing.xml.SingleValuedPreferenceInputType;
import org.jasig.portal.portletpublishing.xml.Step;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.BooleanAttribute;
import org.jasig.portal.portlets.StringListAttribute;
import org.jasig.portal.portlets.groupselector.EntityEnum;
import org.jasig.portal.portlets.portletadmin.PortletAdministrationHelper;
import org.jasig.portal.portlets.portletadmin.PortletDefinitionForm;
import org.jasig.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.xml.PortletDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.springframework.webflow.context.ExternalContext;

@Service
public class PortletAdministrationHelper
implements ServletContextAware {
    protected final Log logger = LogFactory.getLog(PortletAdministrationHelper.class);
    private IGroupListHelper groupListHelper;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletCategoryRegistry portletCategoryRegistry;
    private IPortletTypeRegistry portletTypeRegistry;
    private PortalDriverContainerServices portalDriverContainerServices;
    private IPortletPublishingService portletPublishingService;
    private PortletDelegationLocator portletDelegationLocator;
    private IChannelPublishingDefinitionDao portletPublishingDefinitionDao;
    private ServletContext servletContext;
    private static final Pattern PARAM_PATTERN = Pattern.compile("^([^\\[]+)\\['([^\\']+)'\\]\\.value$");

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Autowired
    public void setPortletDelegationLocator(PortletDelegationLocator portletDelegationLocator) {
        this.portletDelegationLocator = portletDelegationLocator;
    }

    @Autowired
    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortletCategoryRegistry(IPortletCategoryRegistry portletCategoryRegistry) {
        this.portletCategoryRegistry = portletCategoryRegistry;
    }

    @Autowired
    public void setPortletTypeRegistry(IPortletTypeRegistry portletTypeRegistry) {
        this.portletTypeRegistry = portletTypeRegistry;
    }

    @Autowired
    public void setPortalDriverContainerServices(PortalDriverContainerServices portalDriverContainerServices) {
        this.portalDriverContainerServices = portalDriverContainerServices;
    }

    @Autowired
    public void setPortletPublishingService(IPortletPublishingService portletPublishingService) {
        this.portletPublishingService = portletPublishingService;
    }

    @Autowired
    public void setPortletChannelPublishingDefinitionDao(IChannelPublishingDefinitionDao portletPublishingDefinitionDao) {
        this.portletPublishingDefinitionDao = portletPublishingDefinitionDao;
    }

    public PortletDefinitionForm getPortletDefinitionForm(IPerson person, String portletId) {
        PortletDefinitionForm form;
        IPortletDefinition def = this.portletDefinitionRegistry.getPortletDefinition(portletId);
        if (def != null) {
            form = new PortletDefinitionForm(def);
            form.setId(def.getPortletDefinitionId().getStringId());
        } else {
            form = new PortletDefinitionForm();
        }
        if (def != null) {
            Set categories = this.portletCategoryRegistry.getParentCategories(def);
            for (PortletCategory cat : categories) {
                form.addCategory(new JsonEntityBean(cat));
            }
            try {
                IPermissionManager pm = AuthorizationService.instance().newPermissionManager("UP_PORTLET_SUBSCRIBE");
                IAuthorizationPrincipal[] prins = pm.getAuthorizedPrincipals("SUBSCRIBE", "PORTLET_ID." + String.valueOf(form.getId()));
                for (int mp = 0; mp < prins.length; ++mp) {
                    JsonEntityBean bean;
                    IEntityGroup group = GroupService.findGroup((String)prins[mp].getKey());
                    if (group != null) {
                        bean = new JsonEntityBean(group, EntityEnum.GROUP);
                    } else {
                        IGroupMember member = AuthorizationService.instance().getGroupMember(prins[mp]);
                        bean = new JsonEntityBean(member, EntityEnum.PERSON);
                        String name = this.groupListHelper.lookupEntityName(bean);
                        bean.setName(name);
                    }
                    form.addGroup(bean);
                }
            }
            catch (GroupsException e) {
                e.printStackTrace();
            }
        } else {
            IEntityGroup portletCategoriesGroup = GroupService.getDistinguishedGroup((String)GroupService.PORTLET_CATEGORIES);
            form.addCategory(new JsonEntityBean(portletCategoriesGroup, this.groupListHelper.getEntityType((IGroupMember)portletCategoriesGroup)));
            IEntityGroup everyoneGroup = GroupService.getDistinguishedGroup((String)GroupService.EVERYONE);
            form.addGroup(new JsonEntityBean(everyoneGroup, this.groupListHelper.getEntityType((IGroupMember)everyoneGroup)));
        }
        if (!this.hasLifecyclePermission(person, PortletLifecycleState.CREATED, form.getCategories())) {
            this.logger.warn((Object)("User '" + person.getUserName() + "' attempted to edit the following portlet without MANAGE permission:  " + def));
            throw new SecurityException("Not Authorized");
        }
        return form;
    }

    public PortletDefinitionForm savePortletRegistration(IPerson publisher, PortletDefinitionForm form) throws Exception {
        IPortletType portletType;
        if (!this.hasLifecyclePermission(publisher, form.getLifecycleState(), form.getCategories())) {
            this.logger.warn((Object)("User '" + publisher.getUserName() + "' attempted to save the following portlet without the selected MANAGE permission:  " + form));
            throw new SecurityException("Not Authorized");
        }
        if (form.getId() != null && !form.getId().equals("-1")) {
            IPortletDefinition def = this.portletDefinitionRegistry.getPortletDefinition(form.getId());
            Set categories = this.portletCategoryRegistry.getParentCategories(def);
            ArrayList<JsonEntityBean> categoryBeans = new ArrayList<JsonEntityBean>();
            for (PortletCategory cat : categories) {
                categoryBeans.add(new JsonEntityBean(cat));
            }
            if (!this.hasLifecyclePermission(publisher, def.getLifecycleState(), categoryBeans)) {
                this.logger.warn((Object)("User '" + publisher.getUserName() + "' attempted to save the following portlet without the previous MANAGE permission:  " + form));
                throw new SecurityException("Not Authorized");
            }
        }
        IGroupMember[] groupMembers = new IGroupMember[form.getGroups().size()];
        for (int i = 0; i < groupMembers.length; ++i) {
            JsonEntityBean bean = (JsonEntityBean)form.getGroups().get(i);
            EntityEnum entityEnum = EntityEnum.getEntityEnum((String)bean.getEntityTypeAsString());
            groupMembers[i] = entityEnum.isGroup() ? GroupService.findGroup((String)bean.getId()) : GroupService.getGroupMember((String)bean.getId(), (Class)entityEnum.getClazz());
        }
        PortletCategory[] categories = new PortletCategory[form.getCategories().size()];
        ListIterator iter = form.getCategories().listIterator();
        while (iter.hasNext()) {
            String id = ((JsonEntityBean)iter.next()).getId();
            String iCatID = id.startsWith("cat") ? id.substring(3) : id;
            categories[iter.previousIndex()] = this.portletCategoryRegistry.getPortletCategory(iCatID);
        }
        IPortletDefinition portletDef = null;
        if (form.getId() == null) {
            String fname = form.getFname();
            String name = form.getName();
            String title = form.getTitle();
            String applicationId = form.getApplicationId();
            String portletName = form.getPortletName();
            boolean isFramework = form.isFramework();
            IPortletType type = this.portletTypeRegistry.getPortletType(form.getTypeId());
            portletDef = this.portletDefinitionRegistry.createPortletDefinition(type, fname, name, title, applicationId, portletName, isFramework);
        } else {
            portletDef = this.portletDefinitionRegistry.getPortletDefinition(form.getId());
        }
        portletDef.setDescription(form.getDescription());
        portletDef.setFName(form.getFname());
        portletDef.setName(form.getName());
        portletDef.setTimeout(form.getTimeout());
        portletDef.setTitle(form.getTitle());
        portletDef.getPortletDescriptorKey().setWebAppName(form.getApplicationId());
        portletDef.getPortletDescriptorKey().setPortletName(form.getPortletName());
        portletDef.getPortletDescriptorKey().setFrameworkPortlet(form.isFramework());
        Date now = new Date();
        int order = form.getLifecycleState().getOrder();
        if (form.getId() == null) {
            if (order >= PortletLifecycleState.APPROVED.getOrder()) {
                portletDef.setApproverId(publisher.getID());
                portletDef.setApprovalDate(now);
            }
            if (order >= PortletLifecycleState.PUBLISHED.getOrder()) {
                portletDef.setPublisherId(publisher.getID());
                if (portletDef.getPublishDate() == null) {
                    portletDef.setPublishDate(now);
                }
            } else if (form.getPublishDate() != null) {
                portletDef.setPublishDate(form.getPublishDateTime());
                portletDef.setPublisherId(publisher.getID());
            }
            if (order >= PortletLifecycleState.EXPIRED.getOrder()) {
                portletDef.setExpirerId(publisher.getID());
                if (portletDef.getExpirationDate() == null) {
                    portletDef.setExpirationDate(now);
                }
            } else if (form.getExpirationDate() != null) {
                portletDef.setExpirationDate(form.getExpirationDateTime());
                portletDef.setExpirerId(publisher.getID());
            }
        } else {
            if (order >= PortletLifecycleState.APPROVED.getOrder()) {
                if (portletDef.getApproverId() < 0) {
                    portletDef.setApproverId(publisher.getID());
                }
                if (portletDef.getApprovalDate() == null) {
                    portletDef.setApprovalDate(now);
                }
            } else {
                portletDef.setApprovalDate(null);
                portletDef.setApproverId(-1);
            }
            if (order >= PortletLifecycleState.PUBLISHED.getOrder()) {
                if (portletDef.getPublisherId() < 0) {
                    portletDef.setPublisherId(publisher.getID());
                }
                if (portletDef.getPublishDate() == null) {
                    portletDef.setPublishDate(now);
                }
            } else if (form.getPublishDate() != null) {
                portletDef.setPublishDate(form.getPublishDate());
                if (portletDef.getPublisherId() < 0) {
                    portletDef.setPublisherId(publisher.getID());
                }
            } else {
                portletDef.setPublishDate(null);
                portletDef.setPublisherId(-1);
            }
            if (order >= PortletLifecycleState.EXPIRED.getOrder()) {
                if (portletDef.getExpirerId() < 0) {
                    portletDef.setExpirerId(publisher.getID());
                }
                if (portletDef.getExpirationDate() == null) {
                    portletDef.setExpirationDate(now);
                }
            } else if (form.getExpirationDate() != null) {
                portletDef.setExpirationDate(form.getExpirationDate());
                if (portletDef.getExpirerId() < 0) {
                    portletDef.setExpirerId(publisher.getID());
                }
            } else {
                portletDef.setExpirationDate(null);
                portletDef.setExpirerId(-1);
            }
        }
        if ((portletType = this.portletTypeRegistry.getPortletType(form.getTypeId())) == null) {
            throw new IllegalArgumentException("No IPortletType exists for ID " + form.getTypeId());
        }
        portletDef.setType(portletType);
        ArrayList<PortletPreferenceImpl> preferenceList = new ArrayList<PortletPreferenceImpl>();
        for (String key : form.getParameters().keySet()) {
            String value = ((Attribute)form.getParameters().get(key)).getValue();
            if (StringUtils.isBlank((String)value)) continue;
            portletDef.addParameter(key, value);
        }
        portletDef.addParameter("editable", Boolean.toString(form.isEditable()));
        portletDef.addParameter("hasHelp", Boolean.toString(form.isHasHelp()));
        portletDef.addParameter("hasAbout", Boolean.toString(form.isHasAbout()));
        for (String key : form.getPortletPreferences().keySet()) {
            List prefValues = ((StringListAttribute)form.getPortletPreferences().get(key)).getValue();
            if (prefValues == null || prefValues.size() <= 0) continue;
            String[] values = prefValues.toArray(new String[prefValues.size()]);
            BooleanAttribute readOnly = (BooleanAttribute)form.getPortletPreferenceReadOnly().get(key);
            preferenceList.add(new PortletPreferenceImpl(key, readOnly.getValue(), values));
        }
        portletDef.setPortletPreferences(preferenceList);
        this.portletPublishingService.savePortletDefinition(portletDef, publisher, Arrays.asList(categories), Arrays.asList(groupMembers));
        return this.getPortletDefinitionForm(publisher, portletDef.getPortletDefinitionId().getStringId());
    }

    public void removePortletRegistration(IPerson person, PortletDefinitionForm form) {
        if (!this.hasLifecyclePermission(person, form.getLifecycleState(), form.getCategories())) {
            this.logger.warn((Object)("User '" + person.getUserName() + "' attempted to remove portlet '" + form.getFname() + "' without the proper MANAGE permission"));
            throw new SecurityException("Not Authorized");
        }
        IPortletDefinition def = this.portletDefinitionRegistry.getPortletDefinition(form.getId());
        this.portletDefinitionRegistry.deletePortletDefinition(def);
    }

    public Set<String> getArbitraryPortletPreferenceNames(PortletDefinitionForm form) {
        PortletPublishingDefinition cpd = this.portletPublishingDefinitionDao.getChannelPublishingDefinition(form.getTypeId());
        HashSet<String> currentPrefs = new HashSet<String>();
        currentPrefs.addAll(form.getPortletPreferences().keySet());
        for (Step step : cpd.getSteps()) {
            if (step.getPreferences() == null) continue;
            for (Preference pref : step.getPreferences()) {
                currentPrefs.remove(pref.getName());
            }
        }
        return currentPrefs;
    }

    public boolean supportsConfigMode(PortletDefinitionForm form) {
        PortletDefinition portletDescriptor;
        Tuple portletDescriptorKeys = this.getPortletDescriptorKeys(form);
        if (portletDescriptorKeys == null) {
            return false;
        }
        String portletAppId = (String)portletDescriptorKeys.first;
        String portletName = (String)portletDescriptorKeys.second;
        PortletRegistryService portletRegistryService = this.portalDriverContainerServices.getPortletRegistryService();
        try {
            portletDescriptor = portletRegistryService.getPortlet(portletAppId, portletName);
        }
        catch (PortletContainerException e) {
            this.logger.warn((Object)("Failed to load portlet descriptor for appId='" + portletAppId + "', portletName='" + portletName + "'"), (Throwable)e);
            return false;
        }
        if (portletDescriptor == null) {
            return false;
        }
        List supports = portletDescriptor.getSupports();
        for (Supports support : supports) {
            List portletModes = support.getPortletModes();
            for (String portletMode : portletModes) {
                if (!IPortletRenderer.CONFIG.equals((Object)PortletUtils.getPortletMode((String)portletMode))) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanOptions(PortletDefinitionForm form, PortletRequest request) {
        HashSet<String> preferenceNames = new HashSet<String>();
        HashSet<String> parameterNames = new HashSet<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Matcher nameMatcher = PARAM_PATTERN.matcher(name);
            if (!nameMatcher.matches()) continue;
            String paramType = nameMatcher.group(1);
            String paramName = nameMatcher.group(2);
            if ("portletPreferences".equals(paramType)) {
                preferenceNames.add(paramName);
                continue;
            }
            if (!"parameters".equals(paramType)) continue;
            parameterNames.add(paramName);
        }
        PortletPublishingDefinition cpd = this.portletPublishingDefinitionDao.getChannelPublishingDefinition(form.getTypeId());
        for (Step step : cpd.getSteps()) {
            List preferences;
            List parameters = step.getParameters();
            if (parameters != null) {
                for (Parameter parameter : parameters) {
                    ParameterInputType parameterInputType;
                    JAXBElement parameterInput = parameter.getParameterInput();
                    if (parameterInput == null || (parameterInputType = (ParameterInputType)parameterInput.getValue()) == null || parameterInputType.getDefault() == null) continue;
                    parameterNames.add(parameter.getName());
                }
            }
            if ((preferences = step.getPreferences()) == null) continue;
            for (Preference preference : preferences) {
                SingleValuedPreferenceInputType SingleValuedPreferenceInputType2;
                JAXBElement preferenceInput = preference.getPreferenceInput();
                PreferenceInputType preferenceInputType = (PreferenceInputType)preferenceInput.getValue();
                if (preferenceInputType instanceof MultiValuedPreferenceInputType) {
                    MultiValuedPreferenceInputType multiValuedPreferenceInputType = (MultiValuedPreferenceInputType)preferenceInputType;
                    List defaultValues = multiValuedPreferenceInputType.getDefaults();
                    if (defaultValues == null || defaultValues.isEmpty()) continue;
                    preferenceNames.add(preference.getName());
                    continue;
                }
                if (!(preferenceInputType instanceof SingleValuedPreferenceInputType) || (SingleValuedPreferenceInputType2 = (SingleValuedPreferenceInputType)preferenceInputType).getDefault() == null) continue;
                preferenceNames.add(preference.getName());
            }
        }
        if (!this.supportsConfigMode(form)) {
            Map portletPreferences = form.getPortletPreferences();
            Map portletPreferencesOverrides = form.getPortletPreferenceReadOnly();
            Iterator portletPreferenceEntryItr = portletPreferences.entrySet().iterator();
            while (portletPreferenceEntryItr.hasNext()) {
                Map.Entry portletPreferenceEntry = portletPreferenceEntryItr.next();
                String key = (String)portletPreferenceEntry.getKey();
                StringListAttribute valueAttr = (StringListAttribute)portletPreferenceEntry.getValue();
                if (!preferenceNames.contains(key) || valueAttr == null) {
                    portletPreferenceEntryItr.remove();
                    portletPreferencesOverrides.remove(key);
                    continue;
                }
                List values = valueAttr.getValue();
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    String value = (String)iter.next();
                    if (value != null) continue;
                    iter.remove();
                }
                if (values.size() != 0) continue;
                portletPreferenceEntryItr.remove();
                portletPreferencesOverrides.remove(key);
            }
        }
        Map parameters = form.getParameters();
        Iterator parameterEntryItr = parameters.entrySet().iterator();
        while (parameterEntryItr.hasNext()) {
            Map.Entry parameterEntry = parameterEntryItr.next();
            String key = (String)parameterEntry.getKey();
            Attribute value = (Attribute)parameterEntry.getValue();
            if (parameterNames.contains(key) && value != null && !StringUtils.isBlank((String)value.getValue())) continue;
            parameterEntryItr.remove();
        }
    }

    public List<PortletApplicationDefinition> getPortletApplications() {
        PortletRegistryService portletRegistryService = this.portalDriverContainerServices.getPortletRegistryService();
        ArrayList<PortletApplicationDefinition> contexts = new ArrayList<PortletApplicationDefinition>();
        Iterator iter = portletRegistryService.getRegisteredPortletApplicationNames();
        while (iter.hasNext()) {
            PortletApplicationDefinition applicationDefninition;
            String applicationName = (String)iter.next();
            try {
                applicationDefninition = portletRegistryService.getPortletApplication(applicationName);
            }
            catch (PortletContainerException e) {
                throw new RuntimeException("Failed to load PortletApplicationDefinition for '" + applicationName + "'");
            }
            List portlets = applicationDefninition.getPortlets();
            Collections.sort(portlets, new /* Unavailable Anonymous Inner Class!! */);
            contexts.add(applicationDefninition);
        }
        Collections.sort(contexts, new /* Unavailable Anonymous Inner Class!! */);
        return contexts;
    }

    public PortletDefinition getPortletDescriptor(PortletDefinitionForm form) {
        Tuple portletDescriptorKeys = this.getPortletDescriptorKeys(form);
        if (portletDescriptorKeys == null) {
            return null;
        }
        String portletAppId = (String)portletDescriptorKeys.first;
        String portletName = (String)portletDescriptorKeys.second;
        PortletRegistryService portletRegistryService = this.portalDriverContainerServices.getPortletRegistryService();
        try {
            PortletDefinition portletDD = portletRegistryService.getPortlet(portletAppId, portletName);
            return portletDD;
        }
        catch (PortletContainerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void prepopulatePortlet(String application, String portlet, PortletDefinitionForm form) {
        PortletDefinition portletDD;
        PortletRegistryService portletRegistryService = this.portalDriverContainerServices.getPortletRegistryService();
        try {
            portletDD = portletRegistryService.getPortlet(application, portlet);
        }
        catch (PortletContainerException e) {
            this.logger.warn((Object)("Failed to load portlet descriptor for appId='" + application + "', portletName='" + portlet + "'"), (Throwable)e);
            return;
        }
        form.setTitle(portletDD.getPortletName());
        form.setName(portletDD.getPortletName());
        form.setApplicationId(application);
        form.setPortletName(portletDD.getPortletName());
        for (Supports supports : portletDD.getSupports()) {
            for (String mode : supports.getPortletModes()) {
                if ("edit".equals(mode)) {
                    form.setEditable(true);
                    continue;
                }
                if (!"help".equals(mode)) continue;
                form.setHasHelp(true);
            }
        }
    }

    public PortletLifecycleState[] getLifecycleStates() {
        return PortletLifecycleState.values();
    }

    public Set<PortletLifecycleState> getAllowedLifecycleStates(IPerson person, List<JsonEntityBean> categories) {
        TreeSet<PortletLifecycleState> states = new TreeSet<PortletLifecycleState>();
        if (this.hasLifecyclePermission(person, PortletLifecycleState.EXPIRED, categories)) {
            states.add(PortletLifecycleState.CREATED);
            states.add(PortletLifecycleState.APPROVED);
            states.add(PortletLifecycleState.EXPIRED);
            states.add(PortletLifecycleState.PUBLISHED);
        } else if (this.hasLifecyclePermission(person, PortletLifecycleState.PUBLISHED, categories)) {
            states.add(PortletLifecycleState.CREATED);
            states.add(PortletLifecycleState.APPROVED);
            states.add(PortletLifecycleState.PUBLISHED);
        } else if (this.hasLifecyclePermission(person, PortletLifecycleState.APPROVED, categories)) {
            states.add(PortletLifecycleState.CREATED);
            states.add(PortletLifecycleState.APPROVED);
        } else if (this.hasLifecyclePermission(person, PortletLifecycleState.CREATED, categories)) {
            states.add(PortletLifecycleState.CREATED);
        }
        return states;
    }

    public boolean hasLifecyclePermission(IPerson person, PortletLifecycleState state, List<JsonEntityBean> categories) {
        String activity;
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        switch (3.$SwitchMap$org$jasig$portal$portlet$om$PortletLifecycleState[state.ordinal()]) {
            case 1: {
                activity = "MANAGE_APPROVED";
                break;
            }
            case 2: {
                activity = "MANAGE_CREATED";
                break;
            }
            case 3: {
                activity = "MANAGE";
                break;
            }
            case 4: {
                activity = "MANAGE_EXPIRED";
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        if (ap.hasPermission("UP_FRAMEWORK", activity, "ALL_PORTLETS")) {
            this.logger.debug((Object)("Found permission for category ALL_PORTLETS and lifecycle state " + state.toString()));
            return true;
        }
        for (JsonEntityBean category : categories) {
            if (!ap.canManage(state, category.getId())) continue;
            this.logger.debug((Object)("Found permission for category " + category.getName() + " and lifecycle state " + state.toString()));
            return true;
        }
        this.logger.debug((Object)("No permission for lifecycle state " + state.toString()));
        return false;
    }

    public IPortletWindowId getDelegateWindowId(ExternalContext externalContext, String fname) {
        PortletRequest nativeRequest = (PortletRequest)externalContext.getNativeRequest();
        PortletSession portletSession = nativeRequest.getPortletSession();
        return (IPortletWindowId)portletSession.getAttribute("DELEGATE_WINDOW_ID__" + fname);
    }

    public boolean configModeAction(ExternalContext externalContext, String fname) throws IOException {
        ActionRequest actionRequest = (ActionRequest)externalContext.getNativeRequest();
        ActionResponse actionResponse = (ActionResponse)externalContext.getNativeResponse();
        IPortletWindowId portletWindowId = this.getDelegateWindowId(externalContext, fname);
        if (portletWindowId == null) {
            throw new IllegalStateException("Cannot execute configModeAciton without a delegate window ID in the session for key: DELEGATE_WINDOW_ID__" + fname);
        }
        PortletDelegationDispatcher requestDispatcher = this.portletDelegationLocator.getRequestDispatcher((PortletRequest)actionRequest, portletWindowId);
        DelegationActionResponse delegationResponse = requestDispatcher.doAction(actionRequest, actionResponse);
        String redirectLocation = delegationResponse.getRedirectLocation();
        DelegateState delegateState = delegationResponse.getDelegateState();
        return redirectLocation != null || delegationResponse.getPortletMode() != null && !IPortletRenderer.CONFIG.equals((Object)delegationResponse.getPortletMode()) || !IPortletRenderer.CONFIG.equals((Object)delegateState.getPortletMode());
    }

    public boolean offerPortletSelection(PortletDefinitionForm form) {
        IPortletType portletType = this.portletTypeRegistry.getPortletType(form.getTypeId());
        PortletPublishingDefinition portletPublishingDefinition = this.portletPublishingDefinitionDao.getChannelPublishingDefinition(portletType.getId());
        PortletDescriptor portletDescriptor = portletPublishingDefinition.getPortletDescriptor();
        if (portletDescriptor == null) {
            return true;
        }
        Boolean isFramework = portletDescriptor.isIsFramework();
        if (isFramework != null && isFramework.booleanValue()) {
            form.setFramework(isFramework.booleanValue());
        } else {
            String webAppName = portletDescriptor.getWebAppName();
            form.setApplicationId(webAppName);
        }
        String portletName = portletDescriptor.getPortletName();
        form.setPortletName(portletName);
        return false;
    }

    protected Tuple<String, String> getPortletDescriptorKeys(PortletDefinitionForm form) {
        if (form.getPortletName() == null || form.getApplicationId() == null && !form.isFramework()) {
            return null;
        }
        String portletAppId = form.isFramework() ? this.servletContext.getContextPath() : form.getApplicationId();
        String portletName = form.getPortletName();
        return new Tuple((Object)portletAppId, (Object)portletName);
    }
}

