/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.PortletLifecycleState;
import org.jasig.portal.portletpublishing.xml.MultiValuedPreferenceInputType;
import org.jasig.portal.portletpublishing.xml.Parameter;
import org.jasig.portal.portletpublishing.xml.ParameterInputType;
import org.jasig.portal.portletpublishing.xml.PortletPublishingDefinition;
import org.jasig.portal.portletpublishing.xml.Preference;
import org.jasig.portal.portletpublishing.xml.PreferenceInputType;
import org.jasig.portal.portletpublishing.xml.SingleValuedPreferenceInputType;
import org.jasig.portal.portletpublishing.xml.Step;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.AttributeFactory;
import org.jasig.portal.portlets.BooleanAttribute;
import org.jasig.portal.portlets.BooleanAttributeFactory;
import org.jasig.portal.portlets.StringListAttribute;
import org.jasig.portal.portlets.StringListAttributeFactory;

public class PortletDefinitionForm
implements Serializable {
    private static final long serialVersionUID = 892741367149099647L;
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private String id = null;
    private String fname = "";
    private String name = "";
    private String description = "";
    private String title = "";
    private String applicationId = "";
    private String portletName = "";
    private boolean framework = false;
    private int timeout = 5000;
    private int typeId;
    private PortletLifecycleState lifecycleState = PortletLifecycleState.CREATED;
    private Date publishDate;
    private int publishHour = 12;
    private int publishMinute = 0;
    private int publishAmPm = 0;
    private Date expirationDate;
    private int expirationHour = 12;
    private int expirationMinute = 0;
    private int expirationAmPm = 0;
    private boolean editable;
    private boolean hasHelp;
    private boolean hasAbout;
    private List<JsonEntityBean> groups = new ArrayList();
    private List<JsonEntityBean> categories = new ArrayList();
    private Map<String, Attribute> parameters = LazyMap.decorate(new HashMap(), (Factory)new AttributeFactory());
    private Map<String, StringListAttribute> portletPreferences = LazyMap.decorate(new HashMap(), (Factory)new StringListAttributeFactory());
    private Map<String, BooleanAttribute> portletPreferenceReadOnly = LazyMap.decorate(new HashMap(), (Factory)new BooleanAttributeFactory());

    public PortletDefinitionForm() {
    }

    public PortletDefinitionForm(IPortletDefinition def) {
        this.setId(def.getPortletDefinitionId().getStringId());
        this.setFname(def.getFName());
        this.setName(def.getName());
        this.setDescription(def.getDescription());
        this.setTitle(def.getTitle());
        this.setTimeout(def.getTimeout());
        this.setTypeId(def.getType().getId());
        this.setApplicationId(def.getPortletDescriptorKey().getWebAppName());
        this.setPortletName(def.getPortletDescriptorKey().getPortletName());
        this.setFramework(def.getPortletDescriptorKey().isFrameworkPortlet());
        if (def.getParameter("editable") != null) {
            this.setEditable(Boolean.parseBoolean(def.getParameter("editable").getValue()));
        }
        if (def.getParameter("hasHelp") != null) {
            this.setHasHelp(Boolean.parseBoolean(def.getParameter("hasHelp").getValue()));
        }
        if (def.getParameter("hasAbout") != null) {
            this.setHasAbout(Boolean.parseBoolean(def.getParameter("hasAbout").getValue()));
        }
        this.setLifecycleState(def.getLifecycleState());
        int order = this.getLifecycleState().getOrder();
        if (order < PortletLifecycleState.PUBLISHED.getOrder()) {
            this.setPublishDateTime(def.getPublishDate());
        }
        if (order < PortletLifecycleState.EXPIRED.getOrder()) {
            this.setExpirationDateTime(def.getExpirationDate());
        }
        for (IPortletDefinitionParameter param : def.getParameters()) {
            if (param.getName().startsWith("PORTLET.")) {
                this.portletPreferences.put(param.getName(), new StringListAttribute(new String[]{param.getValue()}));
                continue;
            }
            this.parameters.put(param.getName(), new Attribute(param.getValue()));
        }
        for (IPortletPreference pref : def.getPortletPreferences()) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (String value : pref.getValues()) {
                attributes.add(new Attribute(value));
            }
            this.portletPreferences.put(pref.getName(), new StringListAttribute(pref.getValues()));
            this.portletPreferenceReadOnly.put(pref.getName(), new BooleanAttribute(pref.isReadOnly()));
        }
    }

    public void setChannelPublishingDefinition(PortletPublishingDefinition cpd) {
        for (Step step : cpd.getSteps()) {
            if (step.getParameters() != null) {
                for (Parameter param : step.getParameters()) {
                    ParameterInputType input;
                    Attribute attribute = (Attribute)this.parameters.get(param.getName());
                    if (attribute != null && attribute.getValue() != null && !attribute.getValue().trim().equals("") || (input = (ParameterInputType)param.getParameterInput().getValue()) == null) continue;
                    this.parameters.put(param.getName(), new Attribute(input.getDefault()));
                }
            }
            if (step.getPreferences() == null) continue;
            for (Preference pref : step.getPreferences()) {
                MultiValuedPreferenceInputType multiValued;
                PreferenceInputType input;
                if (this.portletPreferences.containsKey(pref.getName()) && ((StringListAttribute)this.portletPreferences.get(pref.getName())).getValue().size() != 0 && (((StringListAttribute)this.portletPreferences.get(pref.getName())).getValue().size() != 1 || !((String)((StringListAttribute)this.portletPreferences.get(pref.getName())).getValue().get(0)).trim().equals(""))) continue;
                if (!this.portletPreferences.containsKey(pref.getName())) {
                    this.portletPreferences.put(pref.getName(), new StringListAttribute());
                }
                if ((input = (PreferenceInputType)pref.getPreferenceInput().getValue()) instanceof SingleValuedPreferenceInputType) {
                    SingleValuedPreferenceInputType singleValued = (SingleValuedPreferenceInputType)input;
                    if (singleValued.getDefault() == null) continue;
                    ((StringListAttribute)this.portletPreferences.get(pref.getName())).getValue().add(singleValued.getDefault());
                    continue;
                }
                if (!(input instanceof MultiValuedPreferenceInputType) || (multiValued = (MultiValuedPreferenceInputType)input).getDefaults() == null) continue;
                ((StringListAttribute)this.portletPreferences.get(pref.getName())).getValue().addAll(multiValued.getDefaults());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String name) {
        this.fname = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isPortlet() {
        return true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public boolean isFramework() {
        return this.framework;
    }

    public void setFramework(boolean framework) {
        this.framework = framework;
    }

    public void setLifecycleState(PortletLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    public void setLifecycleState(String lifecycleState) {
        for (PortletLifecycleState state : PortletLifecycleState.values()) {
            if (!state.toString().equals(lifecycleState)) continue;
            this.lifecycleState = state;
            break;
        }
    }

    public PortletLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isHasHelp() {
        return this.hasHelp;
    }

    public void setHasHelp(boolean hasHelp) {
        this.hasHelp = hasHelp;
    }

    public boolean isHasAbout() {
        return this.hasAbout;
    }

    public void setHasAbout(boolean hasAbout) {
        this.hasAbout = hasAbout;
    }

    public Map<String, Attribute> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Attribute> parameters) {
        this.parameters = parameters;
    }

    public Map<String, StringListAttribute> getPortletPreferences() {
        return this.portletPreferences;
    }

    public void setPortletPreferences(Map<String, StringListAttribute> portletParameters) {
        this.portletPreferences = portletParameters;
    }

    public Map<String, BooleanAttribute> getPortletPreferenceReadOnly() {
        return this.portletPreferenceReadOnly;
    }

    public void setPortletPreferenceReadOnly(Map<String, BooleanAttribute> portletPreferenceReadOnly) {
        this.portletPreferenceReadOnly = portletPreferenceReadOnly;
    }

    public List<JsonEntityBean> getGroups() {
        return this.groups;
    }

    public void setGroups(List<JsonEntityBean> groups) {
        this.groups = groups;
    }

    public void addGroup(JsonEntityBean group) {
        this.groups.add(group);
    }

    public List<JsonEntityBean> getCategories() {
        return this.categories;
    }

    public void setCategories(List<JsonEntityBean> categories) {
        this.categories = categories;
    }

    public void addCategory(JsonEntityBean category) {
        this.categories.add(category);
    }

    public int getPublishHour() {
        return this.publishHour;
    }

    public void setPublishHour(int publishHour) {
        this.publishHour = publishHour;
    }

    public int getPublishMinute() {
        return this.publishMinute;
    }

    public void setPublishMinute(int publishMinute) {
        this.publishMinute = publishMinute;
    }

    public int getPublishAmPm() {
        return this.publishAmPm;
    }

    public void setPublishAmPm(int publishAmPm) {
        this.publishAmPm = publishAmPm;
    }

    public int getExpirationHour() {
        return this.expirationHour;
    }

    public void setExpirationHour(int expirationHour) {
        this.expirationHour = expirationHour;
    }

    public int getExpirationMinute() {
        return this.expirationMinute;
    }

    public void setExpirationMinute(int expirationMinute) {
        this.expirationMinute = expirationMinute;
    }

    public int getExpirationAmPm() {
        return this.expirationAmPm;
    }

    public void setExpirationAmPm(int expirationAmPm) {
        this.expirationAmPm = expirationAmPm;
    }

    public Date getPublishDateTime() {
        if (this.getPublishDate() == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getPublishDate());
        cal.set(10, this.getPublishHour());
        cal.set(12, this.getPublishMinute());
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(9, this.getPublishAmPm());
        return cal.getTime();
    }

    public Date getExpirationDateTime() {
        if (this.getExpirationDate() == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getExpirationDate());
        cal.set(10, this.getExpirationHour());
        cal.set(12, this.getExpirationMinute());
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(9, this.getExpirationAmPm());
        return cal.getTime();
    }

    public void setPublishDateTime(Date publish) {
        if (publish != null) {
            this.setPublishDate(publish);
            Calendar cal = Calendar.getInstance();
            cal.setTime(publish);
            if (cal.get(10) == 0) {
                this.setPublishHour(12);
            } else {
                this.setPublishHour(cal.get(10));
            }
            this.setPublishMinute(cal.get(12));
            this.setPublishAmPm(cal.get(9));
        }
    }

    public void setExpirationDateTime(Date expire) {
        if (expire != null) {
            this.setExpirationDate(expire);
            Calendar cal = Calendar.getInstance();
            cal.setTime(expire);
            if (cal.get(10) == 0) {
                this.setExpirationHour(12);
            } else {
                this.setExpirationHour(cal.get(10));
            }
            this.setExpirationMinute(cal.get(12));
            this.setExpirationAmPm(cal.get(9));
        }
    }
}

