/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.dao.usertype.FunctionalNameType;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portletpublishing.xml.Parameter;
import org.jasig.portal.portletpublishing.xml.PortletPublishingDefinition;
import org.jasig.portal.portletpublishing.xml.Step;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.portletadmin.PortletDefinitionForm;
import org.jasig.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.validation.ValidationContext;
import org.springframework.stereotype.Service;

@Service(value="portletValidator")
public class PortletDefinitionFormValidator {
    private IChannelPublishingDefinitionDao channelPublishingDefinitionDao;
    private IPortletDefinitionRegistry portletDefinitionRegistry;

    @Autowired(required=true)
    public void setChannelPublishingDefinitionDao(IChannelPublishingDefinitionDao channelPublishingDefinitionDao) {
        this.channelPublishingDefinitionDao = channelPublishingDefinitionDao;
    }

    @Autowired(required=true)
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public void validateChooseType(PortletDefinitionForm def, MessageContext context) {
        if (def.getTypeId() == 0) {
            context.addMessage(new MessageBuilder().error().source((Object)"typeId").code("please.choose.portlet.type").build());
        }
    }

    public void validateBasicInfo(PortletDefinitionForm def, MessageContext context) {
        if (StringUtils.isEmpty((String)def.getFname())) {
            context.addMessage(new MessageBuilder().error().source((Object)"fName").code("please.enter.fname").build());
        } else if (!FunctionalNameType.isValid((String)def.getFname())) {
            context.addMessage(new MessageBuilder().error().source((Object)"fName").code("fname.invalid").build());
        } else if (def.getId() == null && this.portletDefinitionRegistry.getPortletDefinitionByFname(def.getFname()) != null) {
            context.addMessage(new MessageBuilder().error().source((Object)"fName").code("fname.in.use").build());
        }
        if (StringUtils.isEmpty((String)def.getTitle())) {
            context.addMessage(new MessageBuilder().error().source((Object)"title").code("please.enter.title").build());
        }
        if (StringUtils.isEmpty((String)def.getName())) {
            context.addMessage(new MessageBuilder().error().source((Object)"name").code("please.enter.name").build());
        }
        if (def.getId() == null && this.portletDefinitionRegistry.getPortletDefinitionByName(def.getName()) != null) {
            context.addMessage(new MessageBuilder().error().source((Object)"name").code("name.in.use").build());
        }
    }

    public void validateSetParameters(PortletDefinitionForm def, MessageContext context) {
        PortletPublishingDefinition cpd = this.channelPublishingDefinitionDao.getChannelPublishingDefinition(def.getTypeId());
        for (Step step : cpd.getSteps()) {
            if (step.getParameters() == null) continue;
            for (Parameter param : step.getParameters()) {
                if (!def.getParameters().containsKey(param.getName()) || StringUtils.isEmpty((String)((Attribute)def.getParameters().get(param.getName())).getValue())) continue;
                String paramValue = ((Attribute)def.getParameters().get(param.getName())).getValue();
                String paramPath = "parameters['" + param.getName() + "'].value";
            }
        }
    }

    public void validateChooseCategory(PortletDefinitionForm def, MessageContext context) {
        if (def.getCategories().size() == 0) {
            context.addMessage(new MessageBuilder().error().source((Object)"categories").code("please.choose.at.least.one.category").build());
        }
    }

    public void validateChooseGroup(PortletDefinitionForm def, MessageContext context) {
        if (def.getGroups().size() == 0) {
            context.addMessage(new MessageBuilder().error().source((Object)"groups").code("please.choose.at.least.one.group").build());
        }
    }

    public void validateLifecycle(PortletDefinitionForm def, ValidationContext context) {
        MessageContext messageContext = context.getMessageContext();
        if (def.getLifecycleState() == null) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"lifecycle").code("please.select.lifecycle.stage").build());
        }
        Date now = new Date();
        if (def.getPublishDate() != null && def.getPublishDateTime().before(now)) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"publishDate").code("auto.publish.date.must.be.future").build());
        }
        if (def.getExpirationDate() != null && def.getExpirationDateTime().before(now)) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"expirationDate").code("auto.expire.date.must.be.future").build());
        }
        if (def.getPublishDate() != null && def.getExpirationDate() != null && def.getExpirationDateTime().before(def.getPublishDateTime())) {
            messageContext.addMessage(new MessageBuilder().error().source((Object)"expirationDate").code("auto.expire.date.must.be.after.publish").build());
        }
    }

    public void checkSave(PortletDefinitionForm def, ValidationContext context) {
        this.validateBasicInfo(def, context.getMessageContext());
        this.validateChooseType(def, context.getMessageContext());
        this.validateSetParameters(def, context.getMessageContext());
        this.validateChooseGroup(def, context.getMessageContext());
    }
}

