/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin.xmlsupport;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.portlet.registry.IPortletTypeRegistry;
import org.jasig.portal.portletpublishing.xml.PortletPublishingDefinition;
import org.jasig.portal.portletpublishing.xml.Step;
import org.jasig.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.jasig.portal.portlets.portletadmin.xmlsupport.XmlChannelPublishingDefinitionDao;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service(value="channelPublishingDefinitionDao")
public class XmlChannelPublishingDefinitionDao
implements IChannelPublishingDefinitionDao,
ResourceLoaderAware,
InitializingBean {
    private static final String CUSTOM_CPD_PATH = "/org/jasig/portal/portlets/portletadmin/CustomChannel.cpd";
    private static final String SHARED_PARAMETERS_PATH = "/org/jasig/portal/portlets/SharedParameters.cpd.xml";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Unmarshaller unmarshaller;
    private MapCachingDoubleCheckedCreator<Integer, PortletPublishingDefinition> cpdCreator;
    private List<Step> sharedParameters;
    private Map<Integer, PortletPublishingDefinition> cpdCache;
    private IPortletTypeRegistry portletTypeRegistry;
    private ResourceLoader resourceLoader;

    public XmlChannelPublishingDefinitionDao() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PortletPublishingDefinition.class});
        this.unmarshaller = context.createUnmarshaller();
    }

    @Resource(name="cpdCache")
    public void setCpdCache(Map<Integer, PortletPublishingDefinition> cpdCache) {
        this.cpdCache = cpdCache;
    }

    @Autowired(required=true)
    public void setPortletTypeRegistry(IPortletTypeRegistry portletTypeRegistry) {
        this.portletTypeRegistry = portletTypeRegistry;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.cpdCreator = new CpdCreator(this, this.cpdCache);
    }

    public PortletPublishingDefinition getChannelPublishingDefinition(int channelTypeId) {
        return (PortletPublishingDefinition)this.cpdCreator.get(new Object[]{channelTypeId});
    }

    public Map<IPortletType, PortletPublishingDefinition> getChannelPublishingDefinitions() {
        List channelTypes = this.portletTypeRegistry.getPortletTypes();
        LinkedHashMap<IPortletType, PortletPublishingDefinition> cpds = new LinkedHashMap<IPortletType, PortletPublishingDefinition>(channelTypes.size());
        for (IPortletType channelType : channelTypes) {
            PortletPublishingDefinition cpd = this.getChannelPublishingDefinition(channelType.getId());
            cpds.put(channelType, cpd);
        }
        return cpds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletPublishingDefinition loadChannelPublishingDefinition(int channelTypeId) {
        InputStream cpdStream;
        String cpdUri;
        if (channelTypeId >= 0) {
            IPortletType type = this.portletTypeRegistry.getPortletType(channelTypeId);
            if (type == null) {
                throw new IllegalArgumentException("No ChannelType registered with id: " + channelTypeId);
            }
            cpdUri = type.getCpdUri();
        } else {
            cpdUri = CUSTOM_CPD_PATH;
        }
        org.springframework.core.io.Resource cpdResource = this.resourceLoader.getResource("classpath:" + cpdUri);
        if (!cpdResource.exists()) {
            throw new MissingResourceException("Failed to find CPD '" + cpdUri + "' for channel type " + channelTypeId, this.getClass().getName(), cpdUri);
        }
        try {
            cpdStream = cpdResource.getInputStream();
        }
        catch (IOException e) {
            throw new MissingResourceException("Failed to load CPD '" + cpdUri + "' for channel type " + channelTypeId, this.getClass().getName(), cpdUri);
        }
        try {
            PortletPublishingDefinition def = (PortletPublishingDefinition)this.unmarshaller.unmarshal(cpdStream);
            List sharedParameters = this.getSharedParameters();
            def.getSteps().addAll(sharedParameters);
            this.cpdCache.put(channelTypeId, def);
            PortletPublishingDefinition portletPublishingDefinition = def;
            return portletPublishingDefinition;
        }
        catch (JAXBException e) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)cpdStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Step> getSharedParameters() {
        InputStream paramStream;
        if (this.sharedParameters != null) {
            return this.sharedParameters;
        }
        org.springframework.core.io.Resource paramResource = this.resourceLoader.getResource("classpath:/org/jasig/portal/portlets/SharedParameters.cpd.xml");
        if (!paramResource.exists()) {
            throw new MissingResourceException("Failed to find shared parameters CPD '/org/jasig/portal/portlets/SharedParameters.cpd.xml'", this.getClass().getName(), SHARED_PARAMETERS_PATH);
        }
        try {
            paramStream = paramResource.getInputStream();
        }
        catch (IOException e) {
            throw new MissingResourceException("Failed to load CPD '/org/jasig/portal/portlets/SharedParameters.cpd.xml'", this.getClass().getName(), SHARED_PARAMETERS_PATH);
        }
        try {
            PortletPublishingDefinition config = (PortletPublishingDefinition)this.unmarshaller.unmarshal(paramStream);
            this.sharedParameters = config.getSteps();
        }
        catch (JAXBException e) {
            this.logger.warn((Object)("Failed to parse: " + paramResource), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)paramStream);
        }
        return this.sharedParameters;
    }

    static /* synthetic */ PortletPublishingDefinition access$000(XmlChannelPublishingDefinitionDao x0, int x1) {
        return x0.loadChannelPublishingDefinition(x1);
    }
}

