/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.search;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.utils.Tuple;

public class PortalSearchResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> defaultTab;
    private final Map<String, Set<String>> resultTypeMappings;
    private final LoadingCache<String, List<Tuple<SearchResult, String>>> results;

    public PortalSearchResults(String defaultTab, Map<String, Set<String>> resultTypeMappings) {
        this.defaultTab = ImmutableSet.of((Object)defaultTab);
        this.resultTypeMappings = resultTypeMappings;
        this.results = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ConcurrentMap<String, List<Tuple<SearchResult, String>>> getResults() {
        return this.results.asMap();
    }

    public void addPortletSearchResults(String url, SearchResult result) {
        Set tabs = this.getTabs(result);
        for (String tab : tabs) {
            List typeResults = (List)this.results.getUnchecked((Object)tab);
            typeResults.add(new Tuple((Object)result, (Object)url));
        }
    }

    protected Set<String> getTabs(SearchResult result) {
        List types = result.getType();
        if (types == null || types.isEmpty()) {
            return this.defaultTab;
        }
        HashSet<String> tabs = new HashSet<String>();
        for (String type : types) {
            Set mappedTabs = (Set)this.resultTypeMappings.get(type);
            if (mappedTabs != null) {
                tabs.addAll(mappedTabs);
                continue;
            }
            tabs.addAll(this.defaultTab);
        }
        return tabs;
    }
}

