/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.search.gsa;

import java.util.HashMap;
import javax.portlet.PortletRequest;
import org.jasig.portal.portlets.search.IPortalSearchService;
import org.jasig.portal.portlets.search.gsa.GsaResults;
import org.jasig.portal.portlets.search.gsa.GsaSearchResult;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class GsaSearchService
implements IPortalSearchService {
    private RestTemplate restTemplate;
    private String urlTemplate = "{baseUrl}?q={query}&site={site}&entqr=0&ud=1&sort=date%3AD%3AL%3Ad1&output=xml_no_dtd&oe=UTF-8&ie=UTF-8&proxyreload=1&entsp=0";
    private String gsaBaseUrl;
    private String gsaSite;
    private String resultType = "googleAppliance";

    @Autowired(required=true)
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public void setBaseUrl(String gsaBaseUrl) {
        this.gsaBaseUrl = gsaBaseUrl;
    }

    public void setSite(String gsaSite) {
        this.gsaSite = gsaSite;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public SearchResults getSearchResults(PortletRequest request, SearchRequest query) {
        SearchResults results = this.search(query.getSearchTerms());
        results.setQueryId(query.getQueryId());
        results.setWindowId(request.getWindowID());
        return results;
    }

    protected SearchResults search(String query) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("query", query);
        vars.put("baseUrl", this.gsaBaseUrl);
        vars.put("site", this.gsaSite);
        GsaResults gsaResults = (GsaResults)this.restTemplate.getForObject(this.urlTemplate, GsaResults.class, vars);
        SearchResults results = new SearchResults();
        for (GsaSearchResult gsaResult : gsaResults.getSearchResults()) {
            SearchResult result = new SearchResult();
            result.setTitle(gsaResult.getTitle());
            result.setExternalUrl(gsaResult.getLink());
            result.setSummary(gsaResult.getSnippet());
            result.getType().add(this.resultType);
            results.getSearchResult().add(result);
        }
        return results;
    }
}

