/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.search.portletregistry;

import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlets.search.IPortalSearchService;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.springframework.beans.factory.annotation.Autowired;

public class PortletRegistrySearchService
implements IPortalSearchService {
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalUrlProvider portalUrlProvider;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortalRequestUtils portalRequestUtils;

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider urlProvider) {
        this.portalUrlProvider = urlProvider;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        this.portalRequestUtils = portalRequestUtils;
    }

    public SearchResults getSearchResults(PortletRequest request, SearchRequest query) {
        String queryString = query.getSearchTerms().toLowerCase();
        List portlets = this.portletDefinitionRegistry.getAllPortletDefinitions();
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getPortletHttpRequest(request);
        SearchResults results = new SearchResults();
        for (IPortletDefinition portlet : portlets) {
            if (!this.matches(queryString, portlet)) continue;
            SearchResult result = new SearchResult();
            result.setTitle(portlet.getTitle());
            result.setSummary(portlet.getDescription());
            result.getType().add("Portal Content");
            IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByFname(httpServletRequest, portlet.getFName());
            if (portletWindow == null) continue;
            IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
            IPortalUrlBuilder portalUrlBuilder = this.portalUrlProvider.getPortalUrlBuilderByPortletFName(httpServletRequest, portlet.getFName(), UrlType.RENDER);
            IPortletUrlBuilder portletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(portletWindowId);
            portletUrlBuilder.setWindowState(PortletUtils.getWindowState((String)"maximized"));
            result.setExternalUrl(portalUrlBuilder.getUrlString());
            results.getSearchResult().add(result);
        }
        return results;
    }

    protected boolean matches(String query, IPortletDefinition portlet) {
        return portlet.getTitle().toLowerCase().contains(query) || portlet.getName().toLowerCase().contains(query) || portlet.getDescription() != null && portlet.getDescription().toLowerCase().contains(query) || portlet.getFName().toLowerCase().contains(query);
    }
}

